/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.util.BufferStream;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.SharedFileInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;

public class SpamExtract {
    private static Log mLog = LogFactory.getLog(SpamExtract.class);
    private static Options mOptions = new Options();
    private static boolean mVerbose;
    public static final String TYPE_MESSAGE = "message";
    private static Session mJMSession;
    private static String mOutputPrefix;
    private static int mExtractIndex;
    private static final int MAX_BUFFER_SIZE = 0xA00000;

    private static void usage(String errmsg) {
        if (errmsg != null) {
            mLog.error(errmsg);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("zmspamextract [options] ", "where [options] are one of:", mOptions, "SpamExtract retrieve messages that may have been marked as spam or not spam in the Zimbra Web Client.");
        System.exit(errmsg == null ? 0 : 1);
    }

    private static CommandLine parseArgs(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine cl = null;
        try {
            cl = parser.parse(mOptions, args);
        }
        catch (ParseException pe) {
            SpamExtract.usage(pe.getMessage());
        }
        if (cl.hasOption("h")) {
            SpamExtract.usage(null);
        }
        return cl;
    }

    public static void main(String[] args) throws ServiceException, HttpException, SoapFaultException, IOException {
        Account account;
        String optDirectory;
        File outputDirectory;
        CommandLine cl = SpamExtract.parseArgs(args);
        if (cl.hasOption('D')) {
            CliUtil.toolSetup("DEBUG");
        } else {
            CliUtil.toolSetup("INFO");
        }
        if (cl.hasOption('v')) {
            mVerbose = true;
        }
        boolean optDelete = cl.hasOption('d');
        if (!cl.hasOption('o')) {
            SpamExtract.usage("must specify directory to extract messages to");
        }
        if (!(outputDirectory = new File(optDirectory = cl.getOptionValue('o'))).exists()) {
            mLog.info("Creating directory: " + optDirectory);
            outputDirectory.mkdirs();
            if (!outputDirectory.exists()) {
                mLog.error("could not create directory " + optDirectory);
                System.exit(2);
            }
        }
        String optAdminUser = cl.hasOption('a') ? cl.getOptionValue('a') : LC.zimbra_ldap_user.value();
        String optAdminPassword = cl.hasOption('p') ? cl.getOptionValue('p') : LC.zimbra_ldap_password.value();
        String optQuery = "in:inbox";
        if (cl.hasOption('q')) {
            optQuery = cl.getOptionValue('q');
        }
        if ((account = SpamExtract.getAccount(cl)) == null) {
            System.exit(1);
        }
        boolean optRaw = cl.hasOption('r');
        if (mVerbose) {
            mLog.info("Extracting from account " + account.getName());
        }
        Server server = Provisioning.getInstance().getServer(account);
        String optAdminURL = cl.hasOption('u') ? cl.getOptionValue('u') : SpamExtract.getSoapURL(server, true);
        String adminAuthToken = SpamExtract.getAdminAuthToken(optAdminURL, optAdminUser, optAdminPassword);
        String authToken = SpamExtract.getDelegateAuthToken(optAdminURL, account, adminAuthToken);
        SpamExtract.extract(authToken, account, server, optQuery, outputDirectory, optDelete, optRaw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extract(String authToken, Account account, Server server, String query, File outdir, boolean delete, boolean raw) throws ServiceException, HttpException, SoapFaultException, IOException {
        String soapURL = SpamExtract.getSoapURL(server, false);
        URL restURL = SpamExtract.getServerURL(server, false);
        HttpClient hc = new HttpClient();
        HttpState state = new HttpState();
        GetMethod gm = new GetMethod();
        gm.setFollowRedirects(true);
        Cookie authCookie = new Cookie(restURL.getHost(), "ZM_AUTH_TOKEN", authToken, "/", -1, false);
        state.addCookie(authCookie);
        hc.setState(state);
        hc.getHostConfiguration().setHost(restURL.getHost(), restURL.getPort(), Protocol.getProtocol(restURL.getProtocol()));
        gm.getParams().setSoTimeout(60000);
        if (mVerbose) {
            mLog.info("Mailbox requests to: " + restURL);
        }
        SoapHttpTransport transport = new SoapHttpTransport(soapURL);
        transport.setRetryCount(1);
        transport.setTimeout(0);
        transport.setAuthToken(authToken);
        int totalProcessed = 0;
        boolean haveMore = true;
        int offset = 0;
        while (haveMore) {
            Object var25_27;
            Element.XMLElement searchReq = new Element.XMLElement(MailConstants.SEARCH_REQUEST);
            ((Element)searchReq).addElement("query").setText(query);
            searchReq.addAttribute("types", TYPE_MESSAGE);
            searchReq.addAttribute("offset", offset);
            try {
                if (mLog.isDebugEnabled()) {
                    mLog.debug(((Element)searchReq).prettyPrint());
                }
                Element searchResp = transport.invoke(searchReq, false, true, account.getId());
                if (mLog.isDebugEnabled()) {
                    mLog.debug(searchResp.prettyPrint());
                }
                StringBuilder deleteList = new StringBuilder();
                Iterator<Element> iter = searchResp.elementIterator("m");
                while (iter.hasNext()) {
                    ++offset;
                    Element e = iter.next();
                    String mid = e.getAttribute("id");
                    if (mid == null) {
                        mLog.warn("null message id SOAP response");
                        continue;
                    }
                    String path = "/service/user/" + account.getName() + "/?id=" + mid;
                    if (SpamExtract.extractMessage(hc, gm, path, outdir, raw)) {
                        deleteList.append(mid).append(',');
                    }
                    ++totalProcessed;
                }
                haveMore = false;
                String more = searchResp.getAttribute("more");
                if (more != null && more.length() > 0) {
                    try {
                        int m = Integer.parseInt(more);
                        if (m > 0) {
                            haveMore = true;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        mLog.warn((Object)("more flag from server not a number: " + more), nfe);
                    }
                }
                if (delete && deleteList.length() > 0) {
                    deleteList.deleteCharAt(deleteList.length() - 1);
                    Element.XMLElement msgActionReq = new Element.XMLElement(MailConstants.MSG_ACTION_REQUEST);
                    Element action = ((Element)msgActionReq).addElement("action");
                    action.addAttribute("id", deleteList.toString());
                    action.addAttribute("op", "delete");
                    if (mLog.isDebugEnabled()) {
                        mLog.debug(((Element)msgActionReq).prettyPrint());
                    }
                    Element msgActionResp = transport.invoke(msgActionReq, false, true, account.getId());
                    if (mLog.isDebugEnabled()) {
                        mLog.debug(msgActionResp.prettyPrint());
                    }
                }
                var25_27 = null;
            }
            catch (Throwable throwable) {
                var25_27 = null;
                gm.releaseConnection();
                throw throwable;
            }
            gm.releaseConnection();
            {
            }
        }
        mLog.info("Total messages processed: " + totalProcessed);
    }

    private static boolean extractMessage(HttpClient hc, GetMethod gm, String path, File outdir, boolean raw) {
        try {
            SpamExtract.extractMessage0(hc, gm, path, outdir, raw);
            return true;
        }
        catch (MessagingException me) {
            mLog.warn((Object)"exception occurred fetching message", me);
        }
        catch (IOException ioe) {
            mLog.warn((Object)"exception occurred fetching message", ioe);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void extractMessage0(HttpClient hc, GetMethod gm, String path, File outdir, boolean raw) throws IOException, MessagingException {
        gm.setPath(path);
        if (mLog.isDebugEnabled()) {
            mLog.debug("Fetching " + path);
        }
        hc.executeMethod(gm);
        if (gm.getStatusCode() != 200) {
            throw new IOException("HTTP GET failed: " + gm.getPath() + ": " + gm.getStatusCode() + ": " + gm.getStatusText());
        }
        if (raw) {
            File file = new File(outdir, mOutputPrefix + "-" + mExtractIndex++);
            BufferedOutputStream os = null;
            try {
                block11: {
                    try {
                        os = new BufferedOutputStream(new FileOutputStream(file));
                        ByteUtil.copy(gm.getResponseBodyAsStream(), true, os, false);
                        if (!mVerbose) break block11;
                        mLog.info("Wrote: " + file);
                    }
                    catch (IOException e) {
                        String fileName = outdir + "/" + mOutputPrefix + "-" + mExtractIndex;
                        mLog.error((Object)("Cannot write to " + fileName), e);
                        Object var10_10 = null;
                        if (os == null) return;
                        ((OutputStream)os).close();
                        return;
                    }
                }
                Object var10_9 = null;
                if (os == null) return;
                ((OutputStream)os).close();
                return;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (os == null) throw throwable;
                ((OutputStream)os).close();
                throw throwable;
            }
        }
        BufferStream buffer = new BufferStream(gm.getResponseContentLength(), 0xA00000);
        buffer.setSequenced(false);
        MimeMessage mm = null;
        SharedFileInputStream sfis = null;
        try {
            ByteUtil.copy(gm.getResponseBodyAsStream(), true, buffer, false);
            if (buffer.isSpooled()) {
                sfis = new SharedFileInputStream(buffer.getFile());
                mm = new MimeMessage(mJMSession, (InputStream)sfis);
            } else {
                mm = new MimeMessage(mJMSession, buffer.getInputStream());
            }
            SpamExtract.writeAttachedMessages(mm, outdir, gm.getPath());
            Object var12_16 = null;
            ByteUtil.closeStream((InputStream)sfis);
            return;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            ByteUtil.closeStream(sfis);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAttachedMessages(MimeMessage mm, File outdir, String msgUri) throws IOException, MessagingException {
        if (!(mm.getContent() instanceof MimeMultipart)) {
            mLog.warn("Spam/notspam messages must have attachments (skipping " + msgUri + ")");
            return;
        }
        MimeMultipart mmp = (MimeMultipart)mm.getContent();
        int nAttachments = mmp.getCount();
        boolean foundAtleastOneAttachedMessage = false;
        for (int i = 0; i < nAttachments; ++i) {
            Object var12_12;
            BodyPart bp = mmp.getBodyPart(i);
            if (!bp.isMimeType("message/rfc822")) continue;
            foundAtleastOneAttachedMessage = true;
            Part msg = (Part)bp.getContent();
            File file = new File(outdir, mOutputPrefix + "-" + mExtractIndex++);
            OutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(file));
                msg.writeTo(os);
                var12_12 = null;
            }
            catch (Throwable throwable) {
                var12_12 = null;
                os.close();
                throw throwable;
            }
            os.close();
            if (!mVerbose) continue;
            mLog.info("Wrote: " + file);
        }
        if (!foundAtleastOneAttachedMessage) {
            String msgid = mm.getHeader("Message-ID", " ");
            mLog.warn("message uri=" + msgUri + " message-id=" + msgid + " had no attachments");
        }
    }

    public static URL getServerURL(Server server, boolean admin) throws ServiceException {
        String host = server.getAttr("zimbraServiceHostname");
        if (host == null) {
            throw ServiceException.FAILURE("invalid zimbraServiceHostname in server " + server.getName(), null);
        }
        String protocol = "http";
        String portAttr = "zimbraMailPort";
        if (admin) {
            protocol = "https";
            portAttr = "zimbraAdminPort";
        } else {
            String mode = server.getAttr("zimbraMailMode");
            if (mode == null) {
                throw ServiceException.FAILURE("null zimbraMailMode in server " + server.getName(), null);
            }
            if (mode.equalsIgnoreCase("https")) {
                protocol = "https";
                portAttr = "zimbraMailSSLPort";
            }
            if (mode.equalsIgnoreCase("redirect")) {
                protocol = "https";
                portAttr = "zimbraMailSSLPort";
            }
        }
        int port = server.getIntAttr(portAttr, -1);
        if (port < 1) {
            throw ServiceException.FAILURE("invalid " + portAttr + " in server " + server.getName(), null);
        }
        try {
            return new URL(protocol, host, port, "");
        }
        catch (MalformedURLException mue) {
            throw ServiceException.FAILURE("exception creating url (protocol=" + protocol + " host=" + host + " port=" + port + ")", mue);
        }
    }

    public static String getSoapURL(Server server, boolean admin) throws ServiceException {
        String url = SpamExtract.getServerURL(server, admin).toString();
        String file = admin ? "/service/admin/soap/" : "/service/soap/";
        return url + file;
    }

    public static String getAdminAuthToken(String adminURL, String adminUser, String adminPassword) throws ServiceException {
        SoapHttpTransport transport = new SoapHttpTransport(adminURL);
        transport.setRetryCount(1);
        transport.setTimeout(0);
        Element.XMLElement authReq = new Element.XMLElement(AdminConstants.AUTH_REQUEST);
        ((Element)authReq).addAttribute("name", adminUser, Element.Disposition.CONTENT);
        ((Element)authReq).addAttribute("password", adminPassword, Element.Disposition.CONTENT);
        try {
            if (mVerbose) {
                mLog.info("Auth request to: " + adminURL);
            }
            if (mLog.isDebugEnabled()) {
                mLog.debug(((Element)authReq).prettyPrint());
            }
            Element authResp = transport.invokeWithoutSession(authReq);
            if (mLog.isDebugEnabled()) {
                mLog.debug(authResp.prettyPrint());
            }
            String authToken = authResp.getAttribute("authToken");
            return authToken;
        }
        catch (Exception e) {
            throw ServiceException.FAILURE("admin auth failed url=" + adminURL, e);
        }
    }

    public static String getDelegateAuthToken(String adminURL, Account account, String adminAuthToken) throws ServiceException {
        SoapHttpTransport transport = new SoapHttpTransport(adminURL);
        transport.setRetryCount(1);
        transport.setTimeout(0);
        transport.setAuthToken(adminAuthToken);
        Element.XMLElement daReq = new Element.XMLElement(AdminConstants.DELEGATE_AUTH_REQUEST);
        Element acctElem = ((Element)daReq).addElement("account");
        acctElem.addAttribute("by", "id");
        acctElem.setText(account.getId());
        try {
            if (mVerbose) {
                mLog.info("Delegate auth request to: " + adminURL);
            }
            if (mLog.isDebugEnabled()) {
                mLog.debug(((Element)daReq).prettyPrint());
            }
            Element daResp = transport.invokeWithoutSession(daReq);
            if (mLog.isDebugEnabled()) {
                mLog.debug(daResp.prettyPrint());
            }
            String authToken = daResp.getAttribute("authToken");
            return authToken;
        }
        catch (Exception e) {
            throw ServiceException.FAILURE("Delegate auth failed url=" + adminURL, e);
        }
    }

    private static Account getAccount(CommandLine cl) throws ServiceException {
        Account account;
        Config conf;
        Provisioning prov = Provisioning.getInstance();
        try {
            conf = prov.getConfig();
        }
        catch (ServiceException e) {
            throw ServiceException.FAILURE("Unable to connect to LDAP directory", e);
        }
        String name = null;
        if (cl.hasOption('s')) {
            if (cl.hasOption('n') || cl.hasOption('m')) {
                mLog.error("only one of s, n or m options can be specified");
                return null;
            }
            name = conf.getAttr("zimbraSpamIsSpamAccount");
            if (name == null || name.length() == 0) {
                mLog.error("no account configured for spam");
                return null;
            }
        } else if (cl.hasOption('n')) {
            if (cl.hasOption('m')) {
                mLog.error("only one of s, n, or m options can be specified");
                return null;
            }
            name = conf.getAttr("zimbraSpamIsNotSpamAccount");
            if (name == null || name.length() == 0) {
                mLog.error("no account configured for ham");
                return null;
            }
        } else if (cl.hasOption('m')) {
            name = cl.getOptionValue('m');
            if (name.length() == 0) {
                mLog.error("illegal argument to m option");
                return null;
            }
        } else {
            mLog.error("one of s, n or m options must be specified");
            return null;
        }
        if ((account = prov.get(Provisioning.AccountBy.name, name)) == null) {
            mLog.error("can not find account " + name);
            return null;
        }
        return account;
    }

    static {
        mOptions.addOption("s", "spam", false, "extract messages from configured spam mailbox");
        mOptions.addOption("n", "notspam", false, "extract messages from configured notspam mailbox");
        mOptions.addOption("m", "mailbox", true, "extract messages from specified mailbox");
        mOptions.addOption("d", "delete", false, "delete extracted messages (default is to keep)");
        mOptions.addOption("o", "outdir", true, "directory to store extracted messages");
        mOptions.addOption("a", "admin", true, "admin user name for auth (default is zimbra_ldap_userdn)");
        mOptions.addOption("p", "password", true, "admin password for auth (default is zimbra_ldap_password)");
        mOptions.addOption("u", "url", true, "admin SOAP service url (default is target mailbox's server's admin service port)");
        mOptions.addOption("q", "query", true, "search query whose results should be extracted (default is in:inbox)");
        mOptions.addOption("r", "raw", false, "extract raw message (default: gets message/rfc822 attachments)");
        mOptions.addOption("h", "help", false, "show this usage text");
        mOptions.addOption("D", "debug", false, "enable debug level logging");
        mOptions.addOption("v", "verbose", false, "be verbose while running");
        mVerbose = false;
        Properties props = new Properties();
        props.setProperty("mail.mime.address.strict", "false");
        mJMSession = Session.getInstance((Properties)props);
        mOutputPrefix = Long.toHexString(System.currentTimeMillis());
    }
}

