/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.client.LmcSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class SoapCLI {
    public static final String O_AUTHTOKEN = "y";
    public static final String O_AUTHTOKENFILE = "Y";
    public static final String O_H = "h";
    public static final String O_HIDDEN = "hidden";
    public static final String O_S = "s";
    public static final Option OPT_AUTHTOKEN = new Option("y", "authtoken", true, "use auth token string(has to be in JSON format) from command line");
    public static final Option OPT_AUTHTOKENFILE = new Option("Y", "authtokenfile", true, "use auth token string(has to be in JSON format) from command line");
    private String mUser = LC.zimbra_ldap_user.value();
    private String mPassword = LC.zimbra_ldap_password.value();
    private String mHost = "localhost";
    private int mPort;
    private boolean mAuth;
    private Options mOptions;
    private Options mHiddenOptions;
    private SoapTransport mTrans = null;
    private String mServerUrl;
    private static final String[] DATETIME_FORMATS = new String[]{"yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss SSS", "yyyy/MM/dd HH:mm:ss.SSS", "yyyy/MM/dd-HH:mm:ss-SSS", "yyyy/MM/dd-HH:mm:ss", "yyyyMMdd.HHmmss.SSS", "yyyyMMdd.HHmmss", "yyyyMMddHHmmssSSS", "yyyyMMddHHmmss"};
    public static final String CANONICAL_DATETIME_FORMAT = DATETIME_FORMATS[0];

    protected SoapCLI() throws ServiceException {
        Config conf = null;
        try {
            conf = Provisioning.getInstance().getConfig();
        }
        catch (ServiceException e) {
            throw ServiceException.FAILURE("Unable to connect to LDAP directory", e);
        }
        this.mPort = conf.getIntAttr("zimbraAdminPort", 0);
        if (this.mPort == 0) {
            throw ServiceException.FAILURE("Unable to get admin port number from provisioning", null);
        }
        this.mOptions = new Options();
        this.mHiddenOptions = new Options();
    }

    protected CommandLine getCommandLine(String[] args) throws ParseException {
        GnuParser clParser = new GnuParser();
        CommandLine cl = null;
        Options opts = this.getAllOptions();
        try {
            cl = clParser.parse(opts, args);
        }
        catch (ParseException e) {
            if (this.helpOptionSpecified(args)) {
                this.usage();
                return null;
            }
            throw e;
        }
        if (cl.hasOption(O_H)) {
            boolean showHiddenOptions = cl.hasOption(O_HIDDEN);
            this.usage(null, showHiddenOptions);
            return null;
        }
        if (cl.hasOption(O_S)) {
            this.mHost = cl.getOptionValue(O_S);
        }
        return cl;
    }

    private Options getAllOptions() {
        Options[] optionses;
        Options newOptions = new Options();
        HashSet<OptionGroup> groups = new HashSet<OptionGroup>();
        for (Options options : optionses = new Options[]{this.mOptions, this.mHiddenOptions}) {
            for (Option opt : options.getOptions()) {
                OptionGroup group = options.getOptionGroup(opt);
                if (group != null) {
                    groups.add(group);
                    continue;
                }
                newOptions.addOption(opt);
            }
        }
        for (OptionGroup group : groups) {
            newOptions.addOptionGroup(group);
        }
        return newOptions;
    }

    private boolean helpOptionSpecified(String[] args) {
        return args != null && args.length == 1 && ("-h".equals(args[0]) || "--help".equals(args[0]));
    }

    protected LmcSession auth() throws SoapFaultException, IOException, ServiceException {
        URL url = new URL("https", this.mHost, this.mPort, "/service/admin/soap/");
        this.mServerUrl = url.toExternalForm();
        SoapTransport trans = this.getTransport();
        this.mAuth = false;
        Element.XMLElement authReq = new Element.XMLElement(AdminConstants.AUTH_REQUEST);
        ((Element)authReq).addAttribute("name", this.mUser, Element.Disposition.CONTENT);
        ((Element)authReq).addAttribute("password", this.mPassword, Element.Disposition.CONTENT);
        try {
            Element authResp = trans.invokeWithoutSession(authReq);
            String authToken = authResp.getAttribute("authToken");
            ZAuthToken zat = new ZAuthToken(null, authToken, null);
            trans.setAuthToken(authToken);
            this.mAuth = true;
            return new LmcSession(zat, null);
        }
        catch (UnknownHostException e) {
            throw new IOException("Unknown host: " + this.mHost);
        }
    }

    protected LmcSession auth(ZAuthToken zAuthToken) throws SoapFaultException, IOException, ServiceException {
        if (zAuthToken == null) {
            return this.auth();
        }
        URL url = new URL("https", this.mHost, this.mPort, "/service/admin/soap/");
        this.mServerUrl = url.toExternalForm();
        SoapTransport trans = this.getTransport();
        this.mAuth = false;
        Element.XMLElement authReq = new Element.XMLElement(AdminConstants.AUTH_REQUEST);
        zAuthToken.encodeAuthReq(authReq, true);
        try {
            Element authResp = trans.invokeWithoutSession(authReq);
            ZAuthToken zat = new ZAuthToken(authResp.getElement("authToken"), true);
            trans.setAuthToken(zat);
            this.mAuth = true;
            return new LmcSession(zat, null);
        }
        catch (UnknownHostException e) {
            throw new IOException("Unknown host: " + this.mHost);
        }
    }

    protected void setupCommandLineOptions() {
        Option s = new Option(O_S, "server", true, "Mail server hostname. Default is localhost.");
        this.mOptions.addOption(s);
        this.mOptions.addOption(O_H, "help", false, "Displays this help message.");
        this.mHiddenOptions.addOption(null, O_HIDDEN, false, "Include hidden options in help output");
    }

    protected void usage() {
        this.usage(null);
    }

    protected void usage(ParseException e) {
        this.usage(e, false);
    }

    protected void usage(ParseException e, boolean showHiddenOptions) {
        if (e != null) {
            System.err.println("Error parsing command line arguments: " + e.getMessage());
        }
        Options opts = showHiddenOptions ? this.getAllOptions() : this.mOptions;
        PrintWriter pw = new PrintWriter(System.err, true);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(pw, formatter.getWidth(), this.getCommandUsage(), null, opts, formatter.getLeftPadding(), formatter.getDescPadding(), null);
        pw.flush();
        String trailer = this.getTrailer();
        if (trailer != null && trailer.length() > 0) {
            System.err.println();
            System.err.println(trailer);
        }
    }

    protected abstract String getCommandUsage();

    protected String getTrailer() {
        return "";
    }

    protected boolean isAuthenticated() {
        return this.mAuth;
    }

    protected String getUser() {
        return this.mUser;
    }

    protected String getServer() {
        return this.mHost;
    }

    protected int getPort() {
        return this.mPort;
    }

    protected SoapTransport getTransport() {
        if (this.mTrans == null) {
            this.initTransport();
        }
        return this.mTrans;
    }

    private void initTransport() {
        SoapHttpTransport trans = new SoapHttpTransport(this.mServerUrl);
        trans.setRetryCount(1);
        this.mTrans = trans;
    }

    public void setTransportTimeout(int newTimeout) {
        this.getTransport().setTimeout(newTimeout);
    }

    protected String getServerUrl() {
        return this.mServerUrl;
    }

    protected Options getOptions() {
        return this.mOptions;
    }

    protected Options getHiddenOptions() {
        return this.mHiddenOptions;
    }

    public static Date parseDatetime(String str) {
        for (String formatStr : DATETIME_FORMATS) {
            SimpleDateFormat fmt = new SimpleDateFormat(formatStr);
            fmt.setLenient(false);
            ParsePosition pp = new ParsePosition(0);
            Date d = fmt.parse(str, pp);
            if (d == null || pp.getIndex() != str.length()) continue;
            return d;
        }
        return null;
    }

    public static String getAllowedDatetimeFormatsHelp() {
        StringBuilder sb = new StringBuilder();
        sb.append("Specify date/time in one of these formats:\n\n");
        Date d = new Date();
        for (String formatStr : DATETIME_FORMATS) {
            SimpleDateFormat fmt = new SimpleDateFormat(formatStr);
            String s = fmt.format(d);
            sb.append("    ").append(s).append("\n");
        }
        sb.append("\n");
        sb.append("Specify year, month, date, hour, minute, second, and optionally millisecond.\n");
        sb.append("Month/date/hour/minute/second are 0-padded to 2 digits, millisecond to 3 digits.\n");
        sb.append("Hour must be specified in 24-hour format, and time is in local time zone.\n");
        return sb.toString();
    }

    public static ZAuthToken getZAuthToken(CommandLine cl) throws ServiceException, ParseException, IOException {
        if (cl.hasOption(O_AUTHTOKEN) && cl.hasOption(O_AUTHTOKENFILE)) {
            String msg = String.format("cannot specify both %s and %s options", O_AUTHTOKEN, O_AUTHTOKENFILE);
            throw new ParseException(msg);
        }
        if (cl.hasOption(O_AUTHTOKEN)) {
            return ZAuthToken.fromJSONString(cl.getOptionValue(O_AUTHTOKEN));
        }
        if (cl.hasOption(O_AUTHTOKENFILE)) {
            String authToken = StringUtil.readSingleLineFromFile(cl.getOptionValue(O_AUTHTOKENFILE));
            return ZAuthToken.fromJSONString(authToken);
        }
        return null;
    }
}

