/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.DummySSLSocketFactory;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Security;
import java.util.Arrays;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class SmtpInject {
    private static Log mLog = LogFactory.getLog(SmtpInject.class);
    private static Options mOptions = new Options();

    private static void usage(String errmsg) {
        if (errmsg != null) {
            mLog.error(errmsg);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("SmtpInject [options]", mOptions);
        System.exit(errmsg == null ? 0 : 1);
    }

    private static CommandLine parseArgs(String[] args) {
        StringBuffer gotCL = new StringBuffer("cmdline: ");
        for (int i = 0; i < args.length; ++i) {
            gotCL.append("'").append(args[i]).append("' ");
        }
        GnuParser parser = new GnuParser();
        CommandLine cl = null;
        try {
            cl = parser.parse(mOptions, args);
        }
        catch (ParseException pe) {
            SmtpInject.usage(pe.getMessage());
        }
        return cl;
    }

    public static void main(String[] args) {
        CliUtil.toolSetup();
        CommandLine cl = SmtpInject.parseArgs(args);
        if (cl.hasOption("h")) {
            SmtpInject.usage(null);
        }
        String file = null;
        if (!cl.hasOption("f")) {
            SmtpInject.usage("no file specified");
        } else {
            file = cl.getOptionValue("f");
        }
        try {
            ByteUtil.getContent(new File(file));
        }
        catch (IOException ioe) {
            SmtpInject.usage(ioe.getMessage());
        }
        String host = null;
        if (!cl.hasOption("a")) {
            SmtpInject.usage("no smtp server specified");
        } else {
            host = cl.getOptionValue("a");
        }
        String sender = null;
        if (!cl.hasOption("s")) {
            SmtpInject.usage("no sender specified");
        } else {
            sender = cl.getOptionValue("s");
        }
        String recipient = null;
        if (!cl.hasOption("r")) {
            SmtpInject.usage("no recipient specified");
        } else {
            recipient = cl.getOptionValue("r");
        }
        boolean trace = false;
        if (cl.hasOption("T")) {
            trace = true;
        }
        boolean tls = false;
        if (cl.hasOption("t")) {
            tls = true;
        }
        boolean auth = false;
        String user = null;
        String password = null;
        if (cl.hasOption("A")) {
            auth = true;
            if (!cl.hasOption("u")) {
                SmtpInject.usage("auth enabled, no user specified");
            } else {
                user = cl.getOptionValue("u");
            }
            if (!cl.hasOption("p")) {
                SmtpInject.usage("auth enabled, no password specified");
            } else {
                password = cl.getOptionValue("p");
            }
        }
        if (cl.hasOption("v")) {
            mLog.info("SMTP server: " + host);
            mLog.info("Sender: " + sender);
            mLog.info("Recipient: " + recipient);
            mLog.info("File: " + file);
            mLog.info("TLS: " + tls);
            mLog.info("Auth: " + auth);
            if (auth) {
                mLog.info("User: " + user);
                char[] dummyPassword = new char[password.length()];
                Arrays.fill(dummyPassword, '*');
                mLog.info("Password: " + new String(dummyPassword));
            }
        }
        Properties props = System.getProperties();
        props.put("mail.smtp.host", host);
        if (auth) {
            props.put("mail.smtp.auth", "true");
        } else {
            props.put("mail.smtp.auth", "false");
        }
        if (tls) {
            props.put("mail.smtp.starttls.enable", "true");
        } else {
            props.put("mail.smtp.starttls.enable", "false");
        }
        Security.setProperty("ssl.SocketFactory.provider", DummySSLSocketFactory.class.getName());
        Session session = Session.getInstance((Properties)props, null);
        session.setDebug(trace);
        try {
            MimeMessage msg = new MimeMessage(session, (InputStream)new FileInputStream(file));
            InternetAddress[] address = new InternetAddress[]{new InternetAddress(recipient)};
            msg.setFrom((Address)new InternetAddress(sender));
            Transport transport = session.getTransport("smtp");
            transport.connect(null, user, password);
            transport.sendMessage((Message)msg, (Address[])address);
        }
        catch (MessagingException mex) {
            mex.printStackTrace();
            Exception ex = null;
            ex = mex.getNextException();
            if (ex != null) {
                ex.printStackTrace();
            }
            System.exit(1);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(1);
        }
    }

    static {
        mOptions.addOption("h", "help", false, "show help text");
        mOptions.addOption("f", "file", true, "rfc822/MIME formatted text file");
        mOptions.addOption("a", "address", true, "smtp server (default localhost)");
        mOptions.addOption("s", "sender", true, "envelope sender (mail from)");
        Option ropt = new Option("r", "recipient", true, "envelope recipients (rcpt to)");
        ropt.setArgs(-2);
        mOptions.addOption(ropt);
        mOptions.addOption("T", "trace", false, "trace server/client traffic");
        mOptions.addOption("t", "tls", false, "use TLS");
        mOptions.addOption("A", "auth", false, "use SMTP auth");
        mOptions.addOption("u", "username", true, "username for SMTP auth");
        mOptions.addOption("p", "password", true, "password for SMTP auth");
        mOptions.addOption("v", "verbose", false, "show provided options");
    }
}

