/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ClassLoaderUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinUtil {
    private static String[] sSkins = null;

    private static synchronized String[] getAllInstalledSkinsSorted() throws ServiceException {
        if (sSkins == null) {
            sSkins = SkinUtil.loadSkins();
        }
        return sSkins;
    }

    public static synchronized void flushSkinCache() throws ServiceException {
        sSkins = null;
    }

    private static String[] loadSkins() throws ServiceException {
        ZimbraLog.webclient.debug("Loading skins...");
        String skinsDir = LC.skins_directory.value();
        ClassLoader classLoader = ClassLoaderUtil.getClassLoaderByDirectory(skinsDir);
        if (classLoader == null) {
            throw ServiceException.FAILURE("unable to get class loader for directory " + skinsDir + " configured in localconfig key " + LC.skins_directory.key(), null);
        }
        ArrayList<String> skins = new ArrayList<String>();
        File dir = new File(skinsDir);
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                String fname = f.getName();
                if (fname.startsWith("_") || !new File(f, "manifest.xml").exists()) continue;
                skins.add(fname);
            }
        }
        Object[] sortedSkins = skins.toArray(new String[skins.size()]);
        Arrays.sort(sortedSkins);
        ZimbraLog.webclient.debug("Skin loading complete.");
        return sortedSkins;
    }

    public static String[] getSkins(Account acct) throws ServiceException {
        String[] installedSkins = SkinUtil.getAllInstalledSkinsSorted();
        Set<String> allowedSkins = SkinUtil.getAvailableSkins(acct);
        String[] availSkins = null;
        if (allowedSkins.size() == 0) {
            availSkins = installedSkins;
        } else {
            ArrayList<String> skins = new ArrayList<String>();
            for (String skin : installedSkins) {
                if (!allowedSkins.contains(skin)) continue;
                skins.add(skin);
            }
            availSkins = skins.toArray(new String[skins.size()]);
        }
        return availSkins;
    }

    private static Set<String> getAvailableSkins(Account acct) throws ServiceException {
        return acct.getMultiAttrSet("zimbraAvailableSkin");
    }

    public static String chooseSkin(Account acct, String requestedSkin) throws ServiceException {
        Set<String> allowedSkins;
        String[] installedSkins = SkinUtil.getAllInstalledSkinsSorted();
        if (SkinUtil.checkSkin(requestedSkin, installedSkins, allowedSkins = SkinUtil.getAvailableSkins(acct))) {
            ZimbraLog.webclient.debug("Loading requested skin " + requestedSkin);
            return requestedSkin;
        }
        String prefSkin = acct.getAttr("zimbraPrefSkin");
        if (SkinUtil.checkSkin(prefSkin, installedSkins, allowedSkins)) {
            ZimbraLog.webclient.debug("Loading account skin " + prefSkin);
            return prefSkin;
        }
        String usuallyAvailableSkin = "beach";
        if (prefSkin != usuallyAvailableSkin && SkinUtil.checkSkin(usuallyAvailableSkin, installedSkins, allowedSkins)) {
            ZimbraLog.webclient.debug("Loading default skin " + usuallyAvailableSkin);
            return usuallyAvailableSkin;
        }
        if (installedSkins.length > 0) {
            ZimbraLog.webclient.debug("Returning first known skin " + installedSkins[0]);
            return installedSkins[0];
        }
        return null;
    }

    private static boolean checkSkin(String requestedSkin, String[] installedSkins, Set<String> allowedSkins) {
        if (requestedSkin != null && requestedSkin.length() > 0) {
            for (String skin : installedSkins) {
                if (!requestedSkin.equals(skin) || allowedSkins.size() != 0 && !allowedSkins.contains(skin)) continue;
                return true;
            }
        }
        return false;
    }
}

