/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.common.util.memcached.ZimbraMemcachedClient;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyPurgeUtil {
    public static void main(String[] args) throws ServiceException {
        CommandLine commandLine;
        boolean purge = false;
        String memcachedPort = "11211";
        String logLevel = "ERROR";
        try {
            commandLine = ProxyPurgeUtil.parseCommandLine(args);
        }
        catch (ParseException pe) {
            commandLine = null;
        }
        if (commandLine == null || commandLine.hasOption("h") || commandLine.hasOption("u")) {
            ProxyPurgeUtil.usage();
            System.exit(1);
        }
        if (commandLine.hasOption("v")) {
            logLevel = "DEBUG";
        }
        ZimbraLog.toolSetupLog4j(logLevel, null, false);
        Provisioning prov = Provisioning.getInstance();
        List<Server> memcachedServers = prov.getAllServers("memcached");
        ArrayList<String> servers = new ArrayList<String>();
        for (Server s : memcachedServers) {
            String serverName = s.getAttr("zimbraServiceHostname", "localhost");
            String servicePort = s.getAttr("zimbraMemcachedBindPort", "11211");
            servers.add(serverName + ":" + servicePort);
        }
        ArrayList<String> accounts = ProxyPurgeUtil.getAccounts(commandLine);
        servers.addAll(ProxyPurgeUtil.getCacheServers(commandLine));
        if (servers.size() == 0) {
            System.err.println("No memcached servers found, and none specified (--help for help)");
            System.exit(1);
        }
        if (accounts.size() == 0) {
            System.err.println("No accounts specified (--help for help)");
            System.exit(1);
        }
        purge = !commandLine.hasOption("i");
        int numServers = servers.size();
        ArrayList<ZimbraMemcachedClient> zmcs = new ArrayList<ZimbraMemcachedClient>();
        for (int i = 0; i < numServers; ++i) {
            ZimbraMemcachedClient zmc = new ZimbraMemcachedClient();
            zmc.connect(new String[]{(String)servers.get(i)}, false, null, 0, 5000L);
            zmcs.add(zmc);
        }
        String outputformat = commandLine.hasOption("o") ? commandLine.getOptionValue("o") : "[%1$s] %2$s -- %3$s";
        for (String a : accounts) {
            for (int i = 0; i < numServers; ++i) {
                ZimbraMemcachedClient zmc = (ZimbraMemcachedClient)zmcs.get(i);
                String imapKey = "route:proto=imap;user=" + a;
                String pop3Key = "route:proto=pop3;user=" + a;
                if (purge) {
                    zmc.remove(imapKey, false);
                    zmc.remove(pop3Key, false);
                    continue;
                }
                String server = (String)servers.get(i);
                Formatter imapf = new Formatter();
                imapf.format(outputformat, server, imapKey, zmc.get(imapKey));
                System.out.println(imapf.toString());
                Formatter pop3f = new Formatter();
                pop3f.format(outputformat, server, pop3Key, zmc.get(pop3Key));
                System.out.println(pop3f.toString());
            }
        }
        for (ZimbraMemcachedClient zmc : zmcs) {
            zmc.disconnect(-1L);
        }
    }

    static ArrayList<String> getAccounts(CommandLine commandLine) {
        ArrayList<String> accounts = new ArrayList<String>();
        String[] values = commandLine.getOptionValues("a");
        String filename = commandLine.getOptionValue("L");
        if (values != null) {
            for (String u : commandLine.getOptionValues("a")) {
                accounts.add(u);
            }
        }
        if (filename != null) {
            BufferedReader br;
            if (filename == "-") {
                br = new BufferedReader(new InputStreamReader(System.in));
            } else {
                try {
                    br = new BufferedReader(new FileReader(filename));
                }
                catch (FileNotFoundException e) {
                    br = null;
                    System.err.println("File not found: " + filename);
                }
            }
            if (br != null) {
                String s;
                do {
                    try {
                        s = br.readLine();
                    }
                    catch (IOException e) {
                        s = null;
                    }
                    if (s == null) continue;
                    accounts.add(s);
                } while (s != null);
                try {
                    br.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return accounts;
    }

    static ArrayList<String> getCacheServers(CommandLine commandLine) {
        ArrayList<String> servers = new ArrayList<String>();
        String[] values = commandLine.getArgs();
        if (values != null) {
            for (String s : commandLine.getArgs()) {
                servers.add(s);
            }
        }
        return servers;
    }

    static CommandLine parseCommandLine(String[] args) throws ParseException {
        GnuParser parser = new GnuParser();
        Options options = new Options();
        options.addOption("h", "help", false, "print usage");
        options.addOption("u", "usage", false, "print usage");
        options.addOption("v", "verbose", false, "be verbose");
        options.addOption("i", "info", false, "display route information");
        options.addOption("a", "account", true, "account name");
        options.addOption("L", "list", true, "file containing list of accounts, one per line");
        options.addOption("o", "output", true, "format for displaying routing information");
        return parser.parse(options, args);
    }

    static void usage() {
        System.err.println(" ");
        System.err.println(" Purges POP/IMAP routing information from one or more memcached servers");
        System.err.println(" Available Memcached servers are discovered by the 'zmprov gamcs' function, others can be specified");
        System.err.println(" If necessary, please specify additional memcached servers in the form of server:port at the end of the command line");
        System.err.println(" ");
        System.err.println(" Usage: zmproxypurge [-v] [-i] -a account [-L accountlist] [cache1 [cache2 ... ]]");
        System.err.println("  -h, --help     Display help");
        System.err.println("  -v, --verbose  Be verbose");
        System.err.println("  -i, --info     Just display account routing information, don't purge (dry run)");
        System.err.println("  -a, --account  Account name");
        System.err.println("  -L, --list     File containing list of accounts, one per line");
        System.err.println("                 Use `-' to indicate standard input");
        System.err.println("  -o, --output   Format to be used to print routing information with -i");
        System.err.println("                 Three fields are displayed by default:");
        System.err.println("                 . the cache server");
        System.err.println("                 . the account name");
        System.err.println("                 . the route information");
        System.err.println("                 Default format is `[%1$s] %2$s -- %3$s'");
        System.err.println("  cacheN         (Optional) Additional memcache server, of the form server:port");
        System.err.println(" ");
    }
}

