/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.util.BuildInfo;
import com.zimbra.cs.util.ProxyConfException;
import com.zimbra.cs.util.ProxyConfGen;
import com.zimbra.cs.util.ProxyConfOverride;
import com.zimbra.cs.util.ProxyConfValueType;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;

class ProxyConfVar {
    public String mKeyword;
    public String mAttribute;
    public ProxyConfValueType mValueType;
    public Object mDefault;
    public Object mValue;
    public ProxyConfOverride mOverride;
    public String mDescription;
    private static Log mLog = LogFactory.getLog(ProxyConfGen.class);
    private static Provisioning mProv = Provisioning.getInstance();
    public static Entry configSource = null;
    public static Entry serverSource = null;

    public ProxyConfVar(String keyword, String attribute, Object defaultValue, ProxyConfValueType valueType, ProxyConfOverride overrideType, String description) {
        this.mKeyword = keyword;
        this.mAttribute = attribute;
        this.mValueType = valueType;
        this.mDefault = defaultValue;
        this.mOverride = overrideType;
        this.mValue = this.mDefault;
        this.mDescription = description;
    }

    public String confValue() throws ProxyConfException {
        return this.format(this.mValue);
    }

    public Object rawValue() {
        return this.mValue;
    }

    public void write(PrintStream ps) throws ProxyConfException {
        ps.println("  NGINX Keyword:         " + this.mKeyword);
        ps.println("  Description:           " + this.mDescription);
        ps.println("  Value Type:            " + this.mValueType.toString());
        ps.println("  Controlling Attribute: " + (this.mAttribute == null ? "(none)" : this.mAttribute));
        ps.println("  Default Value:         " + this.mDefault.toString());
        ps.println("  Current Value:         " + this.mValue.toString());
        ps.println("  Config Text:           " + this.format(this.mValue));
        ps.println("");
    }

    public void update() throws ServiceException {
        if (this.mOverride == ProxyConfOverride.NONE) {
            return;
        }
        if (this.mValueType == ProxyConfValueType.INTEGER) {
            this.updateInteger();
        } else if (this.mValueType == ProxyConfValueType.LONG) {
            this.updateLong();
        } else if (this.mValueType == ProxyConfValueType.STRING) {
            this.updateString();
        } else if (this.mValueType == ProxyConfValueType.BOOLEAN) {
            this.updateBoolean();
        } else if (this.mValueType == ProxyConfValueType.ENABLER) {
            this.updateEnabler();
        } else if (this.mValueType == ProxyConfValueType.TIME) {
            this.updateTime();
        } else if (this.mValueType == ProxyConfValueType.CUSTOM) {
            if ("web.http.enabled".equalsIgnoreCase(this.mKeyword)) {
                String mailmode = serverSource.getAttr("zimbraReverseProxyMailMode", "both");
                this.mValue = "https".equalsIgnoreCase(mailmode) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            } else if ("web.https.enabled".equalsIgnoreCase(this.mKeyword)) {
                String mailmode = serverSource.getAttr("zimbraReverseProxyMailMode", "both");
                this.mValue = "http".equalsIgnoreCase(mailmode) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            } else if ("mail.pop3.greeting".equalsIgnoreCase(this.mKeyword)) {
                this.mValue = serverSource.getBooleanAttr("zimbraReverseProxyPop3ExposeVersionOnBanner", false) ? "+OK Zimbra " + BuildInfo.VERSION + " POP3 ready" : "";
            } else if ("mail.imap.greeting".equalsIgnoreCase(this.mKeyword)) {
                this.mValue = serverSource.getBooleanAttr("zimbraReverseProxyImapExposeVersionOnBanner", false) ? "* OK Zimbra " + BuildInfo.VERSION + " IMAP4 ready" : "";
            } else if ("mail.sasl_host_from_ip".equalsIgnoreCase(this.mKeyword)) {
                this.mValue = LC.krb5_service_principal_from_interface_address.booleanValue() ? Boolean.valueOf(true) : Boolean.valueOf(false);
            } else if ("memcache.:servers".equalsIgnoreCase(this.mKeyword)) {
                ArrayList<String> servers = new ArrayList<String>();
                List<Server> mcs = mProv.getAllServers("memcached");
                for (Server mc : mcs) {
                    String serverName = mc.getAttr("zimbraServiceHostname", "");
                    int serverPort = mc.getIntAttr("zimbraMemcachedBindPort", 11211);
                    Formatter f = new Formatter();
                    f.format("%s:%d", serverName, serverPort);
                    servers.add(f.toString());
                }
                this.mValue = servers;
            } else if ("mail.:auth_http".equalsIgnoreCase(this.mKeyword) || "web.:routehandlers".equalsIgnoreCase(this.mKeyword)) {
                ArrayList<String> servers = new ArrayList<String>();
                List<Server> allServers = mProv.getAllServers();
                int REVERSE_PROXY_PORT = 7072;
                for (Server s : allServers) {
                    String sn = s.getAttr("zimbraServiceHostname", "");
                    boolean isTarget = s.getBooleanAttr("zimbraReverseProxyLookupTarget", false);
                    if (!isTarget) continue;
                    Formatter f = new Formatter();
                    f.format("%s:%d", sn, REVERSE_PROXY_PORT);
                    servers.add(f.toString());
                    mLog.debug("Route Lookup: Added server " + sn);
                }
                this.mValue = servers;
            } else if ("web.upstream.:servers".equalsIgnoreCase(this.mKeyword)) {
                ArrayList<String> servers = new ArrayList<String>();
                List<Server> us = mProv.getAllServers();
                for (Server u : us) {
                    boolean isTarget = u.getBooleanAttr("zimbraReverseProxyLookupTarget", false);
                    if (!isTarget) continue;
                    String mode = u.getAttr("zimbraMailMode", "");
                    String serverName = u.getAttr("zimbraServiceHostname", "");
                    if (mode.equalsIgnoreCase(Provisioning.MailMode.http.toString()) || mode.equalsIgnoreCase(Provisioning.MailMode.mixed.toString()) || mode.equalsIgnoreCase(Provisioning.MailMode.both.toString())) {
                        int serverPort = u.getIntAttr("zimbraMailPort", 0);
                        Formatter f = new Formatter();
                        f.format("%s:%d", serverName, serverPort);
                        servers.add(f.toString());
                        mLog.info("Added server to HTTP upstream: " + serverName);
                        continue;
                    }
                    mLog.warn("Upstream: Ignoring server:" + serverName + " because its mail mode is:" + mode);
                }
                this.mValue = servers;
            } else if ("mail.imapcapa".equalsIgnoreCase(this.mKeyword)) {
                String[] capabilityNames;
                ArrayList<String> capabilities = new ArrayList<String>();
                for (String c : capabilityNames = serverSource.getMultiAttr("zimbraReverseProxyImapEnabledCapability")) {
                    capabilities.add(c);
                }
                this.mValue = capabilities.size() > 0 ? capabilities : this.mDefault;
            } else if ("mail.pop3capa".equalsIgnoreCase(this.mKeyword)) {
                String[] capabilityNames;
                ArrayList<String> capabilities = new ArrayList<String>();
                for (String c : capabilityNames = serverSource.getMultiAttr("zimbraReverseProxyPop3EnabledCapability")) {
                    capabilities.add(c);
                }
                this.mValue = capabilities.size() > 0 ? capabilities : this.mDefault;
            }
        }
    }

    public String format(Object o) throws ProxyConfException {
        if (this.mValueType == ProxyConfValueType.INTEGER) {
            return this.formatInteger(o);
        }
        if (this.mValueType == ProxyConfValueType.LONG) {
            return this.formatLong(o);
        }
        if (this.mValueType == ProxyConfValueType.STRING) {
            return this.formatString(o);
        }
        if (this.mValueType == ProxyConfValueType.BOOLEAN) {
            return this.formatBoolean(o);
        }
        if (this.mValueType == ProxyConfValueType.ENABLER) {
            return this.formatEnabler(o);
        }
        if (this.mValueType == ProxyConfValueType.TIME) {
            return this.formatTime(o);
        }
        if ("memcache.:servers".equalsIgnoreCase(this.mKeyword)) {
            ArrayList servers = (ArrayList)o;
            String conf = "";
            for (String s : servers) {
                conf = conf + "  servers   " + s + ";" + "\n";
            }
            return conf;
        }
        if ("mail.:auth_http".equalsIgnoreCase(this.mKeyword)) {
            String REVERSE_PROXY_PATH = "/service/extension/nginx-lookup";
            ArrayList servers = (ArrayList)o;
            String conf = "";
            for (String s : servers) {
                conf = conf + "    auth_http   " + s + REVERSE_PROXY_PATH + ";" + "\n";
            }
            return conf;
        }
        if ("web.:routehandlers".equalsIgnoreCase(this.mKeyword)) {
            String REVERSE_PROXY_PATH = "/service/extension/nginx-lookup";
            ArrayList servers = (ArrayList)o;
            String conf = "";
            for (String s : servers) {
                conf = conf + "    zmroutehandlers   " + s + REVERSE_PROXY_PATH + ";" + "\n";
            }
            return conf;
        }
        if ("web.upstream.:servers".equalsIgnoreCase(this.mKeyword)) {
            ArrayList servers = (ArrayList)o;
            String conf = "";
            for (String s : servers) {
                conf = conf + "    server   " + s + ";" + "\n";
            }
            return conf;
        }
        if ("mail.pop3.greeting".equalsIgnoreCase(this.mKeyword)) {
            return this.formatString(o);
        }
        if ("mail.imap.greeting".equalsIgnoreCase(this.mKeyword)) {
            return this.formatString(o);
        }
        if ("mail.sasl_host_from_ip".equalsIgnoreCase(this.mKeyword)) {
            return this.formatBoolean(o);
        }
        if ("mail.imapcapa".equalsIgnoreCase(this.mKeyword)) {
            ArrayList capabilities = (ArrayList)o;
            String capa = "";
            for (String c : capabilities) {
                capa = capa + " " + "\"" + c + "\"";
            }
            return capa;
        }
        if ("mail.pop3capa".equalsIgnoreCase(this.mKeyword)) {
            ArrayList capabilities = (ArrayList)o;
            String capa = "";
            for (String c : capabilities) {
                capa = capa + " " + "\"" + c + "\"";
            }
            return capa;
        }
        throw new ProxyConfException("Unhandled keyword: " + this.mKeyword);
    }

    public void updateString() {
        if (this.mOverride == ProxyConfOverride.CONFIG) {
            this.mValue = configSource.getAttr(this.mAttribute, (String)this.mDefault);
        } else if (this.mOverride == ProxyConfOverride.LOCALCONFIG) {
            this.mValue = this.lcValue(this.mAttribute, (String)this.mDefault);
        } else if (this.mOverride == ProxyConfOverride.SERVER) {
            this.mValue = serverSource.getAttr(this.mAttribute, (String)this.mDefault);
        }
    }

    public String formatString(Object o) {
        Formatter f = new Formatter();
        f.format("%s", o);
        return f.toString();
    }

    public void updateBoolean() {
        if (this.mOverride == ProxyConfOverride.CONFIG) {
            this.mValue = configSource.getBooleanAttr(this.mAttribute, (Boolean)this.mDefault);
        } else if (this.mOverride == ProxyConfOverride.LOCALCONFIG) {
            this.mValue = Boolean.valueOf(this.lcValue(this.mAttribute, this.mDefault.toString()));
        } else if (this.mOverride == ProxyConfOverride.SERVER) {
            this.mValue = serverSource.getBooleanAttr(this.mAttribute, (Boolean)this.mDefault);
        }
    }

    public String formatBoolean(Object o) {
        if (((Boolean)o).booleanValue()) {
            return "on";
        }
        return "off";
    }

    public void updateEnabler() {
        this.updateBoolean();
    }

    public String formatEnabler(Object o) {
        if (((Boolean)o).booleanValue()) {
            return "";
        }
        return "#";
    }

    public void updateTime() {
        if (this.mOverride == ProxyConfOverride.CONFIG) {
            this.mValue = new Long(configSource.getTimeInterval(this.mAttribute, (Long)this.mDefault));
        } else if (this.mOverride == ProxyConfOverride.LOCALCONFIG) {
            this.mValue = new Long(DateUtil.getTimeInterval(this.lcValue(this.mAttribute, this.mDefault.toString()), (Long)this.mDefault));
        } else if (this.mOverride == ProxyConfOverride.SERVER) {
            this.mValue = new Long(serverSource.getTimeInterval(this.mAttribute, (Long)this.mDefault));
        }
    }

    public String formatTime(Object o) {
        Formatter f = new Formatter();
        f.format("%dms", (Long)o);
        return f.toString();
    }

    public void updateInteger() {
        if (this.mOverride == ProxyConfOverride.CONFIG) {
            this.mValue = new Integer(configSource.getIntAttr(this.mAttribute, (Integer)this.mDefault));
        } else if (this.mOverride == ProxyConfOverride.LOCALCONFIG) {
            this.mValue = Integer.valueOf(this.lcValue(this.mAttribute, this.mDefault.toString()));
        } else if (this.mOverride == ProxyConfOverride.SERVER) {
            this.mValue = new Integer(serverSource.getIntAttr(this.mAttribute, (Integer)this.mDefault));
        }
    }

    public String formatInteger(Object o) {
        Formatter f = new Formatter();
        f.format("%d", (Integer)o);
        return f.toString();
    }

    public void updateLong() {
        if (this.mOverride == ProxyConfOverride.CONFIG) {
            this.mValue = new Long(configSource.getLongAttr(this.mAttribute, (Long)this.mDefault));
        } else if (this.mOverride == ProxyConfOverride.LOCALCONFIG) {
            this.mValue = Long.valueOf(this.lcValue(this.mAttribute, this.mDefault.toString()));
        } else if (this.mOverride == ProxyConfOverride.SERVER) {
            this.mValue = new Long(serverSource.getLongAttr(this.mAttribute, (Long)this.mDefault));
        }
    }

    public String formatLong(Object o) {
        Formatter f = new Formatter();
        Long l = (Long)o;
        if (l % 0x100000L == 0L) {
            f.format("%dm", l / 0x100000L);
        } else if (l % 1024L == 0L) {
            f.format("%dk", l / 1024L);
        } else {
            f.format("%d", l);
        }
        return f.toString();
    }

    private String lcValue(String key, String def) {
        String val = LC.get(key);
        return val == null || val.length() == 0 ? def : val;
    }
}

