/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util;

import com.zimbra.common.stats.RealtimeStatsCallback;
import com.zimbra.cs.stats.ZimbraPerf;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemoryStats
implements RealtimeStatsCallback {
    private static final String MEMPOOL_PREFIX = "mpool_";
    private static final String USED_SUFFIX = "_used";
    private static final String FREE_SUFFIX = "_free";
    private static final String GC_PREFIX = "gc_";
    private static final String COUNT_SUFFIX = "_count";
    private static final String TIME_SUFFIX = "_ms";
    private static final String MINOR = "minor";
    private static final String MAJOR = "major";
    private static final String HEAP_USED = "heap_used";
    private static final String HEAP_FREE = "heap_free";
    private static final String GC_MINOR_COUNT = "gc_minor_count";
    private static final String GC_MINOR_TIME = "gc_minor_ms";
    private static final String GC_MAJOR_COUNT = "gc_major_count";
    private static final String GC_MAJOR_TIME = "gc_major_ms";
    private static final String MEMMGR_GC_MAJOR_MSC = "MarkSweepCompact";
    private static final String MEMMGR_GC_MAJOR_CMS = "ConcurrentMarkSweep";
    private static final String MEMMGR_GC_MAJOR_PS_MARKSWEEP = "PS MarkSweep";
    private static final String MEMMGR_GC_MAJOR_TRAIN = "Train";
    private static Set<String> sMajorCollectors;
    private static MemoryStats sInstance;

    public static String dumpGarbageCollectors() {
        StringBuilder sb = new StringBuilder();
        List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gc : gcs) {
            long timePerGc = 0L;
            if (gc.getCollectionCount() > 0L) {
                timePerGc = gc.getCollectionTime() / gc.getCollectionCount();
            }
            sb.append(new Formatter().format("GC: %s(%s)  count=%d  time=%d(%,dms per collection)\n", gc.getName(), gc.isValid() ? "VALID" : "INVALID", gc.getCollectionCount(), gc.getCollectionTime(), timePerGc));
            sb.append(new Formatter().format("\tPools: \"", new Object[0]));
            for (String s : gc.getMemoryPoolNames()) {
                sb.append(s).append(", ");
            }
            sb.append("\"\n");
        }
        return sb.toString();
    }

    public static String dumpMemoryPools() {
        StringBuilder sb = new StringBuilder();
        long totalUsed = 0L;
        long totalReserved = 0L;
        long totalMax = 0L;
        long collectUsed = 0L;
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean pool : pools) {
            MemoryUsage usage = pool.getUsage();
            if (pool.getType() != MemoryType.HEAP) continue;
            sb.append(new Formatter().format("\t\"%s\" memory used: %,d  reserved: %,d  max: %,d", pool.getName(), usage.getUsed(), usage.getCommitted(), usage.getMax()));
            totalUsed += usage.getUsed();
            totalReserved += usage.getCommitted();
            totalMax += usage.getMax();
            MemoryUsage collect = pool.getCollectionUsage();
            if (collect != null) {
                sb.append(new Formatter().format(" collectUsed: %,d", collect.getUsed()));
                collectUsed = collect.getUsed() > 0L ? (collectUsed += collect.getUsed()) : (collectUsed += usage.getUsed());
            } else {
                collectUsed += usage.getUsed();
            }
            sb.append('\n');
        }
        sb.append(new Formatter().format("RuntimeTotal=%,d  RuntimeMax=%,d  RuntimeFree=%,d  TotUsed=%,d  TotReserved=%,d  TotMax=%,d  CollectUsed=%,d\n", Runtime.getRuntime().totalMemory(), Runtime.getRuntime().maxMemory(), Runtime.getRuntime().freeMemory(), totalUsed, totalReserved, totalMax, collectUsed));
        return sb.toString();
    }

    public static String[] getGarbageCollectorNames() {
        List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();
        String[] toRet = new String[gcs.size()];
        int i = 0;
        for (GarbageCollectorMXBean gc : gcs) {
            toRet[i] = gc.getName();
            ++i;
        }
        return toRet;
    }

    public static String[] getHeapPoolNames() {
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        ArrayList<String> array = new ArrayList<String>(pools.size());
        for (MemoryPoolMXBean pool : pools) {
            array.add(pool.getName());
        }
        String[] toRet = new String[array.size()];
        return array.toArray(toRet);
    }

    public static void shutdown() {
        sInstance.doShutdown();
        sInstance = null;
    }

    public static void startup() {
        sInstance = new MemoryStats();
    }

    private static final String getGCCountColName(String gcName) {
        return GC_PREFIX + MemoryStats.spaceToUs(gcName) + COUNT_SUFFIX;
    }

    private static final String getGCTimeColName(String gcName) {
        return GC_PREFIX + MemoryStats.spaceToUs(gcName) + TIME_SUFFIX;
    }

    private static final String getPoolFreeSizeColName(String poolName) {
        return MEMPOOL_PREFIX + MemoryStats.spaceToUs(poolName) + FREE_SUFFIX;
    }

    private static final String getPoolUsedSizeColName(String poolName) {
        return MEMPOOL_PREFIX + MemoryStats.spaceToUs(poolName) + USED_SUFFIX;
    }

    private static final String spaceToUs(String s) {
        return s.replace(' ', '_');
    }

    private MemoryStats() {
        ZimbraPerf.addStatsCallback(this);
        for (String gc : MemoryStats.getGarbageCollectorNames()) {
            gc = gc.toLowerCase();
            ZimbraPerf.addRealtimeStatName(MemoryStats.getGCCountColName(gc));
            ZimbraPerf.addRealtimeStatName(MemoryStats.getGCTimeColName(gc));
        }
        ZimbraPerf.addRealtimeStatName(GC_MINOR_COUNT);
        ZimbraPerf.addRealtimeStatName(GC_MINOR_TIME);
        ZimbraPerf.addRealtimeStatName(GC_MAJOR_COUNT);
        ZimbraPerf.addRealtimeStatName(GC_MAJOR_TIME);
        for (String pool : MemoryStats.getHeapPoolNames()) {
            pool = pool.toLowerCase();
            ZimbraPerf.addRealtimeStatName(MemoryStats.getPoolUsedSizeColName(pool));
            ZimbraPerf.addRealtimeStatName(MemoryStats.getPoolFreeSizeColName(pool));
        }
        ZimbraPerf.addRealtimeStatName(HEAP_USED);
        ZimbraPerf.addRealtimeStatName(HEAP_FREE);
    }

    @Override
    public Map<String, Object> getStatData() {
        HashMap<String, Object> toRet = new HashMap<String, Object>();
        long minorCount = 0L;
        long minorTime = 0L;
        long majorCount = 0L;
        long majorTime = 0L;
        List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gc : gcs) {
            String gcName = gc.getName();
            long count = gc.getCollectionCount();
            long time = gc.getCollectionTime();
            String gcNameLower = gcName.toLowerCase();
            toRet.put(MemoryStats.getGCCountColName(gcNameLower), count);
            toRet.put(MemoryStats.getGCTimeColName(gcNameLower), time);
            if (sMajorCollectors.contains(gcName)) {
                majorCount += count;
                majorTime += time;
                continue;
            }
            minorCount += count;
            minorTime += time;
        }
        toRet.put(GC_MINOR_COUNT, minorCount);
        toRet.put(GC_MINOR_TIME, minorTime);
        toRet.put(GC_MAJOR_COUNT, majorCount);
        toRet.put(GC_MAJOR_TIME, majorTime);
        long heapTotal = 0L;
        long heapUsed = 0L;
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean pool : pools) {
            long used;
            long committed;
            String poolName = pool.getName().toLowerCase();
            try {
                MemoryUsage usage = pool.getUsage();
                committed = usage.getCommitted();
                used = usage.getUsed();
            }
            catch (IllegalArgumentException e) {
                String msg = e.getMessage();
                Pattern p = Pattern.compile("committed = (\\d+) should be < max = (\\d+)");
                Matcher m = p.matcher(msg);
                if (m.find()) {
                    committed = Long.parseLong(m.group(1));
                    used = Long.parseLong(m.group(2));
                }
                committed = 0L;
                used = 0L;
            }
            if (pool.getType() == MemoryType.HEAP) {
                heapTotal += committed;
                heapUsed += used;
            }
            long curpoolFree = committed - used;
            toRet.put(MemoryStats.getPoolUsedSizeColName(poolName), used);
            toRet.put(MemoryStats.getPoolFreeSizeColName(poolName), curpoolFree);
        }
        toRet.put(HEAP_USED, heapUsed);
        toRet.put(HEAP_FREE, heapTotal - heapUsed);
        return toRet;
    }

    private void doShutdown() {
    }

    static {
        sInstance = null;
        sMajorCollectors = new HashSet<String>(4);
        sMajorCollectors.add(MEMMGR_GC_MAJOR_MSC);
        sMajorCollectors.add(MEMMGR_GC_MAJOR_CMS);
        sMajorCollectors.add(MEMMGR_GC_MAJOR_PS_MARKSWEEP);
        sMajorCollectors.add(MEMMGR_GC_MAJOR_TRAIN);
    }
}

