/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.TimeoutMap;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSession {
    private static final Random RANDOM;
    private static Map<String, Object> sBadSmtpHosts;
    private static final String[] NO_HOSTS;

    public static Session getSession() throws MessagingException {
        return JMSession.getSession(null);
    }

    public static Session getSession(Domain domain) throws MessagingException {
        Server server;
        String smtpHost = null;
        try {
            server = Provisioning.getInstance().getLocalServer();
            smtpHost = JMSession.getRandomSmtpHost(domain);
        }
        catch (ServiceException e) {
            throw new MessagingException("Unable initialize JavaMail session", (Exception)e);
        }
        if (smtpHost == null) {
            String msg = "No SMTP hosts available";
            if (domain != null) {
                msg = msg + " for domain " + domain.getName();
            }
            throw new MessagingException(msg);
        }
        Properties props = new Properties();
        props.setProperty("mail.mime.address.strict", "false");
        props.setProperty("mail.smtp.host", smtpHost);
        props.setProperty("mail.smtp.port", JMSession.getValue(server, domain, "zimbraSmtpPort"));
        props.setProperty("mail.smtp.localhost", LC.zimbra_server_hostname.value());
        String sTimeout = JMSession.getValue(server, domain, "zimbraSmtpTimeout");
        long timeout = sTimeout == null ? 60L : Long.parseLong(sTimeout);
        sTimeout = Long.toString(timeout * 1000L);
        props.setProperty("mail.smtp.connectiontimeout", sTimeout);
        props.setProperty("mail.smtp.timeout", sTimeout);
        Boolean sendPartial = Boolean.parseBoolean(JMSession.getValue(server, domain, "zimbraSmtpSendPartial"));
        props.setProperty("mail.smtp.sendpartial", sendPartial.toString());
        Session session = Session.getInstance((Properties)props);
        return session;
    }

    public static Session getSmtpSession(Account account) throws MessagingException {
        Domain domain = null;
        if (account != null) {
            try {
                domain = Provisioning.getInstance().getDomain(account);
            }
            catch (ServiceException e) {
                ZimbraLog.smtp.warn("Unable to look up domain for account %s.", (Object)account.getName(), e);
            }
        }
        Session session = JMSession.getSession(domain);
        if (LC.javamail_smtp_debug.booleanValue() || account != null && account.isSmtpEnableTrace()) {
            session.setDebug(true);
        }
        return session;
    }

    private static String getValue(Server server, Domain domain, String attrName) {
        String value = null;
        if (domain != null) {
            value = domain.getAttr(attrName);
        }
        if (StringUtil.isNullOrEmpty(value)) {
            return server.getAttr(attrName);
        }
        return value;
    }

    public static void resetSmtpHosts() {
        ZimbraLog.smtp.debug("Resetting bad SMTP hosts.");
        sBadSmtpHosts.clear();
    }

    private static String getRandomSmtpHost(Domain domain) throws ServiceException {
        String[] hosts = JMSession.getSmtpHostsFromLdap(domain);
        if (hosts.length == 0) {
            return null;
        }
        String host = null;
        host = hosts.length == 1 ? hosts[0] : hosts[RANDOM.nextInt(hosts.length)];
        if (!sBadSmtpHosts.containsKey(host)) {
            return host;
        }
        if (hosts.length == 1) {
            return null;
        }
        ArrayList hostList = new ArrayList();
        Collections.addAll(hostList, hosts);
        Collections.shuffle(hostList);
        for (String currentHost : hostList) {
            if (sBadSmtpHosts.containsKey(currentHost)) continue;
            return currentHost;
        }
        return null;
    }

    public static Set<String> getSmtpHosts(Domain domain) throws ServiceException {
        HashSet<String> hosts = new HashSet<String>();
        for (String host : JMSession.getSmtpHostsFromLdap(domain)) {
            if (sBadSmtpHosts.containsKey(host)) continue;
            hosts.add(host);
        }
        return hosts;
    }

    public static void markSmtpHostBad(String hostName) {
        ZimbraLog.smtp.info("Disallowing connections to %s for %d milliseconds.", hostName, LC.smtp_host_retry_millis.intValue());
        sBadSmtpHosts.put(hostName, null);
    }

    private static String[] getSmtpHostsFromLdap(Domain domain) throws ServiceException {
        String[] hosts = NO_HOSTS;
        if (domain != null) {
            hosts = domain.getSmtpHostname();
        }
        if (hosts.length == 0) {
            Server server = Provisioning.getInstance().getLocalServer();
            hosts = server.getSmtpHostname();
        }
        return hosts;
    }

    static {
        System.setProperty("mail.mime.base64.ignoreerrors", "true");
        RANDOM = new Random();
        sBadSmtpHosts = Collections.synchronizedMap(new TimeoutMap(LC.smtp_host_retry_millis.intValue()));
        NO_HOSTS = new String[0];
    }
}

