/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.httpclient.URLUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class GalSyncAccountUtil {
    private static final int CREATE_ACCOUNT = 10;
    private static final int DELETE_ACCOUNT = 11;
    private static final int TRICKLE_SYNC = 12;
    private static final int FULL_SYNC = 13;
    private static final int FORCE_SYNC = 14;
    private static final String CREATE_ACCOUNT_COMMAND = "createaccount";
    private static final String DELETE_ACCOUNT_COMMAND = "deleteaccount";
    private static final String TRICKLE_SYNC_COMMAND = "tricklesync";
    private static final String FULL_SYNC_COMMAND = "fullsync";
    private static final String FORCE_SYNC_COMMAND = "forcesync";
    private static Map<String, Integer> mCommands;
    private String mUsername;
    private String mPassword;
    private String mAdminURL;
    private ZAuthToken mAuth;
    private SoapHttpTransport mTransport;
    private String mAccountId;
    private String mAccountName;
    private String mDataSourceId;
    private String mDataSourceName;
    private boolean mFullSync;
    private boolean mForceSync;

    private static void usage() {
        System.out.println("zmgsautil: {command}");
        System.out.println("\tcreateAccount -a {account-name} -n {datasource-name} --domain {domain-name} -t zimbra|ldap [-f {folder-name}] [-p {polling-interval}]");
        System.out.println("\tdeleteAccount [-a {account-name} | -i {account-id}]");
        System.out.println("\ttrickleSync [-a {account-name} | -i {account-id}] [-d {datasource-id}] [-n {datasource-name}]");
        System.out.println("\tfullSync [-a {account-name} | -i {account-id}] [-d {datasource-id}] [-n {datasource-name}]");
        System.out.println("\tforceSync [-a {account-name} | -i {account-id}] [-d {datasource-id}] [-n {datasource-name}]");
        System.exit(1);
    }

    private static void addCommand(String cmd, int cmdId) {
        mCommands.put(cmd, new Integer(cmdId));
    }

    private static int lookupCmd(String cmd) {
        Integer i = mCommands.get(cmd.toLowerCase());
        if (i == null) {
            GalSyncAccountUtil.usage();
        }
        return i;
    }

    private static void setup() {
        mCommands = new HashMap<String, Integer>();
        GalSyncAccountUtil.addCommand(CREATE_ACCOUNT_COMMAND, 10);
        GalSyncAccountUtil.addCommand(DELETE_ACCOUNT_COMMAND, 11);
        GalSyncAccountUtil.addCommand(TRICKLE_SYNC_COMMAND, 12);
        GalSyncAccountUtil.addCommand(FULL_SYNC_COMMAND, 13);
        GalSyncAccountUtil.addCommand(FORCE_SYNC_COMMAND, 14);
    }

    private GalSyncAccountUtil() {
        String server = LC.zimbra_zmprov_default_soap_server.value();
        this.mAdminURL = URLUtil.getAdminURL(server);
        this.mUsername = LC.zimbra_ldap_user.value();
        this.mPassword = LC.zimbra_ldap_password.value();
    }

    private void checkArgs() throws ServiceException {
        if (this.mAccountName != null) {
            Account acct = Provisioning.getInstance().getAccountByName(this.mAccountName);
            if (acct == null) {
                throw AccountServiceException.NO_SUCH_ACCOUNT(this.mAccountName);
            }
            this.mAccountId = acct.getId();
        }
        if (this.mAccountId == null || this.mDataSourceId == null && this.mDataSourceName == null) {
            GalSyncAccountUtil.usage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncGalAccount() throws ServiceException, IOException {
        this.checkArgs();
        this.mTransport = null;
        try {
            this.mTransport = new SoapHttpTransport(this.mAdminURL);
            this.auth();
            this.mTransport.setAuthToken(this.mAuth);
            Element.XMLElement req = new Element.XMLElement(AdminConstants.SYNC_GAL_ACCOUNT_REQUEST);
            Element acct = req.addElement("account");
            acct.addAttribute("id", this.mAccountId);
            Element ds = acct.addElement("datasource");
            if (this.mDataSourceId != null) {
                ds.addAttribute("by", "id").setText(this.mDataSourceId);
            } else {
                ds.addAttribute("by", "name").setText(this.mDataSourceName);
            }
            if (this.mFullSync) {
                ds.addAttribute("fullSync", "TRUE");
            }
            if (this.mForceSync) {
                ds.addAttribute("reset", "TRUE");
            }
            this.mTransport.invoke(req);
            Object var5_4 = null;
            if (this.mTransport != null) {
                this.mTransport.shutdown();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.mTransport != null) {
                this.mTransport.shutdown();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element createGalSyncAccount(String accountName, String dsName, String domain, String type, String folder, String pollingInterval) throws ServiceException, IOException {
        this.mTransport = null;
        try {
            this.mTransport = new SoapHttpTransport(this.mAdminURL);
            this.auth();
            this.mTransport.setAuthToken(this.mAuth);
            Element.XMLElement req = new Element.XMLElement(AdminConstants.CREATE_GAL_SYNC_ACCOUNT_REQUEST);
            req.addAttribute("name", dsName);
            req.addAttribute("domain", domain);
            req.addAttribute("type", type);
            if (folder != null) {
                req.addAttribute("folder", folder);
            }
            Element acct = req.addElement("account");
            acct.addAttribute("by", Provisioning.AccountBy.name.name());
            acct.setText(accountName);
            if (pollingInterval != null) {
                req.addElement("a").addAttribute("n", "zimbraDataSourcePollingInterval").setText(pollingInterval);
            }
            Element element = this.mTransport.invokeWithoutSession(req);
            Object var11_10 = null;
            if (this.mTransport != null) {
                this.mTransport.shutdown();
            }
            return element;
        }
        catch (Throwable throwable) {
            block5: {
                Object var11_11 = null;
                if (this.mTransport == null) break block5;
                this.mTransport.shutdown();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element deleteGalSyncAccount(String name, String id) throws ServiceException, IOException {
        this.mTransport = null;
        try {
            String account;
            Provisioning.AccountBy by;
            this.mTransport = new SoapHttpTransport(this.mAdminURL);
            this.auth();
            this.mTransport.setAuthToken(this.mAuth);
            Element.XMLElement req = new Element.XMLElement(AdminConstants.DELETE_GAL_SYNC_ACCOUNT_REQUEST);
            Element acct = req.addElement("account");
            if (name == null) {
                by = Provisioning.AccountBy.id;
                account = id;
            } else {
                by = Provisioning.AccountBy.name;
                account = name;
            }
            acct.addAttribute("by", by.name());
            acct.setText(account);
            Element element = this.mTransport.invokeWithoutSession(req);
            Object var9_8 = null;
            if (this.mTransport != null) {
                this.mTransport.shutdown();
            }
            return element;
        }
        catch (Throwable throwable) {
            block5: {
                Object var9_9 = null;
                if (this.mTransport == null) break block5;
                this.mTransport.shutdown();
            }
            throw throwable;
        }
    }

    private void setAccountId(String aid) {
        this.mAccountId = aid;
    }

    private void setAccountName(String name) {
        this.mAccountName = name;
    }

    private void setDataSourceId(String did) {
        this.mDataSourceId = did;
    }

    private void setDataSourceName(String name) {
        this.mDataSourceName = name;
    }

    private void setFullSync() {
        this.mFullSync = true;
    }

    private void setForceSync() {
        this.mForceSync = true;
    }

    private void auth() throws ServiceException, IOException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.AUTH_REQUEST);
        req.addElement("name").setText(this.mUsername);
        req.addElement("password").setText(this.mPassword);
        Element resp = this.mTransport.invoke(req);
        this.mAuth = new ZAuthToken(resp.getElement("authToken"), true);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            GalSyncAccountUtil.usage();
        }
        CliUtil.toolSetup();
        GnuParser parser = new GnuParser();
        Options options = new Options();
        options.addOption("a", "account", true, "gal sync account name");
        options.addOption("i", "id", true, "gal sync account id");
        options.addOption("n", "name", true, "datasource name");
        options.addOption("d", "did", true, "datasource id");
        options.addOption("x", "domain", true, "for domain gal sync account");
        options.addOption("f", "folder", true, "folder id");
        options.addOption("p", "polling", true, "polling interval");
        options.addOption("t", "type", true, "gal type");
        options.addOption("h", "help", true, "help");
        CommandLine cl = null;
        boolean err = false;
        try {
            cl = parser.parse(options, args, false);
        }
        catch (ParseException pe) {
            System.out.println("error: " + pe.getMessage());
            err = true;
        }
        GalSyncAccountUtil cli = new GalSyncAccountUtil();
        if (err || cl.hasOption('h')) {
            GalSyncAccountUtil.usage();
        }
        if (cl.hasOption('i')) {
            cli.setAccountId(cl.getOptionValue('i'));
        }
        if (cl.hasOption('a')) {
            cli.setAccountName(cl.getOptionValue('a'));
        }
        if (cl.hasOption('n')) {
            cli.setDataSourceName(cl.getOptionValue('n'));
        }
        if (cl.hasOption('d')) {
            cli.setDataSourceId(cl.getOptionValue('d'));
        }
        GalSyncAccountUtil.setup();
        int cmd = GalSyncAccountUtil.lookupCmd(args[0]);
        try {
            switch (cmd) {
                case 12: {
                    cli.syncGalAccount();
                    break;
                }
                case 13: {
                    cli.setFullSync();
                    cli.syncGalAccount();
                    break;
                }
                case 14: {
                    cli.setForceSync();
                    cli.syncGalAccount();
                    break;
                }
                case 10: {
                    String acctName = cl.getOptionValue('a');
                    String dsName = cl.getOptionValue('n');
                    String domain = cl.getOptionValue('x');
                    String type = cl.getOptionValue('t');
                    String folderName = cl.getOptionValue('f');
                    String pollingInterval = cl.getOptionValue('p');
                    if (acctName == null || dsName == null || type == null || type.compareTo("zimbra") != 0 && type.compareTo("ldap") != 0) {
                        GalSyncAccountUtil.usage();
                    }
                    for (Element account : cli.createGalSyncAccount(acctName, dsName, domain, type, folderName, pollingInterval).listElements("account")) {
                        System.out.println(account.getAttribute("name") + "\t" + account.getAttribute("id"));
                    }
                    break;
                }
                case 11: {
                    String name = cl.getOptionValue('a');
                    String id = cl.getOptionValue('i');
                    if (name == null && id == null) {
                        GalSyncAccountUtil.usage();
                    }
                    cli.deleteGalSyncAccount(name, id);
                    break;
                }
                default: {
                    GalSyncAccountUtil.usage();
                }
            }
        }
        catch (ServiceException se) {
            System.out.println("Error: " + se.getMessage());
        }
    }
}

