/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.db.DbConfig;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.util.Zimbra;
import java.io.File;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class Config {
    public static final String KEY_PURGE_LAST_MAILBOX_ID = "purge.lastMailboxId";
    public static final int D_LMTP_THREADS = 10;
    public static final int D_LMTP_BIND_PORT = 7025;
    public static final int D_IMAP_BIND_PORT = 143;
    public static final int D_IMAP_SSL_BIND_PORT = 993;
    public static final int D_POP3_BIND_PORT = 110;
    public static final int D_POP3_SSL_BIND_PORT = 995;
    public static final int D_SMTP_TIMEOUT = 60;
    public static final int D_SMTP_PORT = 25;
    public static final long D_ZIMBRA_LAST_LOGON_TIMESTAMP_FREQUENCY = 604800000L;
    private static Map<String, DbConfig> mConfigMap;
    private static Timestamp mYoungest;
    private static boolean sUserServicesEnabled;
    private static final Object sUserServicesEnabledGuard;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void init(Timestamp ts) throws ServiceException {
        block8: {
            Object object = DbMailbox.getSynchronizer();
            synchronized (object) {
                DbPool.Connection conn = null;
                try {
                    conn = DbPool.getConnection();
                    mConfigMap = DbConfig.getAll(conn, ts);
                    for (DbConfig c : mConfigMap.values()) {
                        if (mYoungest == null) {
                            mYoungest = c.getModified();
                            continue;
                        }
                        if (!c.getModified().after(mYoungest)) continue;
                        mYoungest = c.getModified();
                    }
                    Object var6_6 = null;
                    if (conn == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (conn == null) throw throwable;
                    DbPool.quietClose(conn);
                    throw throwable;
                }
                DbPool.quietClose(conn);
            }
        }
        Server serverConfig = Provisioning.getInstance().getLocalServer();
        boolean userServicesEnabled = serverConfig.getBooleanAttr("zimbraUserServicesEnabled", true);
        Object object = sUserServicesEnabledGuard;
        synchronized (object) {
            sUserServicesEnabled = userServicesEnabled;
            return;
        }
    }

    private static synchronized void initConfig() {
        if (mConfigMap == null) {
            try {
                Config.init(null);
            }
            catch (Exception e) {
                Zimbra.halt("Config initialization failed", e);
            }
        }
    }

    public static synchronized String getString(String name, String defaultValue) {
        Config.initConfig();
        DbConfig c = mConfigMap.get(name);
        return c != null ? c.getValue() : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setString(String name, String value) throws ServiceException {
        Config.initConfig();
        Object object = DbMailbox.getSynchronizer();
        synchronized (object) {
            DbPool.Connection conn = null;
            try {
                conn = DbPool.getConnection();
                DbConfig c = DbConfig.set(conn, name, value);
                mConfigMap.put(name, c);
                conn.commit();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                DbPool.quietClose(conn);
                throw throwable;
            }
            DbPool.quietClose(conn);
        }
    }

    public static synchronized int getInt(String name, int defaultValue) {
        Config.initConfig();
        String value = Config.getString(name, null);
        if (value == null) {
            return defaultValue;
        }
        int intValue = defaultValue;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            ZimbraLog.misc.warn("Invalid integer value '%s' for config key '%s'.  Returning default value %d.", value, name, intValue);
        }
        return intValue;
    }

    public static synchronized void setInt(String name, int value) throws ServiceException {
        Config.initConfig();
        Config.setString(name, Integer.toString(value));
    }

    public static synchronized void setLong(String name, long value) throws ServiceException {
        Config.initConfig();
        Config.setString(name, Long.toString(value));
    }

    public static synchronized long getLong(String name, long defaultValue) {
        Config.initConfig();
        String value = Config.getString(name, null);
        if (value == null) {
            return defaultValue;
        }
        long longValue = defaultValue;
        try {
            longValue = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            ZimbraLog.misc.warn("Invalid long value '%s' for config key '%s'.  Returning default value %d.", value, name, longValue);
        }
        return longValue;
    }

    public static synchronized boolean getBoolean(String name, boolean defaultValue) {
        Config.initConfig();
        String value = Config.getString(name, null);
        return value == null ? defaultValue : value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equals("1");
    }

    public static File getPathRelativeToZimbraHome(String path) {
        char first = path.charAt(0);
        if (first == File.separatorChar || first == '/') {
            return new File(path);
        }
        String home = LC.zimbra_home.value();
        return new File(home, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableUserServices(boolean enabled) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Server serverConfig = prov.getLocalServer();
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraUserServicesEnabled", enabled ? "TRUE" : "FALSE");
        prov.modifyAttrs(serverConfig, attrs);
        Object object = sUserServicesEnabledGuard;
        synchronized (object) {
            sUserServicesEnabled = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean userServicesEnabled() {
        Config.initConfig();
        Object object = sUserServicesEnabledGuard;
        synchronized (object) {
            return sUserServicesEnabled;
        }
    }

    static {
        sUserServicesEnabledGuard = new Object();
    }
}

