/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildInfo {
    public static final String VERSION;
    public static final String TYPE;
    public static final String RELEASE;
    public static final String DATE;
    public static final String HOST;
    public static final String PLATFORM;
    public static final String MAJORVERSION;
    public static final String MINORVERSION;
    public static final String MICROVERSION;
    public static final String BUILDNUM;
    public static final String FULL_VERSION;

    public static void main(String[] args) {
        System.out.println("Version: " + VERSION);
        System.out.println("Release: " + RELEASE);
        System.out.println("Build Date: " + DATE);
        System.out.println("Build Host: " + HOST);
        System.out.println("Full Version: " + FULL_VERSION);
        System.out.println("DB Version: 63");
        System.out.println("Index Version: 2");
    }

    static {
        String version = "unknown";
        String type = "unknown";
        String release = "unknown";
        String date = "unknown";
        String host = "unknown";
        String majorversion = "unknown";
        String minorversion = "unknown";
        String microversion = "unknown";
        String platform = "unknown";
        String buildnum = "buildnum";
        try {
            Class<?> clz = Class.forName("com.zimbra.cs.util.BuildInfoGenerated");
            version = (String)clz.getField("VERSION").get(null);
            type = (String)clz.getField("TYPE").get(null);
            release = (String)clz.getField("RELEASE").get(null);
            date = (String)clz.getField("DATE").get(null);
            host = (String)clz.getField("HOST").get(null);
            majorversion = (String)clz.getField("MAJORVERSION").get(null);
            minorversion = (String)clz.getField("MINORVERSION").get(null);
            microversion = (String)clz.getField("MICROVERSION").get(null);
            platform = (String)clz.getField("PLATFORM").get(null);
            buildnum = (String)clz.getField("BUILDNUM").get(null);
        }
        catch (Exception e) {
            System.err.println("Exception occurred during introspecting; version information incomplete");
            e.printStackTrace();
        }
        VERSION = version;
        TYPE = type;
        RELEASE = release;
        DATE = date;
        HOST = host;
        PLATFORM = platform;
        MAJORVERSION = majorversion;
        MINORVERSION = minorversion;
        MICROVERSION = microversion;
        BUILDNUM = buildnum;
        FULL_VERSION = TYPE != null && TYPE.length() > 0 ? VERSION + " " + RELEASE + " " + DATE + " " + TYPE : VERSION + " " + RELEASE + " " + DATE;
    }

    public static class Version {
        public static final String FUTURE = "future";
        private static Pattern mPattern = Pattern.compile("([a-zA-Z]+)(\\d*)");
        private boolean mFuture;
        private int mMajor;
        private int mMinor;
        private int mPatch;
        private int mBuildNum;
        private Release mRel;
        private int mRelNum;
        private String mVersion;

        public Version(String version) throws ServiceException {
            block11: {
                this.mVersion = version;
                if (FUTURE.equalsIgnoreCase(version)) {
                    this.mFuture = true;
                    return;
                }
                String ver = version;
                int underscoreAt = version.indexOf(95);
                int lastUnderscoreAt = version.lastIndexOf(95);
                if (lastUnderscoreAt == -1 || lastUnderscoreAt == underscoreAt) {
                    lastUnderscoreAt = version.length() - 1;
                }
                if (underscoreAt != -1) {
                    ver = version.substring(0, underscoreAt);
                    String rel = version.substring(underscoreAt + 1, lastUnderscoreAt);
                    Matcher matcher = mPattern.matcher(version);
                    if (matcher.find()) {
                        this.mRel = Release.fromString(matcher.group(1));
                        String relNum = matcher.group(2);
                        if (!StringUtil.isNullOrEmpty(relNum)) {
                            this.mRelNum = Integer.parseInt(relNum);
                        }
                    }
                    if (lastUnderscoreAt != version.length() - 1) {
                        this.mBuildNum = Integer.parseInt(version.substring(lastUnderscoreAt + 1));
                    }
                }
                String[] parts = ver.split("\\.");
                try {
                    if (parts.length == 1) {
                        this.mMajor = Integer.parseInt(parts[0]);
                        break block11;
                    }
                    if (parts.length == 2) {
                        this.mMajor = Integer.parseInt(parts[0]);
                        this.mMinor = Integer.parseInt(parts[1]);
                        break block11;
                    }
                    if (parts.length == 3) {
                        this.mMajor = Integer.parseInt(parts[0]);
                        this.mMinor = Integer.parseInt(parts[1]);
                        this.mPatch = Integer.parseInt(parts[2]);
                        break block11;
                    }
                    throw ServiceException.FAILURE("invalid version format:" + version, null);
                }
                catch (NumberFormatException e) {
                    throw ServiceException.FAILURE("invalid version format:" + version, e);
                }
            }
        }

        public static int compare(String versionX, String versionY) throws ServiceException {
            Version x = new Version(versionX);
            Version y = new Version(versionY);
            return x.compare(y);
        }

        public int compare(String version) throws ServiceException {
            Version other = new Version(version);
            return this.compare(other);
        }

        public int compare(Version version) throws ServiceException {
            if (this.mFuture) {
                if (version.mFuture) {
                    return 0;
                }
                return 1;
            }
            if (version.mFuture) {
                return -1;
            }
            int r = this.mMajor - version.mMajor;
            if (r != 0) {
                return r;
            }
            r = this.mMinor - version.mMinor;
            if (r != 0) {
                return r;
            }
            r = this.mPatch - version.mPatch;
            if (r != 0) {
                return r;
            }
            if (this.mRel != null) {
                if (version.mRel != null) {
                    r = this.mRel.ordinal() - version.mRel.ordinal();
                    if (r != 0) {
                        return r;
                    }
                    return this.mRelNum - version.mRelNum;
                }
                return 1;
            }
            if (version.mRel != null) {
                return -1;
            }
            return 0;
        }

        public boolean isFuture() {
            return this.mFuture;
        }

        public String toString() {
            return this.mVersion;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Release {
            BETA,
            M,
            RC,
            GA;


            public static Release fromString(String rel) throws ServiceException {
                try {
                    return Release.valueOf(rel);
                }
                catch (IllegalArgumentException e) {
                    throw ServiceException.INVALID_REQUEST("unknown release: " + rel, e);
                }
            }
        }
    }
}

