/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.EmailUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import java.io.UnsupportedEncodingException;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class AccountUtil {
    public static InternetAddress getFriendlyEmailAddress(Account acct) {
        String address;
        String personalPart = acct.getAttr("displayName");
        if (personalPart == null) {
            personalPart = acct.getAttr("cn");
        }
        if (personalPart == null || personalPart.trim().equals("") || personalPart.equals(acct.getAttr("uid"))) {
            personalPart = null;
        }
        try {
            address = AccountUtil.getCanonicalAddress(acct);
        }
        catch (ServiceException se) {
            ZimbraLog.misc.warn((Object)"unexpected exception canonicalizing address, will use account name", se);
            address = acct.getName();
        }
        try {
            return new InternetAddress(address, personalPart, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                return new InternetAddress(address, personalPart);
            }
            catch (UnsupportedEncodingException e2) {
                InternetAddress ia = new InternetAddress();
                ia.setAddress(address);
                return ia;
            }
        }
    }

    public static boolean isDirectRecipient(Account acct, MimeMessage mm) throws ServiceException, MessagingException {
        return AccountUtil.isDirectRecipient(acct, null, mm, -1);
    }

    public static boolean isDirectRecipient(Account acct, String[] otherAccountAddrs, MimeMessage mm, int maxToCheck) throws ServiceException, MessagingException {
        String accountAddress = acct.getName();
        String canonicalAddress = AccountUtil.getCanonicalAddress(acct);
        String[] accountAliases = acct.getMailAlias();
        Address[] recipients = mm.getAllRecipients();
        if (recipients == null) {
            return false;
        }
        int numRecipientsToCheck = maxToCheck <= 0 ? recipients.length : Math.min(recipients.length, maxToCheck);
        for (int i = 0; i < numRecipientsToCheck; ++i) {
            String msgAddress = ((InternetAddress)recipients[i]).getAddress();
            if (AccountUtil.addressMatchesAccount(accountAddress, canonicalAddress, accountAliases, msgAddress)) {
                return true;
            }
            if (otherAccountAddrs == null) continue;
            for (String otherAddr : otherAccountAddrs) {
                if (!otherAddr.equalsIgnoreCase(msgAddress)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getCanonicalAddress(Account account) throws ServiceException {
        String[] parts;
        String ca = account.getAttr("zimbraMailCanonicalAddress");
        if (ca == null) {
            ca = account.getName();
        }
        if ((parts = EmailUtil.getLocalPartAndDomain(ca)) == null) {
            return ca;
        }
        Domain domain = Provisioning.getInstance().get(Provisioning.DomainBy.name, parts[1]);
        if (domain == null) {
            return ca;
        }
        String domainCatchAll = domain.getAttr("zimbraMailCatchAllCanonicalAddress");
        if (domainCatchAll != null) {
            return parts[0] + domainCatchAll;
        }
        return ca;
    }

    public static boolean allowFromAddress(Account acct, String fromAddr) throws ServiceException {
        if (fromAddr == null) {
            return false;
        }
        if (acct.getBooleanAttr("zimbraAllowAnyFromAddress", false)) {
            return true;
        }
        if (AccountUtil.addressMatchesAccount(acct, fromAddr)) {
            return true;
        }
        String[] allowedAddrs = acct.getMultiAttr("zimbraAllowFromAddress");
        if (allowedAddrs == null) {
            return false;
        }
        for (String addr : allowedAddrs) {
            if (!fromAddr.equalsIgnoreCase(addr)) continue;
            return true;
        }
        return false;
    }

    public static boolean addressMatchesAccount(Account acct, String givenAddress) throws ServiceException {
        if (givenAddress == null) {
            return false;
        }
        String accountAddress = acct.getName();
        String canonicalAddress = AccountUtil.getCanonicalAddress(acct);
        String[] accountAliases = acct.getMailAlias();
        return AccountUtil.addressMatchesAccount(accountAddress, canonicalAddress, accountAliases, givenAddress);
    }

    private static boolean addressMatchesAccount(String accountAddress, String canonicalAddress, String[] accountAliases, String givenAddress) {
        if (givenAddress == null) {
            return false;
        }
        if (givenAddress.equalsIgnoreCase(accountAddress)) {
            return true;
        }
        if (givenAddress.equalsIgnoreCase(canonicalAddress)) {
            return true;
        }
        for (int j = 0; j < accountAliases.length; ++j) {
            if (!givenAddress.equalsIgnoreCase(accountAliases[j])) continue;
            return true;
        }
        try {
            String addrByDomainAlias = Provisioning.getInstance().getEmailAddrByDomainAlias(givenAddress);
            if (addrByDomainAlias != null && addrByDomainAlias.equals(accountAddress)) {
                return true;
            }
        }
        catch (ServiceException e) {
            ZimbraLog.account.warn("unable to get addr by alias domain" + e);
        }
        return false;
    }

    public static String getSoapUri(Account account) {
        String base = AccountUtil.getBaseUri(account);
        return base == null ? null : base + "/service/soap/";
    }

    public static String getBaseUri(Account account) {
        if (account == null) {
            return null;
        }
        try {
            Server server = Provisioning.getInstance().getServer(account);
            if (server == null) {
                ZimbraLog.account.warn("no server associated with acccount " + account.getName());
                return null;
            }
            return AccountUtil.getBaseUri(server);
        }
        catch (ServiceException e) {
            ZimbraLog.account.warn((Object)("error fetching SOAP URI for account " + account.getName()), e);
            return null;
        }
    }

    public static String getBaseUri(Server server) {
        if (server == null) {
            return null;
        }
        String host = server.getAttr("zimbraServiceHostname");
        String mode = server.getAttr("zimbraMailMode", "http");
        int port = server.getIntAttr("zimbraMailPort", 0);
        if (port > 0 && !mode.equalsIgnoreCase("https") && !mode.equalsIgnoreCase("redirect")) {
            return "http://" + host + ':' + port;
        }
        if (!mode.equalsIgnoreCase("http") && (port = server.getIntAttr("zimbraMailSSLPort", 0)) > 0) {
            return "https://" + host + ':' + port;
        }
        ZimbraLog.account.warn("no service port available on host " + host);
        return null;
    }

    public static void addAccountToLogContext(Provisioning prov, String id, String nameKey, String idOnlyKey, AuthToken authToken) {
        Account acct = null;
        try {
            acct = prov.get(Provisioning.AccountBy.id, id, authToken);
        }
        catch (ServiceException se) {
            ZimbraLog.misc.warn((Object)("unable to lookup account for log, id: " + id), se);
        }
        if (acct == null) {
            ZimbraLog.addToContext(idOnlyKey, id);
        } else {
            ZimbraLog.addToContext(nameKey, acct.getName());
        }
    }
}

