/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.upgrade;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.ParsedContact;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ContactUpgrade {
    private ContactUpgrade() {
    }

    public static void upgradeContactsTo1_6(Mailbox mbox) throws ServiceException {
        OperationContext octxt = new OperationContext(mbox);
        List<Contact> contacts = mbox.getContactList(octxt, -1, SortBy.NONE);
        for (Contact contact : contacts) {
            if (contact.get("workEmail") == null) continue;
            ContactUpgrade.upgradeContactTo1_6(octxt, mbox, contact);
        }
    }

    static void upgradeContactTo1_6(OperationContext octxt, Mailbox mbox, Contact contact) throws ServiceException {
        Map<String, String> fields = contact.getFields();
        HashMap<String, String> nfields = new HashMap<String, String>();
        int emailLen = "email".length();
        int number = 0;
        for (String key : fields.keySet()) {
            if (!key.startsWith("email")) continue;
            try {
                int num = key.equals("email") ? 1 : Integer.parseInt(key.substring(emailLen), 10);
                if (num <= number) continue;
                number = num;
            }
            catch (NumberFormatException e) {}
        }
        LinkedList<String> keys = new LinkedList<String>();
        for (String key : fields.keySet()) {
            if (!key.startsWith("workEmail")) continue;
            keys.add(key);
        }
        for (String key : keys) {
            String nkey = "email" + (++number > 1 ? String.valueOf(number) : "");
            nfields.put(key, "");
            nfields.put(nkey, fields.get(key));
        }
        ParsedContact pcontact = new ParsedContact(contact);
        pcontact.modify(nfields, null);
        mbox.modifyContact(octxt, contact.getId(), pcontact);
    }
}

