/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.tcpserver;

import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.server.Server;
import com.zimbra.cs.server.ServerConfig;
import com.zimbra.cs.tcpserver.ProtocolHandler;
import com.zimbra.cs.tcpserver.TcpThreadFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;

public abstract class TcpServer
implements Runnable,
Server {
    private final Log mLog;
    private final PooledExecutor mPooledExecutor;
    private final String mName;
    private final ServerSocket mServerSocket;
    private final List<ProtocolHandler> mActiveHandlers;
    private boolean mShutdownRequested;
    private boolean mSSLEnabled;
    private ServerConfig mConfig;

    public TcpServer(String name, ServerConfig config) throws ServiceException {
        this(name, config.getNumThreads(), config.getServerSocket());
        this.mConfig = config;
    }

    public TcpServer(String name, int numThreads, ServerSocket serverSocket) {
        this(name, numThreads, 5, serverSocket);
    }

    public TcpServer(String name, int numThreads, int threadPriority, ServerSocket serverSocket) {
        this.mName = name;
        this.mServerSocket = serverSocket;
        this.mLog = LogFactory.getLog(TcpServer.class.getName() + "/" + serverSocket.getLocalPort());
        if (numThreads <= 0) {
            this.mLog.warn("number of handler threads " + numThreads + " invalid; will use 10 threads instead");
            numThreads = 10;
        }
        this.mPooledExecutor = new PooledExecutor(new BoundedLinkedQueue(), numThreads);
        this.mPooledExecutor.setMinimumPoolSize(numThreads);
        this.mPooledExecutor.setThreadFactory(new TcpThreadFactory(this.mName, false, threadPriority));
        this.mPooledExecutor.waitWhenBlocked();
        this.mActiveHandlers = new LinkedList<ProtocolHandler>();
    }

    public ServerConfig getConfig() {
        return this.mConfig;
    }

    public int getConfigMaxIdleMilliSeconds() {
        int secs;
        if (this.mConfig != null && (secs = this.mConfig.getMaxIdleSeconds()) >= 0) {
            return secs * 1000;
        }
        return -1;
    }

    public void setSSLEnabled(boolean ssl) {
        this.mSSLEnabled = ssl;
    }

    public boolean isSSLEnabled() {
        return this.mSSLEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveHandler(ProtocolHandler handler) {
        List<ProtocolHandler> list = this.mActiveHandlers;
        synchronized (list) {
            this.mActiveHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveHandler(ProtocolHandler handler) {
        List<ProtocolHandler> list = this.mActiveHandlers;
        synchronized (list) {
            this.mActiveHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int numActiveHandlers() {
        List<ProtocolHandler> list = this.mActiveHandlers;
        synchronized (list) {
            return this.mActiveHandlers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownActiveHandlers(boolean graceful) {
        List<ProtocolHandler> list = this.mActiveHandlers;
        synchronized (list) {
            for (ProtocolHandler handler : this.mActiveHandlers) {
                if (graceful) {
                    handler.gracefulShutdown("graceful shutdown requested");
                    continue;
                }
                handler.hardShutdown("hard shutdown requested");
            }
        }
    }

    public void start() {
        Thread t = new Thread(this);
        if (this.mName != null) {
            t.setName(this.mName);
        }
        t.start();
    }

    public void shutdown(int forceShutdownAfterSeconds) {
        this.mLog.info(this.mName + " initiating shutdown");
        this.mShutdownRequested = true;
        try {
            this.mServerSocket.close();
            Thread.yield();
        }
        catch (IOException ioe) {
            this.mLog.warn((Object)(this.mName + " error closing server socket"), ioe);
        }
        this.mPooledExecutor.shutdownAfterProcessingCurrentlyQueuedTasks();
        this.shutdownActiveHandlers(true);
        if (this.numActiveHandlers() == 0) {
            this.mLog.info(this.mName + " shutting down idle thread pool");
            this.mPooledExecutor.shutdownNow();
            return;
        }
        this.mLog.info(this.mName + " waiting " + forceShutdownAfterSeconds + " seconds for thread pool shutdown");
        try {
            this.mPooledExecutor.awaitTerminationAfterShutdown(forceShutdownAfterSeconds * 1000);
        }
        catch (InterruptedException ie) {
            this.mLog.warn((Object)(this.mName + " interrupted while waiting for graceful shutdown"), ie);
        }
        if (this.numActiveHandlers() == 0) {
            this.mLog.info(this.mName + " thread pool terminated");
            return;
        }
        this.shutdownActiveHandlers(false);
        this.mLog.info(this.mName + " shutdown complete");
    }

    public void run() {
        Thread.currentThread().setName(this.mName);
        this.mLog.info("starting accept loop");
        block4: while (true) {
            try {
                while (!this.mShutdownRequested) {
                    Socket connection = this.mServerSocket.accept();
                    ProtocolHandler handler = this.newProtocolHandler();
                    handler.setConnection(connection);
                    try {
                        this.mPooledExecutor.execute(handler);
                        continue block4;
                    }
                    catch (InterruptedException ie) {
                        this.mLog.warn((Object)"handler thread pool execution request interrupted", ie);
                    }
                }
                break;
            }
            catch (IOException ioe) {
                if (this.mShutdownRequested) break;
                this.mLog.fatal((Object)"accept loop failed", ioe);
                break;
            }
        }
        this.mLog.info("finished accept loop");
    }

    protected abstract ProtocolHandler newProtocolHandler();
}

