/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.tcpserver;

import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.tcpserver.TcpServer;
import com.zimbra.cs.util.Zimbra;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.AsynchronousCloseException;
import javax.net.ssl.SSLException;

public abstract class ProtocolHandler
implements Runnable {
    private static Log mLog = LogFactory.getLog(ProtocolHandler.class);
    protected Socket mConnection;
    private boolean mIdle;
    private final Object mIdleGuard = new Object();
    private boolean mShuttingDown;
    private final Object mShuttingDownGuard = new Object();
    private TcpServer mServer;
    private Thread mHandlerThread;

    protected abstract boolean setupConnection(Socket var1) throws IOException;

    protected abstract boolean authenticate() throws IOException;

    protected abstract boolean processCommand() throws Exception;

    protected abstract void dropConnection();

    protected abstract void notifyIdleConnection();

    public ProtocolHandler(TcpServer server) {
        this.mServer = server;
        this.mIdle = true;
        this.mShuttingDown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getIdle() {
        Object object = this.mIdleGuard;
        synchronized (object) {
            return this.mIdle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIdle(boolean idle) {
        Object object = this.mIdleGuard;
        synchronized (object) {
            this.mIdle = idle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getShuttingDown() {
        Object object = this.mShuttingDownGuard;
        synchronized (object) {
            return this.mShuttingDown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setShuttingDown(boolean b) {
        Object object = this.mShuttingDownGuard;
        synchronized (object) {
            this.mShuttingDown = b;
        }
    }

    void setConnection(Socket connection) {
        this.mConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block39: {
            Object v0;
            String remoteAddress;
            block37: {
                if (this.mConnection == null) {
                    throw new IllegalStateException("Connection can not be null when running ProtocolHandler");
                }
                remoteAddress = this.mConnection.getInetAddress().getHostAddress();
                this.mHandlerThread = Thread.currentThread();
                this.mServer.addActiveHandler(this);
                ZimbraLog.clearContext();
                if (this.setupConnection(this.mConnection)) {
                    if (this.authenticate()) {
                        this.processConnection();
                    } else {
                        mLog.info("Authentication failed for client " + remoteAddress);
                    }
                    break block37;
                }
                mLog.info("Connection refused for client " + remoteAddress);
            }
            Object var4_2 = null;
            this.dropConnection();
            ZimbraLog.addIpToContext(remoteAddress);
            try {
                try {
                    this.mConnection.close();
                    v0 = null;
                }
                catch (IOException ioe) {
                    if (mLog.isDebugEnabled()) {
                        mLog.info((Object)"I/O error while closing connection", ioe);
                    } else {
                        mLog.info("I/O error while closing connection: " + ioe);
                    }
                    v0 = null;
                }
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var7_20 = v0;
            ZimbraLog.clearContext();
            {
                break block39;
                catch (SocketTimeoutException e) {
                    Object v1;
                    ZimbraLog.addIpToContext(remoteAddress);
                    mLog.debug("Idle timeout: " + e);
                    this.notifyIdleConnection();
                    Object var4_3 = null;
                    this.dropConnection();
                    ZimbraLog.addIpToContext(remoteAddress);
                    try {
                        try {
                            this.mConnection.close();
                            v1 = null;
                        }
                        catch (IOException ioe) {
                            if (mLog.isDebugEnabled()) {
                                mLog.info((Object)"I/O error while closing connection", ioe);
                            } else {
                                mLog.info("I/O error while closing connection: " + ioe);
                            }
                            v1 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v1 = null;
                    }
                    Object var7_21 = v1;
                    ZimbraLog.clearContext();
                    break block39;
                }
                catch (OutOfMemoryError e) {
                    Object v2;
                    Zimbra.halt("out of memory", e);
                    Object var4_4 = null;
                    this.dropConnection();
                    ZimbraLog.addIpToContext(remoteAddress);
                    try {
                        try {
                            this.mConnection.close();
                            v2 = null;
                        }
                        catch (IOException ioe) {
                            if (mLog.isDebugEnabled()) {
                                mLog.info((Object)"I/O error while closing connection", ioe);
                            } else {
                                mLog.info("I/O error while closing connection: " + ioe);
                            }
                            v2 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v2 = null;
                    }
                    Object var7_22 = v2;
                    ZimbraLog.clearContext();
                    break block39;
                }
                catch (Error e) {
                    Object v3;
                    Zimbra.halt("Fatal error occurred while handling connection", e);
                    Object var4_5 = null;
                    this.dropConnection();
                    ZimbraLog.addIpToContext(remoteAddress);
                    try {
                        try {
                            this.mConnection.close();
                            v3 = null;
                        }
                        catch (IOException ioe) {
                            if (mLog.isDebugEnabled()) {
                                mLog.info((Object)"I/O error while closing connection", ioe);
                            } else {
                                mLog.info("I/O error while closing connection: " + ioe);
                            }
                            v3 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v3 = null;
                    }
                    Object var7_23 = v3;
                    ZimbraLog.clearContext();
                    break block39;
                }
                catch (Throwable e) {
                    Object v4;
                    ZimbraLog.addIpToContext(remoteAddress);
                    mLog.info((Object)"Exception occurred while handling connection", e);
                    Object var4_6 = null;
                    this.dropConnection();
                    ZimbraLog.addIpToContext(remoteAddress);
                    try {
                        try {
                            this.mConnection.close();
                            v4 = null;
                        }
                        catch (IOException ioe) {
                            if (mLog.isDebugEnabled()) {
                                mLog.info((Object)"I/O error while closing connection", ioe);
                            } else {
                                mLog.info("I/O error while closing connection: " + ioe);
                            }
                            v4 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v4 = null;
                    }
                    Object var7_24 = v4;
                    ZimbraLog.clearContext();
                }
            }
            catch (Throwable throwable) {
                Object v5;
                Object var4_7 = null;
                this.dropConnection();
                ZimbraLog.addIpToContext(remoteAddress);
                try {
                    try {
                        this.mConnection.close();
                        v5 = null;
                    }
                    catch (IOException ioe) {
                        if (mLog.isDebugEnabled()) {
                            mLog.info((Object)"I/O error while closing connection", ioe);
                        } else {
                            mLog.info("I/O error while closing connection: " + ioe);
                        }
                        v5 = null;
                    }
                }
                catch (Throwable throwable2) {
                    v5 = null;
                }
                Object var7_25 = v5;
                ZimbraLog.clearContext();
                throw throwable;
            }
        }
        ZimbraLog.clearContext();
        this.mServer.removeActiveHandler(this);
        this.mHandlerThread = null;
        mLog.info("Handler exiting normally");
    }

    private void processConnection() throws Exception {
        boolean cont = true;
        while (cont && !this.getShuttingDown()) {
            try {
                cont = this.processCommand();
                this.setIdle(true);
            }
            catch (IOException e) {
                ZimbraLog.addIpToContext(this.mConnection.getInetAddress().getHostAddress());
                if (ProtocolHandler.isSocketError(e)) {
                    cont = false;
                    if (this.getShuttingDown()) {
                        mLog.debug((Object)"Shutdown in progress", e);
                        continue;
                    }
                    if (mLog.isDebugEnabled()) {
                        mLog.info((Object)"I/O error while processing connection", e);
                        continue;
                    }
                    mLog.info("I/O error while processing connection: " + e);
                    continue;
                }
                throw e;
            }
        }
    }

    private static boolean isSocketError(IOException e) {
        return e instanceof SocketException || e instanceof SSLException || e instanceof AsynchronousCloseException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gracefulShutdown(String reason) {
        this.setShuttingDown(true);
        if (reason != null) {
            mLog.info(reason);
        }
        Object object = this.mIdleGuard;
        synchronized (object) {
            if (this.mIdle) {
                this.hardShutdown(null);
            }
        }
    }

    void hardShutdown(String reason) {
        this.setShuttingDown(true);
        if (reason != null) {
            mLog.info(reason);
        }
        if (!this.mConnection.isClosed()) {
            this.dropConnection();
            try {
                this.mConnection.close();
            }
            catch (IOException ioe) {
                mLog.info((Object)"Exception while closing connection", ioe);
            }
        }
        if (this.mHandlerThread != null) {
            this.mHandlerThread.interrupt();
        }
    }
}

