/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store.http;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.store.BlobBuilder;
import com.zimbra.cs.store.BlobInputStream;
import com.zimbra.cs.store.FileDescriptorCache;
import com.zimbra.cs.store.IncomingDirectory;
import com.zimbra.cs.store.LocalBlobCache;
import com.zimbra.cs.store.MailboxBlob;
import com.zimbra.cs.store.StagedBlob;
import com.zimbra.cs.store.StorageCallback;
import com.zimbra.cs.store.StoreManager;
import com.zimbra.cs.store.UncompressedFileCache;
import com.zimbra.cs.store.http.HttpMailboxBlob;
import com.zimbra.cs.store.http.HttpStagedBlob;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;

public abstract class HttpStoreManager
extends StoreManager {
    private final IncomingDirectory mIncoming = new IncomingDirectory(LC.zimbra_store_directory.value() + File.separator + "incoming");
    private final LocalBlobCache mLocalCache = new LocalBlobCache(LC.zimbra_tmp_directory.value() + File.separator + "blobs");

    protected abstract String getPostUrl(Mailbox var1);

    protected abstract String getGetUrl(Mailbox var1, String var2);

    protected abstract String getDeleteUrl(Mailbox var1, String var2);

    public void startup() throws IOException, ServiceException {
        ZimbraLog.store.info("starting up store " + this.getClass().getName());
        FileUtil.mkdirs(new File(this.mIncoming.getPath()));
        IncomingDirectory.setSweptDirectories(this.mIncoming);
        IncomingDirectory.startSweeper();
        String uncompressedPath = LC.zimbra_tmp_directory.value() + File.separator + "uncompressed";
        FileUtil.ensureDirExists(uncompressedPath);
        UncompressedFileCache<String> ufcache = new UncompressedFileCache(uncompressedPath).startup();
        BlobInputStream.setFileDescriptorCache(new FileDescriptorCache(ufcache).loadSettings());
        this.mLocalCache.startup();
    }

    public void shutdown() {
        IncomingDirectory.stopSweeper();
    }

    LocalBlobCache getBlobCache() {
        return this.mLocalCache;
    }

    public BlobBuilder getBlobBuilder() {
        return new HttpBlobBuilder(new HttpBlob(this.mIncoming.getNewIncomingFile()));
    }

    public InputStream getContent(Blob blob) throws IOException {
        return new BlobInputStream(blob);
    }

    public InputStream getContent(MailboxBlob mblob) throws IOException {
        if (mblob == null) {
            return null;
        }
        return this.getContent(mblob.getMailbox(), mblob.getLocator());
    }

    private InputStream getContent(Mailbox mbox, String locator) throws IOException {
        GetMethod get;
        if (mbox == null || locator == null) {
            return null;
        }
        Blob blob = this.mLocalCache.get(locator);
        if (blob != null) {
            return this.getContent(blob);
        }
        HttpClient client = ZimbraHttpConnectionManager.getInternalHttpConnMgr().newHttpClient();
        int statusCode = client.executeMethod(get = new GetMethod(this.getGetUrl(mbox, locator)));
        if (statusCode != 200) {
            throw new IOException("unexpected return code during blob GET: " + get.getStatusText());
        }
        return new UserServlet.HttpInputStream(get);
    }

    Blob getLocalBlob(Mailbox mbox, String locator, long sizeHint) throws IOException {
        Blob blob;
        Blob blob2 = this.mLocalCache.get(locator);
        if (blob2 != null) {
            return blob2;
        }
        InputStream is = this.getContent(mbox, locator);
        try {
            blob2 = this.storeIncoming(is, sizeHint, null);
            blob = this.mLocalCache.cache(locator, blob2);
            Object var9_8 = null;
        }
        catch (ServiceException e) {
            try {
                throw new IOException("fetching local blob: " + e);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                ByteUtil.closeStream(is);
                throw throwable;
            }
        }
        ByteUtil.closeStream(is);
        return blob;
    }

    public MailboxBlob getMailboxBlob(Mailbox mbox, int msgId, int revision, String locator) {
        return new HttpMailboxBlob(mbox, msgId, revision, locator);
    }

    public Blob storeIncoming(InputStream data, long sizeHint, StorageCallback callback, boolean storeAsIs) throws IOException, ServiceException {
        BlobBuilder builder = this.getBlobBuilder().setSizeHint(sizeHint).setStorageCallback(callback);
        builder.disableCompression(storeAsIs).disableDigest(storeAsIs);
        return builder.init().append(data).finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StagedBlob stage(InputStream in, long actualSize, StorageCallback callback, Mailbox mbox) throws IOException, ServiceException {
        StagedBlob stagedBlob;
        if (actualSize >= 0L && callback == null) {
            return this.stage(in, actualSize, mbox);
        }
        Blob blob = this.storeIncoming(in, actualSize, callback);
        try {
            stagedBlob = this.stage(blob, mbox);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.quietDelete(blob);
            throw throwable;
        }
        this.quietDelete(blob);
        return stagedBlob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StagedBlob stage(Blob blob, Mailbox mbox) throws IOException, ServiceException {
        StagedBlob stagedBlob;
        BlobInputStream is = new BlobInputStream(blob);
        try {
            stagedBlob = this.stage(is, blob.getRawSize(), mbox);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
        return stagedBlob;
    }

    protected abstract StagedBlob getStagedBlob(PostMethod var1, String var2, long var3, Mailbox var5) throws ServiceException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StagedBlob stage(InputStream in, long actualSize, Mailbox mbox) throws IOException, ServiceException {
        StagedBlob stagedBlob;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw ServiceException.FAILURE("SHA1 digest not found", e);
        }
        ByteUtil.PositionInputStream pin = new ByteUtil.PositionInputStream(new DigestInputStream(in, digest));
        HttpClient client = ZimbraHttpConnectionManager.getInternalHttpConnMgr().newHttpClient();
        PostMethod post = new PostMethod(this.getPostUrl(mbox));
        try {
            post.setRequestEntity(new InputStreamRequestEntity(pin, actualSize, "application/octet-stream"));
            int statusCode = client.executeMethod(post);
            if (statusCode != 200 && statusCode != 201 && statusCode != 204) {
                throw ServiceException.FAILURE("error POSTing blob: " + post.getStatusText(), null);
            }
            stagedBlob = this.getStagedBlob(post, ByteUtil.encodeFSSafeBase64(digest.digest()), pin.getPosition(), mbox);
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            post.releaseConnection();
            throw throwable;
        }
        post.releaseConnection();
        return stagedBlob;
    }

    public MailboxBlob copy(MailboxBlob src, Mailbox destMbox, int destMsgId, int destRevision) throws IOException, ServiceException {
        return this.link(src, destMbox, destMsgId, destRevision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailboxBlob link(MailboxBlob src, Mailbox destMbox, int destMsgId, int destRevision) throws IOException, ServiceException {
        MailboxBlob mailboxBlob;
        InputStream is = this.getContent(src);
        try {
            StagedBlob staged = this.stage(is, src.getSize(), destMbox);
            mailboxBlob = this.link(staged, destMbox, destMsgId, destRevision);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
        return mailboxBlob;
    }

    public MailboxBlob link(StagedBlob staged, Mailbox destMbox, int destMsgId, int destRevision) {
        return this.renameTo(staged, destMbox, destMsgId, destRevision);
    }

    public MailboxBlob renameTo(StagedBlob staged, Mailbox destMbox, int destMsgId, int destRevision) {
        HttpStagedBlob hsb = (HttpStagedBlob)staged;
        hsb.markInserted();
        HttpMailboxBlob mblob = new HttpMailboxBlob(destMbox, destMsgId, destRevision, hsb.getStagedLocator());
        return mblob.setSize(hsb.getStagedSize()).setDigest(hsb.getStagedDigest());
    }

    public boolean delete(MailboxBlob mblob) throws IOException {
        if (mblob == null) {
            return true;
        }
        return this.delete(mblob.getMailbox(), mblob.getLocator());
    }

    public boolean delete(StagedBlob staged) throws IOException {
        HttpStagedBlob hsb = (HttpStagedBlob)staged;
        if (hsb == null || hsb.isInserted()) {
            return true;
        }
        return this.delete(hsb.getMailbox(), hsb.getStagedLocator());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean delete(Mailbox mbox, String locator) throws IOException {
        boolean bl;
        DeleteMethod delete;
        block7: {
            boolean bl2;
            HttpClient client = ZimbraHttpConnectionManager.getInternalHttpConnMgr().newHttpClient();
            delete = new DeleteMethod(this.getDeleteUrl(mbox, locator));
            try {
                int statusCode = client.executeMethod(delete);
                switch (statusCode) {
                    case 200: {
                        bl2 = true;
                        Object var8_8 = null;
                        break;
                    }
                    case 404: {
                        bl = false;
                        break block7;
                    }
                    default: {
                        throw new IOException("unexpected return code during blob DELETE: " + delete.getStatusText());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                delete.releaseConnection();
                throw throwable;
            }
            delete.releaseConnection();
            return bl2;
        }
        Object var8_9 = null;
        delete.releaseConnection();
        return bl;
    }

    public boolean delete(Blob blob) {
        return blob.getFile().delete();
    }

    public boolean deleteStore(Mailbox mbox) {
        return false;
    }

    private static class HttpBlobBuilder
    extends BlobBuilder {
        HttpBlobBuilder(Blob targetBlob) {
            super(targetBlob);
        }
    }

    private static class HttpBlob
    extends Blob {
        HttpBlob(File incoming) {
            super(incoming);
        }
    }
}

