/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store.file;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.util.BuildInfo;
import com.zimbra.cs.util.SoapCLI;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VolumeUtil
extends SoapCLI {
    protected static final String O_A = "a";
    protected static final String O_D = "d";
    protected static final String O_L = "l";
    protected static final String O_E = "e";
    protected static final String O_DC = "dc";
    protected static final String O_SC = "sc";
    protected static final String O_TS = "ts";
    protected static final String O_ID = "id";
    protected static final String O_T = "t";
    protected static final String O_N = "n";
    protected static final String O_P = "p";
    protected static final String O_C = "c";
    protected static final String O_CT = "ct";
    private static final String PADDING = "                                                  ";

    protected VolumeUtil() throws ServiceException {
        this.setupCommandLineOptions();
    }

    public static void main(String[] args) {
        CliUtil.toolSetup();
        SoapTransport.setDefaultUserAgent("zmvolume", BuildInfo.VERSION);
        VolumeUtil util = null;
        try {
            util = new VolumeUtil();
        }
        catch (ServiceException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        try {
            CommandLine cl = util.getCommandLine(args);
            if (cl == null) {
                return;
            }
            ZAuthToken zat = VolumeUtil.getZAuthToken(cl);
            String id = cl.getOptionValue(O_ID);
            String type = cl.getOptionValue(O_T);
            String name = cl.getOptionValue(O_N);
            String path = cl.getOptionValue(O_P);
            String compress = cl.getOptionValue(O_C);
            String compressThreshold = cl.getOptionValue(O_CT);
            if (cl.hasOption(O_A)) {
                if (id != null) {
                    throw new ParseException("id cannot be specified when adding a volume");
                }
                util.addVolume(zat, name, type, path, null, null, null, null, compress, compressThreshold);
            } else if (cl.hasOption(O_D)) {
                if (id == null) {
                    throw new ParseException("volume id is missing");
                }
                util.deleteVolume(zat, id);
            } else if (cl.hasOption(O_L)) {
                util.listVolumes(zat, id, true);
            } else if (cl.hasOption(O_E)) {
                if (id == null) {
                    throw new ParseException("volume id is missing");
                }
                util.editVolume(zat, id, name, type, path, null, null, null, null, compress, compressThreshold);
            } else if (cl.hasOption(O_DC)) {
                util.displayCurrentVolumes(zat);
            } else if (cl.hasOption(O_SC)) {
                if (id == null) {
                    throw new ParseException("volume id is missing");
                }
                short shortId = Short.parseShort(id);
                if (shortId < 0) {
                    throw new ParseException("id cannot be less than 0");
                }
                util.setCurrentVolume(zat, shortId);
            } else if (cl.hasOption(O_TS)) {
                util.unsetCurrentSecondaryMessageVolume(zat);
            } else {
                throw new ParseException("No action (-a,-d,-l,-e,-dc,-sc,-ts) is specified");
            }
            System.exit(0);
        }
        catch (ParseException e) {
            util.usage(e);
        }
        catch (Exception e) {
            System.err.println("Error occurred: " + e.getMessage());
        }
        System.exit(1);
    }

    private void setCurrentVolume(ZAuthToken zat, short id) throws SoapFaultException, IOException, ServiceException {
        Integer idInt = new Integer(id);
        Map<Integer, Map<String, Object>> vols = this.getVolumes(zat, idInt.toString(), true);
        Map<String, Object> vol = vols.get(idInt);
        if (vol == null) {
            System.err.println("Volume " + id + " does not exist");
            System.exit(1);
        }
        short type = (short)((Integer)vol.get("type")).intValue();
        Element.XMLElement req = new Element.XMLElement(AdminConstants.SET_CURRENT_VOLUME_REQUEST);
        req.addAttribute("type", type);
        req.addAttribute(O_ID, id);
        this.auth(zat);
        this.getTransport().invokeWithoutSession(req);
        System.out.println("Volume " + id + " is now the current " + VolumeUtil.getTypeName(type) + " volume.");
    }

    private void unsetCurrentSecondaryMessageVolume(ZAuthToken zat) throws SoapFaultException, IOException, ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.SET_CURRENT_VOLUME_REQUEST);
        req.addAttribute("type", 2L);
        req.addAttribute(O_ID, -2L);
        this.auth(zat);
        this.getTransport().invokeWithoutSession(req);
        System.out.println("Turned off the current secondary message volume.");
    }

    private void displayCurrentVolumes(ZAuthToken zat) throws SoapFaultException, IOException, ServiceException {
        Map<Integer, Map<String, Object>> vols = this.getVolumes(zat, null, true);
        Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_CURRENT_VOLUMES_REQUEST);
        Element resp = this.getTransport().invokeWithoutSession(req);
        Iterator<Element> it = resp.elementIterator("volume");
        while (it.hasNext()) {
            Element volElem = it.next();
            Integer key = new Integer(volElem.getAttribute(O_ID));
            Map<String, Object> vol = vols.get(key);
            this.listVolume(vol);
        }
    }

    private Map<Integer, Map<String, Object>> getVolumes(ZAuthToken zat, String id, boolean auth) throws SoapFaultException, IOException, ServiceException {
        TreeMap<Integer, Map<String, Object>> vols = new TreeMap<Integer, Map<String, Object>>();
        if (auth) {
            this.auth(zat);
        }
        Element.XMLElement req = null;
        if (id == null) {
            req = new Element.XMLElement(AdminConstants.GET_ALL_VOLUMES_REQUEST);
        } else {
            req = new Element.XMLElement(AdminConstants.GET_VOLUME_REQUEST);
            req.addAttribute(O_ID, id);
        }
        Element resp = this.getTransport().invokeWithoutSession(req);
        Iterator<Element> it = resp.elementIterator("volume");
        while (it.hasNext()) {
            Element volElem = it.next();
            String vid = volElem.getAttribute(O_ID);
            String name = volElem.getAttribute("name");
            short type = (short)volElem.getAttributeLong("type");
            String path = volElem.getAttribute("rootpath");
            boolean compressed = volElem.getAttributeBool("compressBlobs");
            boolean isCurrent = volElem.getAttributeBool("isCurrent");
            String threshold = volElem.getAttribute("compressionThreshold");
            HashMap<String, Object> vol = new HashMap<String, Object>();
            Integer key = new Integer(vid);
            vol.put(O_ID, key);
            vol.put("name", name);
            vol.put("type", new Integer(type));
            vol.put("rootpath", path);
            vol.put("compressBlobs", compressed);
            vol.put("compressionThreshold", new Integer(threshold));
            vol.put("isCurrent", isCurrent);
            vols.put(key, vol);
        }
        return vols;
    }

    private void listVolume(Map<String, Object> vol) {
        short vid = (short)((Integer)vol.get(O_ID)).intValue();
        short type = (short)((Integer)vol.get("type")).intValue();
        boolean compressed = (Boolean)vol.get("compressBlobs");
        int threshold = (Integer)vol.get("compressionThreshold");
        System.out.println("   Volume id: " + vid);
        System.out.println("        name: " + vol.get("name"));
        System.out.println("        type: " + VolumeUtil.getTypeName(type));
        System.out.println("        path: " + vol.get("rootpath"));
        System.out.print("  compressed: " + compressed);
        if (compressed) {
            System.out.println("\t         threshold: " + threshold + " bytes");
        } else {
            System.out.println();
        }
        System.out.println("     current: " + vol.get("isCurrent"));
        System.out.println();
    }

    private void listVolumes(ZAuthToken zat, String id, boolean auth) throws SoapFaultException, IOException, ServiceException {
        Map<Integer, Map<String, Object>> vols = this.getVolumes(zat, id, auth);
        for (Integer key : vols.keySet()) {
            Map<String, Object> vol = vols.get(key);
            this.listVolume(vol);
        }
    }

    private void deleteVolume(ZAuthToken zat, String id) throws SoapFaultException, IOException, ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.DELETE_VOLUME_REQUEST);
        req.addAttribute(O_ID, id);
        this.auth(zat);
        this.getTransport().invokeWithoutSession(req);
        System.out.println("Deleted volume " + id);
    }

    private void editVolume(ZAuthToken zat, String id, String name, String type, String path, String fileBits, String fileGroupBits, String mailboxBits, String mailboxGroupBits, String compress, String compressThreshold) throws ParseException, SoapFaultException, IOException, ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.MODIFY_VOLUME_REQUEST);
        req.addAttribute(O_ID, id);
        Element vol = ((Element)req).addElement("volume");
        this.addAttributes(vol, name, type, path, fileBits, fileGroupBits, mailboxBits, mailboxGroupBits, compress, compressThreshold);
        this.auth(zat);
        this.getTransport().invokeWithoutSession(req);
        System.out.println("Edited volume " + id);
    }

    private void addVolume(ZAuthToken zat, String name, String type, String path, String fileBits, String fileGroupBits, String mailboxBits, String mailboxGroupBits, String compress, String compressThreshold) throws ParseException, SoapFaultException, IOException, ServiceException {
        if (name == null || type == null || path == null) {
            throw new ParseException("at least one of the required parameters (name, type, path) is missing");
        }
        Element.XMLElement req = new Element.XMLElement(AdminConstants.CREATE_VOLUME_REQUEST);
        Element vol = ((Element)req).addElement("volume");
        if (compress == null) {
            compress = "false";
        }
        if (compressThreshold == null) {
            compressThreshold = "4096";
        }
        this.addAttributes(vol, name, type, path, fileBits, fileGroupBits, mailboxBits, mailboxGroupBits, compress, compressThreshold);
        this.auth(zat);
        Element resp = this.getTransport().invokeWithoutSession(req);
        vol = resp.getElement("volume");
        String id = vol.getAttribute(O_ID);
        System.out.println("Volume " + id + " is created");
    }

    private void addAttributes(Element vol, String name, String type, String path, String fileBits, String fileGroupBits, String mailboxBits, String mailboxGroupBits, String compress, String compressThreshold) throws ParseException {
        if (compress != null && !"true".equals(compress) && !"false".equals(compress)) {
            throw new ParseException("expecting true or false for compress option");
        }
        if (type != null) {
            short t = VolumeUtil.getTypeId(type);
            if (t < 0) {
                throw new ParseException("invalid volume type: " + type);
            }
            vol.addAttribute("type", t);
        }
        if (name != null) {
            vol.addAttribute("name", name);
        }
        if (path != null) {
            vol.addAttribute("rootpath", path);
        }
        if (compress != null) {
            vol.addAttribute("compressBlobs", "true".equals(compress));
        }
        if (compressThreshold != null) {
            vol.addAttribute("compressionThreshold", compressThreshold);
        }
    }

    @Override
    protected String getCommandUsage() {
        return "zmvolume {-a | -d | -l | -e | -dc | -sc } <options>";
    }

    @Override
    protected void setupCommandLineOptions() {
        super.setupCommandLineOptions();
        Options options = this.getOptions();
        OptionGroup og = new OptionGroup();
        og.addOption(new Option(O_A, "add", false, "Adds a volume."));
        og.addOption(new Option(O_D, "delete", false, "Deletes a volume."));
        og.addOption(new Option(O_L, "list", false, "Lists volumes."));
        og.addOption(new Option(O_E, "edit", false, "Edits a volume."));
        og.addOption(new Option(O_DC, "displayCurrent", false, "Displays the current volumes."));
        og.addOption(new Option(O_SC, "setCurrent", false, "Sets the current volume."));
        og.addOption(new Option(O_TS, "turnOffSecondary", false, "Turns off the current secondary message volume"));
        og.setRequired(true);
        options.addOptionGroup(og);
        options.addOption(O_ID, O_ID, true, "Volume ID");
        options.addOption(O_T, "type", true, "Volume type (primaryMessage, secondaryMessage, or index)");
        options.addOption(O_N, "name", true, "volume name");
        options.addOption(O_P, "path", true, "Root path");
        options.addOption(O_C, "compress", true, "Compress blobs; \"true\" or \"false\"");
        options.addOption(O_CT, "compressionThreshold", true, "Compression threshold; default 4KB");
        options.addOption(SoapCLI.OPT_AUTHTOKEN);
        options.addOption(SoapCLI.OPT_AUTHTOKENFILE);
    }

    @Override
    protected void usage(ParseException e) {
        if (e != null) {
            System.err.println("Error parsing command line arguments: " + e.getMessage());
        }
        System.err.println(this.getCommandUsage());
        this.printOpt(O_A, 0);
        this.printOpt(O_N, 2);
        this.printOpt(O_T, 2);
        this.printOpt(O_P, 2);
        this.printOpt(O_C, 2);
        this.printOpt(O_CT, 2);
        this.printOpt(O_E, 0);
        this.printOpt(O_ID, 2);
        System.err.println("  any of the options listed under -a can also be specified ");
        System.err.println("  to have its value modified.");
        this.printOpt(O_D, 0);
        this.printOpt(O_ID, 2);
        this.printOpt(O_L, 0);
        this.printOpt(O_ID, 2);
        System.err.println("  -id is optional.");
        this.printOpt(O_DC, 0);
        this.printOpt(O_SC, 0);
        this.printOpt(O_ID, 2);
        this.printOpt(O_TS, 0);
        this.printOpt("y", 0);
        this.printOpt("Y", 0);
    }

    private void printOpt(String optStr, int leftPad) {
        Options options = this.getOptions();
        Option opt = options.getOption(optStr);
        StringBuffer buf = new StringBuffer();
        buf.append(PADDING.substring(0, leftPad));
        buf.append("-" + opt.getOpt() + ",--" + opt.getLongOpt() + (opt.hasArg() ? " <arg>" : ""));
        buf.append(PADDING.substring(0, 35 - buf.length()));
        buf.append(opt.getDescription());
        System.err.println(buf.toString());
    }

    public static short getTypeId(String name) {
        if (name.equalsIgnoreCase("primaryMessage")) {
            return 1;
        }
        if (name.equalsIgnoreCase("secondaryMessage")) {
            return 2;
        }
        if (name.equalsIgnoreCase("index")) {
            return 10;
        }
        return -1;
    }

    public static String getTypeName(short type) {
        switch (type) {
            case 1: {
                return "primaryMessage";
            }
            case 2: {
                return "secondaryMessage";
            }
            case 10: {
                return "index";
            }
        }
        return "Unrecognized type " + type;
    }
}

