/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store.file;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.store.file.Volume;
import com.zimbra.cs.store.file.VolumeUtil;

public class VolumeServiceException
extends ServiceException {
    public static final String BAD_CURRVOL_CONFIG = "volume.BAD_CURRVOL_CONFIG";
    public static final String NO_SUCH_VOLUME = "volume.NO_SUCH_VOLUME";
    public static final String NO_SUCH_PATH = "volume.NO_SUCH_PATH";
    public static final String ALREADY_EXISTS = "volume.ALREADY_EXISTS";
    public static final String ID_OUT_OF_RANGE = "volume.ID_OUT_OF_RANGE";
    public static final String CANNOT_DELETE_VOLUME_IN_USE = "volume.CANNOT_DELETE_VOLUME_IN_USE";
    public static final String WRONG_TYPE_CURRVOL = "volume.WRONG_TYPE_CURRVOL";
    public static final String CANNOT_DELETE_CURRVOL = "volume.CANNOT_DELETE_CURRVOL";
    public static final String CANNOT_CHANGE_TYPE_OF_CURRVOL = "volume.CANNOT_CHANGE_TYPE_OF_CURRVOL";
    public static final String INVALID_REQUEST = "volume.INVALID_REQUEST";
    public static final String NOT_ABSOLUTE_PATH = "volume.NOT_ABSOLUTE_PATH";
    public static final String SUBDIR_OF_ANOTHER_VOLUME = "volume.SUBDIR_OF_ANOTHER_VOLUME";

    private VolumeServiceException(String message, String code, boolean isReceiversFault) {
        super(message, code, isReceiversFault, new ServiceException.Argument[0]);
    }

    VolumeServiceException(String message, String code, boolean isReceiversFault, Throwable cause) {
        super(message, code, isReceiversFault, cause, new ServiceException.Argument[0]);
    }

    public static VolumeServiceException BAD_CURRVOL_CONFIG(String msg) {
        return new VolumeServiceException("invalid current volumes config: " + msg, BAD_CURRVOL_CONFIG, true, null);
    }

    public static VolumeServiceException NO_SUCH_VOLUME(int id) {
        return new VolumeServiceException("no such volume: " + id, NO_SUCH_VOLUME, false, null);
    }

    public static VolumeServiceException NO_SUCH_PATH(String path) {
        return new VolumeServiceException("directory does not exist or is not writable: " + path, NO_SUCH_PATH, false, null);
    }

    public static VolumeServiceException ALREADY_EXISTS(int id, String name, String path, Throwable t) {
        return new VolumeServiceException("volume with the same id, name, or path already exists: (id=" + id + ", name=\"" + name + "\", path=" + path + ")", ALREADY_EXISTS, false, t);
    }

    public static VolumeServiceException ID_OUT_OF_RANGE(int id) {
        return new VolumeServiceException("id " + id + " is out of range [0, " + 255 + "]", ID_OUT_OF_RANGE, false, null);
    }

    public static VolumeServiceException CANNOT_DELETE_VOLUME_IN_USE(int id, Throwable t) {
        return new VolumeServiceException("volume id " + id + " is in use by one or more mailboxes and cannot be deleted", CANNOT_DELETE_VOLUME_IN_USE, false, t);
    }

    public static VolumeServiceException CANNOT_DELETE_CURRVOL(int id, String volType) {
        return new VolumeServiceException("volume " + id + " cannot be deleted because it is a current volume: " + volType, CANNOT_DELETE_CURRVOL, false, null);
    }

    public static VolumeServiceException WRONG_TYPE_CURRVOL(int id, short currVolType) {
        return new VolumeServiceException("volume " + id + " cannot be used as current volume of type " + currVolType + " (" + VolumeUtil.getTypeName(currVolType) + ")", WRONG_TYPE_CURRVOL, false, null);
    }

    public static VolumeServiceException CANNOT_CHANGE_TYPE_OF_CURRVOL(Volume vol, short newType) {
        String newVolTypeName = VolumeUtil.getTypeName(newType);
        String currVolTypeName = VolumeUtil.getTypeName(vol.getType());
        return new VolumeServiceException("cannot change type of volume \"" + vol.getName() + "\" (id=" + vol.getId() + ") to " + newVolTypeName + " because it is the current " + currVolTypeName + " volume", CANNOT_CHANGE_TYPE_OF_CURRVOL, false, null);
    }

    public static VolumeServiceException INVALID_REQUEST(String msg) {
        return new VolumeServiceException("invalid request: " + msg, INVALID_REQUEST, false, null);
    }

    public static VolumeServiceException NOT_ABSOLUTE_PATH(String path) {
        return new VolumeServiceException("\"" + path + "\" is not an absolute path", NOT_ABSOLUTE_PATH, false, null);
    }

    public static VolumeServiceException SUBDIR_OF_ANOTHER_VOLUME(String path, Volume anotherVol) {
        return new VolumeServiceException("the path \"" + path + "\" is a subdirectory of another volume (id=" + anotherVol.getId() + ", path=" + anotherVol.getRootPath() + ")", SUBDIR_OF_ANOTHER_VOLUME, false, null);
    }
}

