/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store.file;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.store.BlobBuilder;
import com.zimbra.cs.store.file.Volume;
import com.zimbra.cs.store.file.VolumeBlob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

public class VolumeBlobBuilder
extends BlobBuilder {
    VolumeBlobBuilder(Blob targetBlob) {
        super(targetBlob);
    }

    private short getVolumeId() {
        return ((VolumeBlob)this.blob).getVolumeId();
    }

    protected boolean useCompression(long size) throws ServiceException {
        if (this.disableCompression) {
            return false;
        }
        Volume volume = Volume.getById(this.getVolumeId());
        return volume.getCompressBlobs() && (size <= 0L || size > volume.getCompressionThreshold());
    }

    public Blob finish() throws IOException, ServiceException {
        if (this.isFinished()) {
            return this.blob;
        }
        super.finish();
        Volume volume = Volume.getById(this.getVolumeId());
        if (this.blob.isCompressed() && this.getTotalBytes() < volume.getCompressionThreshold()) {
            try {
                VolumeBlobBuilder.uncompressBlob(this.blob);
            }
            catch (IOException e) {
                this.dispose();
                throw e;
            }
        }
        return this.blob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void uncompressBlob(Blob blob) throws IOException {
        File file = blob.getFile();
        File tmp = File.createTempFile(file.getName(), ".unzip.tmp", file.getParentFile());
        GZIPInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new GZIPInputStream(new FileInputStream(file));
            os = new FileOutputStream(tmp);
            ByteUtil.copy(is, false, os, false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ByteUtil.closeStream(is);
            ByteUtil.closeStream(os);
            throw throwable;
        }
        ByteUtil.closeStream(is);
        ByteUtil.closeStream(os);
        if (!file.delete()) {
            throw new IOException("Unable to delete file: " + file.getAbsolutePath());
        }
        if (!tmp.renameTo(file)) {
            throw new IOException(String.format("Unable to rename '%s' to '%s'", tmp.getAbsolutePath(), file.getAbsolutePath()));
        }
        blob.setCompressed(false);
    }

    public String toString() {
        return super.toString() + ", volume=" + this.getVolumeId();
    }
}

