/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store.file;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.DbVolume;
import com.zimbra.cs.redolog.op.CreateVolume;
import com.zimbra.cs.redolog.op.DeleteVolume;
import com.zimbra.cs.redolog.op.ModifyVolume;
import com.zimbra.cs.redolog.op.RedoableOp;
import com.zimbra.cs.redolog.op.SetCurrentVolume;
import com.zimbra.cs.store.IncomingDirectory;
import com.zimbra.cs.store.file.VolumeServiceException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Volume {
    public static final short ID_AUTO_INCREMENT = -1;
    public static final short ID_NONE = -2;
    public static final short ID_MAX = 255;
    public static final short TYPE_MESSAGE = 1;
    public static final short TYPE_MESSAGE_SECONDARY = 2;
    public static final short TYPE_INDEX = 10;
    private static final String SUBDIR_MESSAGE = "msg";
    private static final String SUBDIR_INDEX = "index";
    private static final String INCOMING_DIR = "incoming";
    private static final short DEFAULT_MBOX_GROUP_BITS = 8;
    private static final short DEFAULT_MBOX_BITS = 12;
    private static final short DEFAULT_FILE_GROUP_BITS = 8;
    private static final short DEFAULT_FILE_BITS = 12;
    private static final Object sVolumeGuard = new Object();
    private static Map<Short, Volume> sVolumeMap = new HashMap<Short, Volume>();
    private static Volume sCurrMsgVolume;
    private static Volume sCurrSecondaryMsgVolume;
    private static Volume sCurrIndexVolume;
    private short mId;
    private short mType;
    private String mName;
    private String mRootPath;
    private String mIncomingMsgDir;
    private IncomingDirectory mIncoming;
    private short mMboxGroupBits;
    private short mMboxBits;
    private short mFileGroupBits;
    private short mFileBits;
    private int mMboxGroupBitMask;
    private int mFileGroupBitMask;
    private boolean mCompressBlobs;
    private long mCompressionThreshold;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void reloadVolumes() throws ServiceException {
        Object object = DbMailbox.getSynchronizer();
        synchronized (object) {
            DbPool.Connection conn = null;
            try {
                conn = DbPool.getConnection();
                Map<Short, Volume> volumes = DbVolume.getAll(conn);
                DbVolume.CurrentVolumes currVols = DbVolume.getCurrentVolumes(conn);
                if (currVols == null) {
                    throw VolumeServiceException.BAD_CURRVOL_CONFIG("Missing current volumes info from configuration");
                }
                Volume currMsgVol = volumes.get(new Short(currVols.msgVolId));
                if (currMsgVol == null) {
                    throw VolumeServiceException.BAD_CURRVOL_CONFIG("Unknown current message volume " + currVols.msgVolId);
                }
                Volume currSecondaryMsgVol = null;
                if (currVols.secondaryMsgVolId != -2 && (currSecondaryMsgVol = volumes.get(new Short(currVols.secondaryMsgVolId))) == null) {
                    throw VolumeServiceException.BAD_CURRVOL_CONFIG("Unknown current secondary message volume " + currVols.secondaryMsgVolId);
                }
                Volume currIndexVol = volumes.get(new Short(currVols.indexVolId));
                if (currIndexVol == null) {
                    throw VolumeServiceException.BAD_CURRVOL_CONFIG("Unknown current index volume " + currVols.indexVolId);
                }
                Object object2 = sVolumeGuard;
                synchronized (object2) {
                    sVolumeMap.clear();
                    sVolumeMap.putAll(volumes);
                    sCurrMsgVolume = currMsgVol;
                    sCurrSecondaryMsgVolume = currSecondaryMsgVol;
                    sCurrIndexVolume = currIndexVol;
                    Volume.updateSweptDirectories();
                }
                Object var10_9 = null;
                if (conn == null) return;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (conn == null) throw throwable;
                DbPool.quietClose(conn);
                throw throwable;
            }
            DbPool.quietClose(conn);
            {
            }
            return;
        }
    }

    private static void updateSweptDirectories() {
        Collection<Volume> volumes = sVolumeMap.values();
        ArrayList<IncomingDirectory> incdirs = new ArrayList<IncomingDirectory>(volumes.size());
        for (Volume vol : volumes) {
            IncomingDirectory inc = vol.getIncomingDirectory();
            if (inc == null) continue;
            incdirs.add(inc);
        }
        IncomingDirectory.setSweptDirectories(incdirs);
    }

    public static void validateID(long id) throws VolumeServiceException {
        Volume.validateID(id, false);
    }

    public static void validateID(long id, boolean allowReservedVals) throws VolumeServiceException {
        if (allowReservedVals && (id == -1L || id == -2L)) {
            return;
        }
        if (id < 1L || id > 255L) {
            throw VolumeServiceException.INVALID_REQUEST("Volume ID " + id + " is outside the range of [1, " + 255 + "]");
        }
    }

    private static void validateType(short type) throws VolumeServiceException {
        if (type != 1 && type != 2 && type != 10) {
            throw VolumeServiceException.INVALID_REQUEST("Invalid volume type " + type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validatePath(String path) throws VolumeServiceException {
        if (path == null || path.length() < 1) {
            throw VolumeServiceException.INVALID_REQUEST("Missing volume path");
        }
        path = Volume.getAbsolutePath(path);
        String pathSlashed = path.replaceAll("\\\\", "/");
        Object object = sVolumeGuard;
        synchronized (object) {
            for (Volume v : Volume.getAll()) {
                String vpath = v.getRootPath().replaceAll("\\\\", "/");
                int vpathLen = vpath.length();
                if (vpathLen > 0 && vpath.charAt(vpathLen - 1) != '/') {
                    vpath = vpath + "/";
                }
                if (pathSlashed.indexOf(vpath) != 0) continue;
                throw VolumeServiceException.SUBDIR_OF_ANOTHER_VOLUME(path, v);
            }
        }
        File root = new File(path);
        if (!(root.exists() && root.isDirectory() && root.canWrite())) {
            throw VolumeServiceException.NO_SUCH_PATH(path);
        }
    }

    private static void validateArgs(short id, short type, String name, String path, short mboxGroupBits, short mboxBits, short fileGroupBits, short fileBits, long compressionThreshold) throws VolumeServiceException {
        Volume.validateID(id, true);
        Volume.validateType(type);
        if (name == null || name.length() < 1) {
            throw VolumeServiceException.INVALID_REQUEST("Missing volume name");
        }
        Volume.validatePath(path);
        if (compressionThreshold < 0L) {
            throw VolumeServiceException.INVALID_REQUEST("compressionThreshold cannot be a negative number");
        }
    }

    public static Volume create(short id, short type, String name, String path, short mboxGroupBits, short mboxBits, short fileGroupBits, short fileBits, boolean compressBlobs, long compressionThreshold) throws ServiceException {
        return Volume.create(id, type, name, path, mboxGroupBits, mboxBits, fileGroupBits, fileBits, compressBlobs, compressionThreshold, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Volume create(short id, short type, String name, String path, short mboxGroupBits, short mboxBits, short fileGroupBits, short fileBits, boolean compressBlobs, long compressionThreshold, boolean noRedo) throws ServiceException {
        path = Volume.normalizePath(path);
        Volume.validateArgs(id, type, name, path, mboxGroupBits, mboxBits, fileGroupBits, fileBits, compressionThreshold);
        mboxGroupBits = (short)8;
        mboxBits = (short)12;
        fileGroupBits = (short)8;
        fileBits = (short)12;
        CreateVolume redoRecorder = null;
        if (!noRedo) {
            redoRecorder = new CreateVolume(type, name, path, mboxGroupBits, mboxBits, fileGroupBits, fileBits, compressBlobs, compressionThreshold);
            redoRecorder.start(System.currentTimeMillis());
        }
        Short key = null;
        Volume vol = null;
        Object object = DbMailbox.getSynchronizer();
        synchronized (object) {
            Volume volume;
            boolean success = false;
            DbPool.Connection conn = null;
            try {
                conn = DbPool.getConnection();
                vol = DbVolume.create(conn, id, type, name, path, mboxGroupBits, mboxBits, fileGroupBits, fileBits, compressBlobs, compressionThreshold);
                success = true;
                if (!noRedo) {
                    redoRecorder.setId(vol.getId());
                    redoRecorder.log();
                }
                key = new Short(vol.getId());
                volume = vol;
                Object var20_18 = null;
            }
            catch (Throwable throwable) {
                Object var20_19 = null;
                Volume.endTransaction(success, conn, redoRecorder);
                if (!success) throw throwable;
                Object object2 = sVolumeGuard;
                synchronized (object2) {
                    sVolumeMap.put(key, vol);
                    Volume.updateSweptDirectories();
                    throw throwable;
                }
            }
            Volume.endTransaction(success, conn, redoRecorder);
            if (!success) return volume;
            Object object3 = sVolumeGuard;
            synchronized (object3) {
                sVolumeMap.put(key, vol);
                Volume.updateSweptDirectories();
                return volume;
            }
        }
    }

    public static Volume update(short id, short type, String name, String path, short mboxGroupBits, short mboxBits, short fileGroupBits, short fileBits, boolean compressBlobs, long compressionThreshold) throws ServiceException {
        return Volume.update(id, type, name, path, mboxGroupBits, mboxBits, fileGroupBits, fileBits, compressBlobs, compressionThreshold, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Volume update(short id, short type, String name, String path, short mboxGroupBits, short mboxBits, short fileGroupBits, short fileBits, boolean compressBlobs, long compressionThreshold, boolean noRedo) throws ServiceException {
        path = Volume.normalizePath(path);
        Volume.validateArgs(id, type, name, path, mboxGroupBits, mboxBits, fileGroupBits, fileBits, compressionThreshold);
        mboxGroupBits = (short)8;
        mboxBits = (short)12;
        fileGroupBits = (short)8;
        fileBits = (short)12;
        Volume vol = Volume.getById(id);
        if (type != vol.getType()) {
            Object object = sVolumeGuard;
            synchronized (object) {
                if (sCurrMsgVolume != null) {
                    if (id == sCurrMsgVolume.getId()) throw VolumeServiceException.CANNOT_CHANGE_TYPE_OF_CURRVOL(vol, type);
                }
                if (sCurrSecondaryMsgVolume != null) {
                    if (id == sCurrSecondaryMsgVolume.getId()) throw VolumeServiceException.CANNOT_CHANGE_TYPE_OF_CURRVOL(vol, type);
                }
                if (sCurrIndexVolume != null && id == sCurrIndexVolume.getId()) {
                    throw VolumeServiceException.CANNOT_CHANGE_TYPE_OF_CURRVOL(vol, type);
                }
            }
        }
        ModifyVolume redoRecorder = null;
        if (!noRedo) {
            redoRecorder = new ModifyVolume(id, type, name, path, mboxGroupBits, mboxBits, fileGroupBits, fileBits, compressBlobs, compressionThreshold);
            redoRecorder.start(System.currentTimeMillis());
        }
        Object object = DbMailbox.getSynchronizer();
        synchronized (object) {
            Volume volume;
            boolean success = false;
            DbPool.Connection conn = null;
            try {
                conn = DbPool.getConnection();
                vol = DbVolume.update(conn, id, type, name, path, mboxGroupBits, mboxBits, fileGroupBits, fileBits, compressBlobs, compressionThreshold);
                success = true;
                if (!noRedo) {
                    redoRecorder.log();
                }
                volume = vol;
                Object var19_17 = null;
            }
            catch (Throwable throwable) {
                Object var19_18 = null;
                Volume.endTransaction(success, conn, redoRecorder);
                if (!success) throw throwable;
                Short key = new Short(id);
                Object object2 = sVolumeGuard;
                synchronized (object2) {
                    sVolumeMap.put(key, vol);
                    Volume.updateSweptDirectories();
                    throw throwable;
                }
            }
            Volume.endTransaction(success, conn, redoRecorder);
            if (!success) return volume;
            Short key = new Short(id);
            Object object3 = sVolumeGuard;
            synchronized (object3) {
                sVolumeMap.put(key, vol);
                Volume.updateSweptDirectories();
                return volume;
            }
        }
    }

    public static boolean delete(short id) throws ServiceException {
        return Volume.delete(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean delete(short id, boolean noRedo) throws ServiceException {
        Volume.validateID(id);
        DeleteVolume redoRecorder = null;
        if (!noRedo) {
            redoRecorder = new DeleteVolume(id);
            redoRecorder.start(System.currentTimeMillis());
        }
        Volume vol = null;
        Short key = new Short(id);
        Object object = sVolumeGuard;
        synchronized (object) {
            if (id == sCurrMsgVolume.getId()) {
                throw VolumeServiceException.CANNOT_DELETE_CURRVOL(id, "message");
            }
            if (sCurrSecondaryMsgVolume != null && id == sCurrSecondaryMsgVolume.getId()) {
                throw VolumeServiceException.CANNOT_DELETE_CURRVOL(id, "secondary message");
            }
            if (id == sCurrIndexVolume.getId()) {
                throw VolumeServiceException.CANNOT_DELETE_CURRVOL(id, SUBDIR_INDEX);
            }
            vol = sVolumeMap.remove(key);
            Volume.updateSweptDirectories();
        }
        object = DbMailbox.getSynchronizer();
        synchronized (object) {
            boolean bl;
            boolean success = false;
            DbPool.Connection conn = null;
            try {
                conn = DbPool.getConnection();
                boolean deleted = DbVolume.delete(conn, id);
                success = true;
                if (!noRedo) {
                    redoRecorder.log();
                }
                bl = deleted;
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                Volume.endTransaction(success, conn, redoRecorder);
                if (vol == null) throw throwable;
                if (success) throw throwable;
                Object object2 = sVolumeGuard;
                synchronized (object2) {
                    sVolumeMap.put(key, vol);
                    Volume.updateSweptDirectories();
                    throw throwable;
                }
            }
            Volume.endTransaction(success, conn, redoRecorder);
            if (vol == null) return bl;
            if (success) return bl;
            Object object3 = sVolumeGuard;
            synchronized (object3) {
                sVolumeMap.put(key, vol);
                Volume.updateSweptDirectories();
                return bl;
            }
        }
    }

    public static Volume getById(String vid) throws ServiceException {
        try {
            return Volume.getById(Short.parseShort(vid));
        }
        catch (NumberFormatException nfe) {
            throw ServiceException.INVALID_REQUEST("invalid volume ID", nfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Volume getById(short id) throws ServiceException {
        Volume v = null;
        Short key = new Short(id);
        Object object = sVolumeGuard;
        // MONITORENTER : object
        v = sVolumeMap.get(key);
        // MONITOREXIT : object
        if (v != null) {
            return v;
        }
        object = DbMailbox.getSynchronizer();
        // MONITORENTER : object
        DbPool.Connection conn = null;
        try {
            conn = DbPool.getConnection();
            v = DbVolume.get(conn, id);
            if (v == null) throw VolumeServiceException.NO_SUCH_VOLUME(id);
            Object object2 = sVolumeGuard;
            // MONITORENTER : object2
            sVolumeMap.put(key, v);
            // MONITOREXIT : object2
            object2 = v;
            Object var8_6 = null;
            if (conn != null) {
                DbPool.quietClose(conn);
            }
            // MONITOREXIT : object
            return object2;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (conn == null) throw throwable;
            DbPool.quietClose(conn);
            throw throwable;
        }
    }

    public static List<Volume> getByType(short type) {
        List<Volume> volumes = Volume.getAll();
        Iterator<Volume> i = volumes.iterator();
        while (i.hasNext()) {
            Volume v = i.next();
            if (v.getType() == type) continue;
            i.remove();
        }
        return volumes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Volume> getAll() {
        ArrayList<Volume> volumes;
        Object object = sVolumeGuard;
        synchronized (object) {
            volumes = new ArrayList<Volume>(sVolumeMap.values());
        }
        return volumes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Volume getCurrentMessageVolume() {
        Object object = sVolumeGuard;
        synchronized (object) {
            return sCurrMsgVolume;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Volume getCurrentSecondaryMessageVolume() {
        Object object = sVolumeGuard;
        synchronized (object) {
            return sCurrSecondaryMsgVolume;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Volume getCurrentIndexVolume() {
        Object object = sVolumeGuard;
        synchronized (object) {
            return sCurrIndexVolume;
        }
    }

    public static void setCurrentVolume(short volType, short id) throws ServiceException {
        Volume.setCurrentVolume(volType, id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentVolume(short volType, short id, boolean noRedo) throws ServiceException {
        Volume.validateType(volType);
        Volume.validateID(id, true);
        SetCurrentVolume redoRecorder = null;
        if (!noRedo) {
            redoRecorder = new SetCurrentVolume(volType, id);
            redoRecorder.start(System.currentTimeMillis());
        }
        Volume vol = null;
        if (id != -2 && (vol = Volume.getById(id)).getType() != volType) {
            throw VolumeServiceException.WRONG_TYPE_CURRVOL(id, volType);
        }
        Object object = DbMailbox.getSynchronizer();
        synchronized (object) {
            boolean success = false;
            DbPool.Connection conn = null;
            try {
                conn = DbPool.getConnection();
                DbVolume.updateCurrentVolume(conn, volType, id);
                Object object2 = sVolumeGuard;
                synchronized (object2) {
                    if (volType == 1) {
                        sCurrMsgVolume = vol;
                    } else if (volType == 2) {
                        sCurrSecondaryMsgVolume = vol;
                    } else {
                        sCurrIndexVolume = vol;
                    }
                }
                success = true;
                if (!noRedo) {
                    redoRecorder.log();
                }
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                Volume.endTransaction(success, conn, redoRecorder);
                throw throwable;
            }
            Volume.endTransaction(success, conn, redoRecorder);
        }
    }

    private static void endTransaction(boolean success, DbPool.Connection conn, RedoableOp redoRecorder) throws ServiceException {
        if (success) {
            if (conn != null) {
                conn.commit();
                DbPool.quietClose(conn);
            }
            if (redoRecorder != null) {
                redoRecorder.commit();
            }
        } else {
            if (conn != null) {
                conn.rollback();
                DbPool.quietClose(conn);
            }
            if (redoRecorder != null) {
                redoRecorder.abort();
            }
        }
    }

    public static String getAbsolutePath(String path) {
        return LC.zimbra_relative_volume_path.booleanValue() ? LC.zimbra_home.value() + File.separator + path : path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String normalizePath(String path) throws VolumeServiceException {
        int i;
        if (path == null || path.length() < 1) {
            throw VolumeServiceException.INVALID_REQUEST("Missing volume path");
        }
        if (LC.zimbra_relative_volume_path.booleanValue()) {
            return path;
        }
        StringBuffer newPath = new StringBuffer();
        if (path.matches("^[a-zA-Z]:[/\\\\].*$")) {
            newPath.append(path.substring(0, 2)).append(File.separator);
            path = path.substring(3);
        } else if (path.length() >= 2 && path.substring(0, 2).equals("\\\\")) {
            newPath.append("\\\\");
            String original = path;
            path = path.substring(2);
            int slash = path.indexOf(47);
            int backslash = path.indexOf(92);
            if (slash < 0) {
                slash = path.length();
            }
            if (backslash < 0) {
                backslash = path.length();
            }
            if ((backslash = Math.min(slash, backslash)) < 0) throw VolumeServiceException.NOT_ABSOLUTE_PATH(original);
            newPath.append(path.substring(0, backslash)).append(File.separator);
            path = path.substring(backslash + 1);
        } else {
            if (path.charAt(0) != '/' && path.charAt(0) != '\\') throw VolumeServiceException.NOT_ABSOLUTE_PATH(path);
            newPath.append(File.separator);
            path = path.substring(1);
        }
        String[] dirs = path.split("[/\\\\]");
        if (dirs.length == 0) {
            return newPath.toString();
        }
        String[] newDirs = new String[dirs.length];
        int numDirs = 0;
        for (i = 0; i < dirs.length; ++i) {
            String dir = dirs[i];
            if (dir.length() == 0 || dir.equals(".") || dir.length() > 2 && dir.matches("^\\.+$")) continue;
            if (dir.equals("..")) {
                if (numDirs <= 0) continue;
                --numDirs;
                continue;
            }
            newDirs[numDirs] = dir;
            ++numDirs;
        }
        for (i = 0; i < numDirs; ++i) {
            newPath.append(newDirs[i]);
            if (i >= numDirs - 1) continue;
            newPath.append(File.separator);
        }
        return newPath.toString();
    }

    public Volume(short id, short type, String name, String rootPath, short mboxGroupBits, short mboxBits, short fileGroupBits, short fileBits, boolean compressBlobs, long compressionThreshold) {
        this.mId = id;
        this.mType = type;
        this.mName = name;
        this.mRootPath = rootPath;
        this.mIncomingMsgDir = this.mRootPath + File.separator + INCOMING_DIR;
        if (type == 1 || type == 2) {
            this.mIncoming = new IncomingDirectory(this.mIncomingMsgDir);
        }
        this.mMboxGroupBits = mboxGroupBits;
        this.mMboxBits = mboxBits;
        this.mFileGroupBits = fileGroupBits;
        this.mFileBits = fileBits;
        long mask = (long)Math.pow(2.0, this.mMboxGroupBits) - 1L;
        this.mMboxGroupBitMask = (int)mask;
        mask = (long)Math.pow(2.0, this.mFileGroupBits) - 1L;
        this.mFileGroupBitMask = (int)mask;
        this.mCompressBlobs = compressBlobs;
        this.mCompressionThreshold = compressionThreshold;
    }

    public short getId() {
        return this.mId;
    }

    public short getType() {
        return this.mType;
    }

    public String getName() {
        return this.mName;
    }

    public String getLocator() {
        return Short.toString(this.getId());
    }

    public String getRootPath() {
        return this.mRootPath;
    }

    public String getIncomingMsgDir() {
        return this.mIncomingMsgDir;
    }

    public IncomingDirectory getIncomingDirectory() {
        return this.mIncoming;
    }

    public short getMboxGroupBits() {
        return this.mMboxGroupBits;
    }

    public short getMboxBits() {
        return this.mMboxBits;
    }

    public short getFileGroupBits() {
        return this.mFileGroupBits;
    }

    public short getFileBits() {
        return this.mFileBits;
    }

    public boolean getCompressBlobs() {
        return this.mCompressBlobs;
    }

    public long getCompressionThreshold() {
        return this.mCompressionThreshold;
    }

    private StringBuffer getMailboxDirStringBuffer(long mboxId, String subdir, int extraCapacity) {
        long dir = mboxId >> this.mMboxBits;
        int capacity = this.mRootPath.length() + 20 + extraCapacity;
        StringBuffer sb = new StringBuffer(capacity);
        sb.append(this.mRootPath).append(File.separator).append(dir &= (long)this.mMboxGroupBitMask).append(File.separator).append(mboxId);
        if (subdir != null) {
            sb.append(File.separator).append(subdir);
        }
        return sb;
    }

    public String getMailboxDir(long mboxId, int type) {
        String subdir = type == 10 ? SUBDIR_INDEX : SUBDIR_MESSAGE;
        return this.getMailboxDirStringBuffer(mboxId, subdir, 0).toString();
    }

    public String getBlobDir(long mboxId, int itemId) {
        long dir = itemId >> this.mFileBits;
        StringBuffer sb = this.getMailboxDirStringBuffer(mboxId, SUBDIR_MESSAGE, 10);
        sb.append(File.separator).append(dir &= (long)this.mFileGroupBitMask);
        return sb.toString();
    }

    public String getMessageRootDir(long mboxId) {
        return this.getMailboxDirStringBuffer(mboxId, null, 0).toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Volume: { id=").append(this.mId);
        sb.append(", type=").append(this.mType);
        sb.append(", name=\"").append(this.mName);
        sb.append("\", rootpath=").append(this.mRootPath);
        sb.append(", mgbits=").append(this.mMboxGroupBits);
        sb.append(", mbits=").append(this.mMboxBits);
        sb.append(", fgbits=").append(this.mFileGroupBits);
        sb.append(", fbits=").append(this.mFileBits);
        sb.append(", compressBlobs=").append(this.mCompressBlobs);
        sb.append(", compressionThreshold=").append(this.mCompressionThreshold).append(" }");
        return sb.toString();
    }
}

