/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store.file;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.cs.store.file.BlobConsistencyChecker;
import com.zimbra.cs.store.file.FileBlobStore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobConsistencyUtil {
    private static final String LO_HELP = "help";
    private static final String LO_VERBOSE = "verbose";
    private static final String LO_MAILBOXES = "mailboxes";
    private static final String LO_VOLUMES = "volumes";
    private static final String LO_SKIP_SIZE_CHECK = "skip-size-check";
    private static final String LO_UNEXPECTED_BLOB_LIST = "unexpected-blob-list";
    private static final String LO_MISSING_BLOB_DELETE_ITEM = "missing-blob-delete-item";
    private static final String LO_INCORRECT_REVISION_RENAME_FILE = "incorrect-revision-rename-file";
    private static final String LO_EXPORT_DIR = "export-dir";
    private static final String LO_NO_EXPORT = "no-export";
    private Options mOptions;
    private List<Long> mMailboxIds;
    private List<Short> mVolumeIds = new ArrayList<Short>();
    private boolean mSkipSizeCheck = false;
    private boolean mVerbose = false;
    private String mUnexpectedBlobList;
    private PrintWriter mUnexpectedBlobWriter;
    private boolean mMissingBlobDeleteItem = false;
    private boolean mNoExport = false;
    private String mExportDir;
    private boolean mIncorrectRevisionRenameFile = false;

    private BlobConsistencyUtil() {
        this.mOptions = new Options();
        this.mOptions.addOption(new Option("h", LO_HELP, false, "Display this help message."));
        this.mOptions.addOption(new Option("v", LO_VERBOSE, false, "Display verbose output.  Display stack trace on error."));
        this.mOptions.addOption(new Option(null, LO_SKIP_SIZE_CHECK, false, "Skip blob size check."));
        Option o = new Option(null, LO_VOLUMES, true, "Specify which volumes to check.  If not specified, check all volumes.");
        o.setArgName("volume-ids");
        this.mOptions.addOption(o);
        o = new Option("m", LO_MAILBOXES, true, "Specify which mailboxes to check.  If not specified, check all mailboxes.");
        o.setArgName("mailbox-ids");
        this.mOptions.addOption(o);
        o = new Option(null, LO_UNEXPECTED_BLOB_LIST, true, "Write the paths of any unexpected blobs to a file.");
        o.setArgName("path");
        this.mOptions.addOption(o);
        this.mOptions.addOption(null, LO_MISSING_BLOB_DELETE_ITEM, false, "Delete any items that have a missing blob.");
        o = new Option(null, LO_EXPORT_DIR, true, "Target directory for database export files.");
        o.setArgName("path");
        this.mOptions.addOption(o);
        this.mOptions.addOption(null, LO_NO_EXPORT, false, "Delete items without exporting.");
        this.mOptions.addOption(new Option(null, LO_INCORRECT_REVISION_RENAME_FILE, false, "Rename the file on disk when the revision number doesn't match."));
    }

    private void usage(String errorMsg) {
        int exitStatus = 0;
        if (errorMsg != null) {
            System.err.println(errorMsg);
            exitStatus = 1;
        }
        HelpFormatter format = new HelpFormatter();
        format.printHelp(new PrintWriter(System.err, true), 80, "zmblobchk [options] start", null, this.mOptions, 2, 2, "\nThe \"start\" command is required, to avoid unintentionally running a blob check.  Id values are separated by commas.");
        System.exit(exitStatus);
    }

    private void parseArgs(String[] args) throws ParseException {
        String mailboxList;
        String volumeList;
        GnuParser parser = new GnuParser();
        CommandLine cl = parser.parse(this.mOptions, args);
        if (CliUtil.hasOption(cl, LO_HELP)) {
            this.usage(null);
        }
        if (cl.getArgs().length == 0 || !cl.getArgs()[0].equals("start")) {
            this.usage(null);
        }
        if ((volumeList = CliUtil.getOptionValue(cl, LO_VOLUMES)) != null) {
            for (String id : volumeList.split(",")) {
                try {
                    this.mVolumeIds.add(Short.parseShort(id));
                }
                catch (NumberFormatException e) {
                    this.usage("Invalid volume id: " + id);
                }
            }
        }
        if ((mailboxList = CliUtil.getOptionValue(cl, LO_MAILBOXES)) != null) {
            this.mMailboxIds = new ArrayList<Long>();
            for (String id : mailboxList.split(",")) {
                try {
                    this.mMailboxIds.add(Long.parseLong(id));
                }
                catch (NumberFormatException e) {
                    this.usage("Invalid mailbox id: " + id);
                }
            }
        }
        this.mSkipSizeCheck = CliUtil.hasOption(cl, LO_SKIP_SIZE_CHECK);
        this.mVerbose = CliUtil.hasOption(cl, LO_VERBOSE);
        this.mUnexpectedBlobList = CliUtil.getOptionValue(cl, LO_UNEXPECTED_BLOB_LIST);
        this.mMissingBlobDeleteItem = CliUtil.hasOption(cl, LO_MISSING_BLOB_DELETE_ITEM);
        this.mExportDir = CliUtil.getOptionValue(cl, LO_EXPORT_DIR);
        if (this.mMissingBlobDeleteItem && this.mExportDir == null) {
            this.mNoExport = CliUtil.hasOption(cl, LO_NO_EXPORT);
            if (!this.mNoExport) {
                this.usage("Please specify either export-dir or no-export when using missing-blob-delete-item");
            }
        }
        this.mIncorrectRevisionRenameFile = CliUtil.hasOption(cl, LO_INCORRECT_REVISION_RENAME_FILE);
    }

    private void run() throws Exception {
        if (this.mUnexpectedBlobList != null) {
            this.mUnexpectedBlobWriter = new PrintWriter(new FileOutputStream(this.mUnexpectedBlobList), true);
        }
        CliUtil.toolSetup();
        SoapProvisioning prov = SoapProvisioning.getAdminInstance();
        prov.soapZimbraAdminAuthenticate();
        if (this.mMailboxIds == null) {
            this.mMailboxIds = this.getAllMailboxIds(prov);
        }
        for (long mboxId : this.mMailboxIds) {
            System.out.println("Checking mailbox " + mboxId + ".");
            this.checkMailbox(mboxId, prov);
        }
        if (this.mUnexpectedBlobWriter != null) {
            this.mUnexpectedBlobWriter.close();
        }
    }

    private List<Long> getAllMailboxIds(SoapProvisioning prov) throws ServiceException {
        ArrayList<Long> ids = new ArrayList<Long>();
        Element.XMLElement request = new Element.XMLElement(AdminConstants.GET_ALL_MAILBOXES_REQUEST);
        Element response = prov.invoke(request);
        for (Element mboxEl : response.listElements("mbox")) {
            ids.add(mboxEl.getAttributeLong("id"));
        }
        return ids;
    }

    private void checkMailbox(long mboxId, SoapProvisioning prov) throws ServiceException {
        Element.XMLElement request = new Element.XMLElement(AdminConstants.CHECK_BLOB_CONSISTENCY_REQUEST);
        for (short volumeId : this.mVolumeIds) {
            request.addElement("volume").addAttribute("id", volumeId);
        }
        request.addElement("mbox").addAttribute("id", mboxId);
        request.addAttribute("checkSize", !this.mSkipSizeCheck);
        Element response = prov.invoke(request);
        for (Element mboxEl : response.listElements("mbox")) {
            BlobConsistencyChecker.Results results = new BlobConsistencyChecker.Results(mboxEl);
            for (BlobConsistencyChecker.BlobInfo blob : results.missingBlobs) {
                System.out.format("Mailbox %d, item %d, rev %d, volume %d, %s: blob not found.\n", results.mboxId, blob.itemId, blob.modContent, blob.volumeId, blob.path);
            }
            for (BlobConsistencyChecker.BlobInfo blob : results.incorrectSize) {
                System.out.format("Mailbox %d, item %d, rev %d, volume %d, %s: incorrect data size.  Expected %d, was %d.  File size is %d.\n", results.mboxId, blob.itemId, blob.modContent, blob.volumeId, blob.path, blob.dbSize, blob.fileDataSize, blob.fileSize);
            }
            for (BlobConsistencyChecker.BlobInfo blob : results.unexpectedBlobs) {
                System.out.format("Mailbox %d, volume %d, %s: unexpected blob.  File size is %d.\n", results.mboxId, blob.volumeId, blob.path, blob.fileSize);
                if (this.mUnexpectedBlobWriter == null) continue;
                this.mUnexpectedBlobWriter.println(blob.path);
            }
            for (BlobConsistencyChecker.BlobInfo blob : results.incorrectModContent) {
                System.out.format("Mailbox %d, item %d, rev %d, volume %d, %s: file has incorrect revision.\n", results.mboxId, blob.itemId, blob.modContent, blob.volumeId, blob.path);
            }
            if (this.mMissingBlobDeleteItem && results.missingBlobs.size() > 0) {
                this.exportAndDelete(prov, results);
            }
            if (!this.mIncorrectRevisionRenameFile) continue;
            for (BlobConsistencyChecker.BlobInfo blob : results.incorrectModContent) {
                File file = new File(blob.path);
                File dir = file.getParentFile();
                if (dir != null) {
                    File newFile = new File(dir, FileBlobStore.getFilename((int)blob.itemId, blob.modContent));
                    System.out.format("Renaming %s to %s.\n", file.getAbsolutePath(), newFile.getAbsolutePath());
                    if (file.renameTo(newFile)) continue;
                    System.err.format("Unable to rename %s to %s.\n", file.getAbsolutePath(), newFile.getAbsolutePath());
                    continue;
                }
                System.err.format("Could not determine parent directory of %s.\n", file.getAbsolutePath());
            }
        }
    }

    private void exportAndDelete(SoapProvisioning prov, BlobConsistencyChecker.Results results) throws ServiceException {
        System.out.format("Deleting %d items from mailbox %d.\n", results.missingBlobs.size(), results.mboxId);
        Element.XMLElement request = new Element.XMLElement(AdminConstants.EXPORT_AND_DELETE_ITEMS_REQUEST);
        request.addAttribute("exportDir", this.mExportDir);
        request.addAttribute("exportFilenamePrefix", "mbox" + results.mboxId + "_");
        Element mboxEl = ((Element)request).addElement("mbox").addAttribute("id", results.mboxId);
        for (BlobConsistencyChecker.BlobInfo blob : results.missingBlobs) {
            mboxEl.addElement("item").addAttribute("id", blob.itemId);
        }
        prov.invoke(request);
    }

    public static void main(String[] args) {
        BlobConsistencyUtil app = new BlobConsistencyUtil();
        try {
            app.parseArgs(args);
        }
        catch (ParseException e) {
            app.usage(e.getMessage());
        }
        try {
            app.run();
        }
        catch (Exception e) {
            if (app.mVerbose) {
                e.printStackTrace(new PrintWriter(System.err, true));
            } else {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.toString();
                }
                System.err.println(msg);
            }
            System.exit(1);
        }
    }
}

