/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store.file;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.db.DbBlobConsistency;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.store.StoreManager;
import com.zimbra.cs.store.file.FileBlobStore;
import com.zimbra.cs.store.file.Volume;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobConsistencyChecker {
    private static final Log sLog = LogFactory.getLog(BlobConsistencyChecker.class);
    private Results mResults;
    private long mMailboxId;
    private boolean mCheckSize = true;
    private static final Pattern PAT_BLOB_FILENAME = Pattern.compile("([0-9]+)-([0-9]+)\\.msg");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Results check(Collection<Short> volumeIds, long mboxId, boolean checkSize) throws ServiceException {
        StoreManager sm = StoreManager.getInstance();
        if (!(sm instanceof FileBlobStore)) {
            throw ServiceException.INVALID_REQUEST(sm.getClass().getSimpleName() + " is not supported", null);
        }
        this.mMailboxId = mboxId;
        this.mCheckSize = checkSize;
        this.mResults = new Results();
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.mMailboxId);
        DbPool.Connection conn = null;
        try {
            conn = DbPool.getConnection();
            for (short volumeId : volumeIds) {
                Volume vol = Volume.getById(volumeId);
                if (vol.getType() == 10) {
                    sLog.warn("Skipping index volume %d.  Only message volumes are supported.", vol.getId());
                    continue;
                }
                int numGroups = 1 << vol.getFileGroupBits();
                int filesPerGroup = 1 << vol.getFileBits();
                long mailboxMaxId = DbBlobConsistency.getMaxId(conn, mbox);
                long minId = 0L;
                int group = 0;
                while (minId < mailboxMaxId && group < numGroups) {
                    HashMap<Long, BlobInfo> blobsById = new HashMap<Long, BlobInfo>();
                    long maxId = minId + (long)filesPerGroup - 1L;
                    String blobDir = vol.getBlobDir(mbox.getId(), (int)minId);
                    while (minId < mailboxMaxId) {
                        for (BlobInfo blob : DbBlobConsistency.getBlobInfo(conn, mbox, minId, maxId, volumeId)) {
                            blobsById.put(blob.itemId, blob);
                        }
                        minId += (long)(numGroups * filesPerGroup);
                    }
                    try {
                        this.check(volumeId, blobDir, blobsById);
                    }
                    catch (IOException e) {
                        throw ServiceException.FAILURE("Unable to check " + blobDir, e);
                    }
                    minId = ++group * filesPerGroup;
                }
            }
            Object var25_21 = null;
        }
        catch (Throwable throwable) {
            Object var25_22 = null;
            DbPool.quietClose(conn);
            throw throwable;
        }
        DbPool.quietClose(conn);
        return this.mResults;
    }

    private void check(short volumeId, String blobDirPath, Map<Long, BlobInfo> blobsById) throws IOException {
        File blobDir = new File(blobDirPath);
        File[] files = blobDir.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        sLog.info("Comparing %d items to %d files in %s.", blobsById.size(), files.length, blobDirPath);
        for (File file : files) {
            BlobInfo blob;
            Matcher matcher = PAT_BLOB_FILENAME.matcher(file.getName());
            long itemId = 0L;
            int modContent = 0;
            if (matcher.matches()) {
                itemId = Long.parseLong(matcher.group(1));
                modContent = Integer.parseInt(matcher.group(2));
            }
            if ((blob = blobsById.remove(itemId)) == null) {
                BlobInfo unexpected = new BlobInfo();
                unexpected.volumeId = volumeId;
                unexpected.path = file.getAbsolutePath();
                unexpected.fileSize = file.length();
                this.mResults.unexpectedBlobs.add(unexpected);
                continue;
            }
            blob.fileSize = file.length();
            blob.fileModContent = modContent;
            if (this.mCheckSize) {
                blob.fileDataSize = BlobConsistencyChecker.getDataSize(file, blob.dbSize);
                if (blob.dbSize != blob.fileDataSize) {
                    this.mResults.incorrectSize.add(blob);
                }
            }
            if (blob.modContent == blob.fileModContent) continue;
            blob.path = file.getAbsolutePath();
            this.mResults.incorrectModContent.add(blob);
        }
        for (BlobInfo blob : blobsById.values()) {
            this.mResults.missingBlobs.add(blob);
        }
    }

    private static long getDataSize(File file, long expected) throws IOException {
        long fileLen = file.length();
        if (fileLen != expected && FileUtil.isGzipped(file)) {
            return ByteUtil.getDataLength(new GZIPInputStream(new FileInputStream(file)));
        }
        return fileLen;
    }

    public static class Results {
        public long mboxId;
        public Collection<BlobInfo> missingBlobs = new ArrayList<BlobInfo>();
        public Collection<BlobInfo> incorrectSize = new ArrayList<BlobInfo>();
        public Collection<BlobInfo> unexpectedBlobs = new ArrayList<BlobInfo>();
        public Collection<BlobInfo> incorrectModContent = new ArrayList<BlobInfo>();

        public Results() {
        }

        public Results(Element mboxElement) throws ServiceException {
            Element blobEl;
            BlobInfo blob;
            if (!mboxElement.getName().equals("mbox")) {
                throw ServiceException.INVALID_REQUEST("Unexpected element: " + mboxElement.getName(), null);
            }
            this.mboxId = mboxElement.getAttributeLong("id");
            for (Element item : mboxElement.getElement("missingBlobs").listElements("item")) {
                blob = new BlobInfo();
                blob.itemId = item.getAttributeLong("id");
                blob.modContent = (int)item.getAttributeLong("rev");
                blob.dbSize = item.getAttributeLong("s");
                blob.volumeId = (short)item.getAttributeLong("volumeId");
                blob.path = item.getAttribute("blobPath");
                this.missingBlobs.add(blob);
            }
            for (Element itemEl : mboxElement.getElement("incorrectSize").listElements("item")) {
                blob = new BlobInfo();
                blob.itemId = itemEl.getAttributeLong("id");
                blob.modContent = (int)itemEl.getAttributeLong("rev");
                blob.dbSize = itemEl.getAttributeLong("s");
                blob.volumeId = (short)itemEl.getAttributeLong("volumeId");
                blobEl = itemEl.getElement("blob");
                blob.path = blobEl.getAttribute("path");
                blob.fileDataSize = blobEl.getAttributeLong("s");
                blob.fileSize = blobEl.getAttributeLong("fileSize");
                this.incorrectSize.add(blob);
            }
            for (Element blobEl2 : mboxElement.getElement("unexpectedBlobs").listElements("blob")) {
                blob = new BlobInfo();
                blob.volumeId = (short)blobEl2.getAttributeLong("volumeId");
                blob.path = blobEl2.getAttribute("path");
                blob.fileSize = blobEl2.getAttributeLong("fileSize");
                this.unexpectedBlobs.add(blob);
            }
            for (Element itemEl : mboxElement.getElement("incorrectRevision").listElements("item")) {
                blob = new BlobInfo();
                blob.itemId = itemEl.getAttributeLong("id");
                blob.modContent = (int)itemEl.getAttributeLong("rev");
                blob.dbSize = itemEl.getAttributeLong("s");
                blob.volumeId = (short)itemEl.getAttributeLong("volumeId");
                blobEl = itemEl.getElement("blob");
                blob.path = blobEl.getAttribute("path");
                blob.fileSize = blobEl.getAttributeLong("fileSize");
                blob.fileModContent = (int)blobEl.getAttributeLong("rev");
                this.incorrectModContent.add(blob);
            }
        }

        public boolean hasInconsistency() {
            return !this.missingBlobs.isEmpty() || !this.incorrectSize.isEmpty() || !this.unexpectedBlobs.isEmpty() || !this.incorrectModContent.isEmpty();
        }

        public void toElement(Element parent) {
            Element itemEl;
            Element missingEl = parent.addElement("missingBlobs");
            Element incorrectSizeEl = parent.addElement("incorrectSize");
            Element unexpectedBlobsEl = parent.addElement("unexpectedBlobs");
            Element incorrectRevisionEl = parent.addElement("incorrectRevision");
            for (BlobInfo blob : this.missingBlobs) {
                missingEl.addElement("item").addAttribute("id", blob.itemId).addAttribute("rev", blob.modContent).addAttribute("s", blob.dbSize).addAttribute("volumeId", blob.volumeId).addAttribute("blobPath", blob.path);
            }
            for (BlobInfo blob : this.incorrectSize) {
                itemEl = incorrectSizeEl.addElement("item").addAttribute("id", blob.itemId).addAttribute("rev", blob.modContent).addAttribute("s", blob.dbSize).addAttribute("volumeId", blob.volumeId);
                itemEl.addElement("blob").addAttribute("path", blob.path).addAttribute("s", blob.fileDataSize).addAttribute("fileSize", blob.fileSize);
            }
            for (BlobInfo blob : this.unexpectedBlobs) {
                unexpectedBlobsEl.addElement("blob").addAttribute("volumeId", blob.volumeId).addAttribute("path", blob.path).addAttribute("fileSize", blob.fileSize);
            }
            for (BlobInfo blob : this.incorrectModContent) {
                itemEl = incorrectRevisionEl.addElement("item").addAttribute("id", blob.itemId).addAttribute("rev", blob.modContent).addAttribute("s", blob.dbSize).addAttribute("volumeId", blob.volumeId);
                itemEl.addElement("blob").addAttribute("path", blob.path).addAttribute("fileSize", blob.fileSize).addAttribute("rev", blob.fileModContent);
            }
        }
    }

    public static class BlobInfo {
        public long itemId;
        public int modContent;
        public int version;
        public long dbSize;
        public String path;
        public short volumeId;
        public int fileModContent;
        public Long fileDataSize;
        public Long fileSize;
    }
}

