/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store;

import com.zimbra.common.util.CalculatorStream;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.store.SharedFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UncompressedFileCache<K> {
    private static final Log sLog = LogFactory.getLog(UncompressedFileCache.class);
    private long mMaxBytes = 0x6400000L;
    private int mMaxFiles = 10240;
    private File mCacheDir;
    private LinkedHashMap<K, String> mKeyToDigest;
    private Map<String, File> mDigestToFile;
    private long mNumBytes = 0L;

    public UncompressedFileCache(String path) {
        if (path == null) {
            throw new NullPointerException("Path cannot be null.");
        }
        this.mCacheDir = new File(path);
    }

    public synchronized UncompressedFileCache<K> setMaxBytes(Long maxBytes) {
        this.mMaxBytes = maxBytes != null ? maxBytes : Long.MAX_VALUE;
        this.pruneIfNecessary();
        return this;
    }

    public synchronized UncompressedFileCache<K> setMaxFiles(Integer maxFiles) {
        this.mMaxFiles = maxFiles != null ? maxFiles : Integer.MAX_VALUE;
        this.pruneIfNecessary();
        return this;
    }

    public synchronized UncompressedFileCache<K> startup() throws IOException {
        if (!this.mCacheDir.exists()) {
            throw new IOException("uncompressed file cache folder does not exist: " + this.mCacheDir);
        }
        if (!this.mCacheDir.isDirectory()) {
            throw new IOException("uncompressed file cache folder is not a directory: " + this.mCacheDir);
        }
        this.mKeyToDigest = new LinkedHashMap(16, 0.75f, true);
        this.mDigestToFile = new HashMap<String, File>();
        for (File file : this.mCacheDir.listFiles()) {
            sLog.debug("Deleting %s.", file.getPath());
            if (file.delete()) continue;
            ZimbraLog.store.warn("unable to delete " + file.getPath() + " from uncompressed file cache");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedFile get(K key, File compressedFile, boolean sync) throws IOException {
        File uncompressedFile = null;
        sLog.debug("Looking up SharedFile for key %s, path %s.", key, compressedFile.getPath());
        UncompressedFileCache uncompressedFileCache = this;
        synchronized (uncompressedFileCache) {
            String digest = this.mKeyToDigest.get(key);
            if (digest != null && (uncompressedFile = this.mDigestToFile.get(digest)) != null) {
                sLog.debug("Found existing uncompressed file.  Returning new SharedFile.");
                return new SharedFile(uncompressedFile);
            }
        }
        UncompressedFile temp = this.uncompressToTempFile(compressedFile, sync);
        SharedFile shared = null;
        UncompressedFileCache uncompressedFileCache2 = this;
        synchronized (uncompressedFileCache2) {
            uncompressedFile = this.mDigestToFile.get(temp.digest);
            if (uncompressedFile != null) {
                sLog.debug("Found existing uncompressed file for digest %s.  Deleting %s.", temp.digest, temp.file.getPath());
                this.mKeyToDigest.put(key, temp.digest);
                temp.file.delete();
                shared = new SharedFile(uncompressedFile);
            } else {
                String oldPath = temp.file.getPath();
                uncompressedFile = new File(this.mCacheDir, temp.digest);
                if (!temp.file.renameTo(uncompressedFile)) {
                    throw new IOException("Cannot move " + oldPath + " to " + uncompressedFile.getPath());
                }
                shared = new SharedFile(uncompressedFile);
                this.put(key, temp.digest, uncompressedFile);
            }
        }
        return shared;
    }

    private UncompressedFile uncompressToTempFile(File compressedFile, boolean sync) throws IOException {
        CalculatorStream calc = new CalculatorStream(new GZIPInputStream(new FileInputStream(compressedFile)));
        File tempFile = File.createTempFile(UncompressedFileCache.class.getSimpleName(), null);
        FileUtil.uncompress(calc, tempFile, sync);
        String digest = calc.getDigest();
        sLog.debug("Uncompressed %s to %s, digest=%s.", compressedFile.getPath(), tempFile.getPath(), digest);
        UncompressedFile result = new UncompressedFile();
        result.file = tempFile;
        result.digest = digest;
        return result;
    }

    private synchronized void put(K key, String digest, File file) {
        long fileSize = file.length();
        sLog.debug("Adding file to the uncompressed cache: key=%s, size=%d, path=%s.", key, fileSize, file.getPath());
        this.mKeyToDigest.put(key, digest);
        this.mDigestToFile.put(digest, file);
        this.mNumBytes += fileSize;
        this.pruneIfNecessary();
    }

    private synchronized void pruneIfNecessary() {
        if (this.mKeyToDigest == null || this.mNumBytes < this.mMaxBytes && this.mDigestToFile.size() < this.mMaxFiles) {
            return;
        }
        Iterator<Map.Entry<K, String>> iEntries = this.mKeyToDigest.entrySet().iterator();
        while (iEntries.hasNext()) {
            Map.Entry<K, String> entry = iEntries.next();
            K key = entry.getKey();
            String digest = entry.getValue();
            iEntries.remove();
            File file = this.mDigestToFile.remove(digest);
            if (file != null) {
                sLog.debug("Deleting %s: key=%s, digest=%s.", file.getPath(), key, digest);
                this.mNumBytes -= file.length();
                if (!file.delete()) {
                    sLog.warn("Unable to delete %s.", file.getPath());
                }
            }
            if (this.mNumBytes >= this.mMaxBytes || this.mDigestToFile.size() >= this.mMaxFiles) continue;
            break;
        }
    }

    private class UncompressedFile {
        String digest;
        File file;

        UncompressedFile() {
        }
    }
}

