/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.store.BlobBuilder;
import com.zimbra.cs.store.MailboxBlob;
import com.zimbra.cs.store.StagedBlob;
import com.zimbra.cs.store.StorageCallback;
import com.zimbra.cs.store.file.FileBlobStore;
import com.zimbra.cs.util.Zimbra;
import java.io.IOException;
import java.io.InputStream;

public abstract class StoreManager {
    private static StoreManager sInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StoreManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<StoreManager> clazz = StoreManager.class;
        synchronized (StoreManager.class) {
            if (sInstance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return sInstance;
            }
            String className = LC.zimbra_class_store.value();
            try {
                sInstance = className != null && !className.equals("") ? (StoreManager)Class.forName(className).newInstance() : new FileBlobStore();
            }
            catch (Throwable t) {
                Zimbra.halt("unable to initialize blob store", t);
            }
            return sInstance;
        }
    }

    public abstract void startup() throws IOException, ServiceException;

    public abstract void shutdown();

    public abstract BlobBuilder getBlobBuilder() throws IOException, ServiceException;

    public Blob storeIncoming(InputStream data, long sizeHint, StorageCallback callback) throws IOException, ServiceException {
        return this.storeIncoming(data, sizeHint, callback, false);
    }

    public abstract Blob storeIncoming(InputStream var1, long var2, StorageCallback var4, boolean var5) throws IOException, ServiceException;

    public abstract StagedBlob stage(InputStream var1, long var2, StorageCallback var4, Mailbox var5) throws IOException, ServiceException;

    public abstract StagedBlob stage(Blob var1, Mailbox var2) throws IOException, ServiceException;

    public abstract MailboxBlob copy(MailboxBlob var1, Mailbox var2, int var3, int var4) throws IOException, ServiceException;

    public abstract MailboxBlob link(StagedBlob var1, Mailbox var2, int var3, int var4) throws IOException, ServiceException;

    public abstract MailboxBlob link(MailboxBlob var1, Mailbox var2, int var3, int var4) throws IOException, ServiceException;

    public abstract MailboxBlob renameTo(StagedBlob var1, Mailbox var2, int var3, int var4) throws IOException, ServiceException;

    public abstract boolean delete(Blob var1) throws IOException;

    public boolean quietDelete(Blob blob) {
        if (blob == null) {
            return true;
        }
        try {
            return this.delete(blob);
        }
        catch (IOException ioe) {
            ZimbraLog.store.warn("could not delete blob " + blob.getPath());
            return false;
        }
    }

    public abstract boolean delete(StagedBlob var1) throws IOException;

    public boolean quietDelete(StagedBlob staged) {
        if (staged == null) {
            return true;
        }
        try {
            return this.delete(staged);
        }
        catch (IOException ioe) {
            ZimbraLog.store.warn("could not delete staged blob " + staged);
            return false;
        }
    }

    public abstract boolean delete(MailboxBlob var1) throws IOException;

    public boolean quietDelete(MailboxBlob mblob) {
        if (mblob == null) {
            return true;
        }
        try {
            return this.delete(mblob);
        }
        catch (IOException ioe) {
            ZimbraLog.store.warn("could not delete blob " + mblob);
            return false;
        }
    }

    public abstract MailboxBlob getMailboxBlob(Mailbox var1, int var2, int var3, String var4) throws ServiceException;

    public MailboxBlob getMailboxBlob(MailItem item) throws ServiceException {
        MailboxBlob mblob = this.getMailboxBlob(item.getMailbox(), item.getId(), item.getSavedSequence(), item.getLocator());
        if (mblob != null) {
            mblob.setDigest(item.getDigest()).setSize(item.getSize());
        }
        return mblob;
    }

    public abstract InputStream getContent(MailboxBlob var1) throws IOException;

    public abstract InputStream getContent(Blob var1) throws IOException;

    public abstract boolean deleteStore(Mailbox var1) throws IOException, ServiceException;
}

