/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.store.Blob;
import java.io.IOException;

public abstract class StorageCallback {
    private static Integer sDiskStreamingThreshold;

    public static int getDiskStreamingThreshold() throws ServiceException {
        if (sDiskStreamingThreshold == null) {
            StorageCallback.loadSettings();
        }
        return sDiskStreamingThreshold;
    }

    public static void loadSettings() throws ServiceException {
        Server server = Provisioning.getInstance().getLocalServer();
        sDiskStreamingThreshold = server.getMailDiskStreamingThreshold();
    }

    public void wrote(Blob blob, byte[] data, int numBytes) throws IOException {
        this.wrote(blob, data, 0, numBytes);
    }

    public abstract void wrote(Blob var1, byte[] var2, int var3, int var4) throws IOException;
}

