/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.stats.ZimbraPerf;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SharedFile {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private File mFile;
    private RandomAccessFile mRAF;
    private long mPos = 0L;
    private long mLength;
    private byte[] mBuf;
    private long mBufStartPos = 0L;
    private int mBufSize = 0;

    SharedFile(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        if (!file.exists()) {
            throw new IOException(file.getPath() + " does not exist.");
        }
        this.mFile = file;
        this.mLength = file.length();
        int bufSize = 4096;
        try {
            bufSize = Provisioning.getInstance().getLocalServer().getMailFileDescriptorBufferSize();
        }
        catch (ServiceException e) {
            ZimbraLog.store.warn("Unable to determine default buffer size.  Using %d.", (Object)4096, e);
        }
        bufSize = (int)Math.min((long)bufSize, this.mLength);
        this.mBuf = new byte[bufSize];
        this.openIfNecessary();
    }

    synchronized long getLength() {
        return this.mLength;
    }

    synchronized int read(long fileOffset) throws IOException {
        if (fileOffset >= this.mBufStartPos && fileOffset < this.mBufStartPos + (long)this.mBufSize) {
            int bufOffset = (int)(fileOffset - this.mBufStartPos);
            ZimbraPerf.COUNTER_BLOB_INPUT_STREAM_SEEK_RATE.increment(0L);
            return this.mBuf[bufOffset] & 0xFF;
        }
        byte[] buf = new byte[1];
        int retVal = this.read(fileOffset, buf, 0, 1);
        if (retVal < 0) {
            return retVal;
        }
        return buf[0] & 0xFF;
    }

    synchronized int read(long fileOffset, byte[] b, int off, int len) throws IOException {
        int numRead = 0;
        boolean seeked = false;
        this.openIfNecessary();
        if (len <= this.mBuf.length) {
            if (fileOffset >= this.mBufStartPos && fileOffset < this.mBufStartPos + (long)this.mBufSize) {
                int bufOffset = (int)(fileOffset - this.mBufStartPos);
                numRead = Math.min(len, this.mBufSize - bufOffset);
                System.arraycopy(this.mBuf, bufOffset, b, off, numRead);
            } else {
                if (this.mPos != fileOffset) {
                    this.mRAF.seek(fileOffset);
                    this.mPos = fileOffset;
                    seeked = true;
                }
                if ((numRead = this.mRAF.read(this.mBuf)) <= 0) {
                    this.mBufSize = 0;
                } else {
                    this.mBufSize = numRead;
                    this.mBufStartPos = this.mPos;
                    this.mPos += (long)this.mBufSize;
                    numRead = Math.min(len, this.mBufSize);
                    System.arraycopy(this.mBuf, 0, b, off, numRead);
                }
            }
        } else {
            if (this.mPos != fileOffset) {
                this.mRAF.seek(fileOffset);
                this.mPos = fileOffset;
                seeked = true;
            }
            numRead = this.mRAF.read(b, off, len);
            this.mPos += (long)numRead;
        }
        if (seeked) {
            ZimbraPerf.COUNTER_BLOB_INPUT_STREAM_SEEK_RATE.increment(100L);
        } else {
            ZimbraPerf.COUNTER_BLOB_INPUT_STREAM_SEEK_RATE.increment(0L);
        }
        ZimbraPerf.COUNTER_BLOB_INPUT_STREAM_READ.increment();
        return numRead;
    }

    private synchronized void openIfNecessary() throws IOException {
        if (this.mRAF == null) {
            if (!this.mFile.exists()) {
                throw new IOException(this.mFile.getPath() + " does not exist.");
            }
            this.mRAF = new RandomAccessFile(this.mFile, "r");
            this.mPos = 0L;
        }
    }

    synchronized void close() throws IOException {
        if (this.mRAF != null) {
            this.mRAF.close();
            this.mPos = 0L;
            this.mRAF = null;
        }
    }
}

