/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store;

import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.store.Blob;
import java.io.IOException;

public abstract class MailboxBlob {
    private Mailbox mMailbox;
    private int mItemId;
    private int mRevision;
    private String mLocator;
    protected Long mSize;
    protected String mDigest;

    protected MailboxBlob(Mailbox mbox, int itemId, int revision, String locator) {
        this.mMailbox = mbox;
        this.mItemId = itemId;
        this.mRevision = revision;
        this.mLocator = locator;
    }

    public int getItemId() {
        return this.mItemId;
    }

    public int getRevision() {
        return this.mRevision;
    }

    public String getLocator() {
        return this.mLocator;
    }

    public String getDigest() throws IOException {
        if (this.mDigest == null) {
            this.mDigest = this.getLocalBlob().getDigest();
        }
        return this.mDigest;
    }

    public MailboxBlob setDigest(String digest) {
        this.mDigest = digest;
        return this;
    }

    public long getSize() throws IOException {
        if (this.mSize == null) {
            this.mSize = new Long(this.getLocalBlob().getRawSize());
        }
        return this.mSize;
    }

    public MailboxBlob setSize(long size) {
        this.mSize = size;
        return this;
    }

    public Mailbox getMailbox() {
        return this.mMailbox;
    }

    public abstract Blob getLocalBlob() throws IOException;

    public String toString() {
        return this.mMailbox.getId() + ":" + this.mItemId + ":" + this.mRevision + "[" + this.getLocator() + "]";
    }
}

