/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store;

import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.store.StoreManager;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LocalBlobCache {
    private long mMaxBytes = 0x6400000L;
    private int mMaxFiles = 10240;
    private File mCacheDir;
    private LinkedHashMap<String, Blob> mKeyToBlob;
    private long mNumBytes = 0L;

    public LocalBlobCache(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        this.mCacheDir = new File(path);
    }

    public synchronized LocalBlobCache setMaxBytes(Long maxBytes) {
        this.mMaxBytes = maxBytes == null ? Long.MAX_VALUE : maxBytes;
        this.pruneIfNecessary();
        return this;
    }

    public synchronized LocalBlobCache setMaxFiles(Integer maxFiles) {
        this.mMaxFiles = maxFiles == null ? Integer.MAX_VALUE : maxFiles;
        this.pruneIfNecessary();
        return this;
    }

    public synchronized void startup() throws IOException {
        FileUtil.mkdirs(this.mCacheDir);
        if (!this.mCacheDir.exists()) {
            throw new IOException("local blob cache folder does not exist: " + this.mCacheDir);
        }
        if (!this.mCacheDir.isDirectory()) {
            throw new IOException("local blob cache folder is not a directory: " + this.mCacheDir);
        }
        this.mKeyToBlob = new LinkedHashMap(16, 0.75f, true);
        for (File file : this.mCacheDir.listFiles()) {
            ZimbraLog.store.debug("deleting stale cached file " + file.getPath());
            if (file.delete()) continue;
            ZimbraLog.store.warn("unable to delete stale cached file: " + file.getPath());
        }
    }

    public synchronized Blob get(String key) {
        return this.mKeyToBlob.get(key);
    }

    public synchronized Blob cache(String key, Blob blob) throws IOException {
        Blob found = this.mKeyToBlob.get(key);
        if (found != null) {
            return found;
        }
        long size = blob.getRawSize();
        blob.renameTo(this.mCacheDir + File.separator + blob.getDigest());
        this.mKeyToBlob.put(key, blob);
        this.mNumBytes += size;
        return blob;
    }

    private synchronized void pruneIfNecessary() {
        if (this.mKeyToBlob == null || this.mNumBytes < this.mMaxBytes && this.mKeyToBlob.size() < this.mMaxFiles) {
            return;
        }
        StoreManager sm = StoreManager.getInstance();
        Iterator<Map.Entry<String, Blob>> iEntries = this.mKeyToBlob.entrySet().iterator();
        while (iEntries.hasNext() && (this.mNumBytes >= this.mMaxBytes || this.mKeyToBlob.size() >= this.mMaxFiles)) {
            Map.Entry<String, Blob> entry = iEntries.next();
            String key = entry.getKey();
            Blob blob = entry.getValue();
            try {
                this.mNumBytes -= blob.getRawSize();
            }
            catch (IOException ioe) {
                continue;
            }
            if (ZimbraLog.store.isDebugEnabled()) {
                ZimbraLog.store.debug("deleting cached local blob: locator=" + key);
            }
            if (!sm.quietDelete(blob)) {
                ZimbraLog.store.warn("unable to delete cached local blob " + blob.getPath());
            }
            iEntries.remove();
        }
    }
}

