/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.ZimbraLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncomingDirectory {
    private String mPath;
    private UniqueFileNameGenerator mNameGenerator;
    private static final long SWEEP_INTERVAL_MS = 60000L;
    private static IncomingDirectorySweeper mSweeper;

    public IncomingDirectory(String path) {
        this.mPath = path;
        this.mNameGenerator = new UniqueFileNameGenerator();
    }

    public String getPath() {
        return this.mPath;
    }

    void setPath(String path) {
        this.mPath = path;
    }

    public File getNewIncomingFile() {
        return new File(this.mPath + File.separator + this.mNameGenerator.getFilename());
    }

    public static synchronized void startSweeper() {
        if (mSweeper != null) {
            return;
        }
        long sweepMaxAgeMS = LC.zimbra_store_sweeper_max_age.intValue() * 60 * 1000;
        IncomingDirectorySweeper sweeper = new IncomingDirectorySweeper(60000L, sweepMaxAgeMS);
        sweeper.start();
        mSweeper = sweeper;
    }

    public static synchronized void stopSweeper() {
        if (mSweeper == null) {
            return;
        }
        mSweeper.signalShutdown();
        try {
            mSweeper.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        mSweeper = null;
    }

    public static synchronized void setSweptDirectories(IncomingDirectory inc) {
        IncomingDirectorySweeper.sSweptDirectories = Arrays.asList(inc);
    }

    public static synchronized void setSweptDirectories(Collection<IncomingDirectory> swept) {
        IncomingDirectorySweeper.sSweptDirectories = swept == null ? Collections.emptyList() : new ArrayList<IncomingDirectory>(swept);
    }

    private static class IncomingDirectorySweeper
    extends Thread {
        static List<IncomingDirectory> sSweptDirectories;
        private boolean mShutdown = false;
        private long mSweepIntervalMS;
        private long mMaxAgeMS;

        public IncomingDirectorySweeper(long sweepIntervalMS, long maxAgeMS) {
            super("IncomingDirectorySweeper");
            this.setDaemon(true);
            this.mSweepIntervalMS = sweepIntervalMS;
            this.mMaxAgeMS = maxAgeMS;
        }

        public synchronized void signalShutdown() {
            this.mShutdown = true;
            this.wakeup();
        }

        public synchronized void wakeup() {
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ZimbraLog.store.info(this.getName() + " thread starting");
            boolean shutdown = false;
            long startTime = System.currentTimeMillis();
            while (!shutdown) {
                IncomingDirectorySweeper incomingDirectorySweeper = this;
                synchronized (incomingDirectorySweeper) {
                    long now;
                    long until;
                    if (!this.mShutdown && (until = startTime + this.mSweepIntervalMS) > (now = System.currentTimeMillis())) {
                        try {
                            this.wait(until - now);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    if (shutdown = this.mShutdown) {
                        break;
                    }
                }
                int numDeleted = 0;
                startTime = System.currentTimeMillis();
                for (IncomingDirectory inc : sSweptDirectories) {
                    File[] files;
                    File directory = new File(inc.getPath());
                    if (!directory.exists() || (files = directory.listFiles()) == null) continue;
                    for (int i = 0; i < files.length; ++i) {
                        long age;
                        long lastMod;
                        File file;
                        if (i % 100 == 0) {
                            IncomingDirectorySweeper incomingDirectorySweeper2 = this;
                            synchronized (incomingDirectorySweeper2) {
                                shutdown = this.mShutdown;
                            }
                            if (shutdown) break;
                        }
                        if ((file = files[i]).isDirectory() || (lastMod = file.lastModified()) <= 0L || (age = startTime - lastMod) < this.mMaxAgeMS) continue;
                        boolean deleted = file.delete();
                        if (!deleted) {
                            if (!file.exists()) continue;
                            ZimbraLog.store.warn("Sweeper unable to delete " + file.getAbsolutePath());
                            continue;
                        }
                        if (!ZimbraLog.store.isDebugEnabled()) continue;
                        ZimbraLog.store.debug("Sweeper deleted " + file.getAbsolutePath());
                        ++numDeleted;
                    }
                    IncomingDirectorySweeper incomingDirectorySweeper3 = this;
                    synchronized (incomingDirectorySweeper3) {
                        shutdown = this.mShutdown;
                    }
                    if (!shutdown) continue;
                    break;
                }
                long elapsed = System.currentTimeMillis() - startTime;
                ZimbraLog.store.debug("Incoming directory sweep deleted " + numDeleted + " files in " + elapsed + "ms");
            }
            ZimbraLog.store.info(this.getName() + " thread exiting");
        }
    }

    private static class UniqueFileNameGenerator {
        private long mTime;
        private long mSequence;

        public UniqueFileNameGenerator() {
            this.reset();
        }

        private void reset() {
            this.mTime = System.currentTimeMillis();
            this.mSequence = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getFilename() {
            long sequence;
            long time;
            UniqueFileNameGenerator uniqueFileNameGenerator = this;
            synchronized (uniqueFileNameGenerator) {
                if (this.mSequence >= 1000L) {
                    this.reset();
                }
                time = this.mTime;
                sequence = this.mSequence++;
            }
            return time + "-" + sequence + ".msg";
        }
    }
}

