/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.stats.Counter;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.store.SharedFile;
import com.zimbra.cs.store.UncompressedFileCache;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDescriptorCache {
    private LinkedHashMap<String, SharedFile> mCache = new LinkedHashMap(16, 0.75f, true);
    private int mMaxSize = 1000;
    private UncompressedFileCache<String> mUncompressedFileCache;
    private Counter mHitRate = new Counter();

    public FileDescriptorCache(UncompressedFileCache<String> uncompressedCache) {
        this.mUncompressedFileCache = uncompressedCache;
    }

    UncompressedFileCache<String> getUncompressedFileCache() {
        return this.mUncompressedFileCache;
    }

    public synchronized FileDescriptorCache setMaxSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxSize value of " + maxSize + " is invalid (must be at least 0)");
        }
        this.mMaxSize = maxSize;
        this.mHitRate.reset();
        this.pruneIfNecessary();
        return this;
    }

    public FileDescriptorCache loadSettings() throws ServiceException {
        Server server = Provisioning.getInstance().getLocalServer();
        int uncompressedMaxFiles = server.getMailUncompressedCacheMaxFiles();
        long uncompressedMaxBytes = server.getMailUncompressedCacheMaxBytes();
        int fileDescriptorCacheSize = server.getMailFileDescriptorCacheSize();
        ZimbraLog.store.info("Loading FileDescriptorCache settings: %s=%d, %s=%d, %s=%d.", "zimbraMailUncompressedCacheMaxFiles", uncompressedMaxFiles, "zimbraMailUncompressedCacheMaxBytes", uncompressedMaxBytes, "zimbraMailFileDescriptorCacheSize", fileDescriptorCacheSize);
        this.setMaxSize(fileDescriptorCacheSize);
        this.mUncompressedFileCache.setMaxBytes(uncompressedMaxBytes);
        this.mUncompressedFileCache.setMaxFiles(uncompressedMaxFiles);
        return this;
    }

    public int read(String path, long rawSize, long fileOffset) throws IOException {
        SharedFile file = this.getSharedFile(path, rawSize);
        int retVal = file.read(fileOffset);
        this.closeIfPruned(path, file);
        return retVal;
    }

    public int read(String path, long rawSize, long fileOffset, byte[] buf, int bufferOffset, int len) throws IOException {
        SharedFile file = this.getSharedFile(path, rawSize);
        int numRead = file.read(fileOffset, buf, bufferOffset, len);
        this.closeIfPruned(path, file);
        return numRead;
    }

    private synchronized void closeIfPruned(String path, SharedFile file) throws IOException {
        if (!this.mCache.containsKey(path)) {
            file.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedFile getSharedFile(String path, long rawSize) throws IOException {
        SharedFile sharedFile = null;
        FileDescriptorCache fileDescriptorCache = this;
        synchronized (fileDescriptorCache) {
            sharedFile = this.mCache.get(path);
        }
        if (sharedFile == null) {
            this.mHitRate.increment(0L);
            File file = new File(path);
            if (file.length() != rawSize && FileUtil.isGzipped(file)) {
                ZimbraLog.store.debug("Adding file descriptor cache entry for %s from the uncompressed file cache.", path);
                sharedFile = this.mUncompressedFileCache.get(path, new File(path), !DebugConfig.disableMessageStoreFsync);
            } else {
                ZimbraLog.store.debug("opening new file descriptor for " + path);
                sharedFile = new SharedFile(file);
            }
            FileDescriptorCache fileDescriptorCache2 = this;
            synchronized (fileDescriptorCache2) {
                this.mCache.put(path, sharedFile);
            }
            this.pruneIfNecessary();
        } else {
            this.mHitRate.increment(100L);
        }
        return sharedFile;
    }

    public synchronized void close(String path) {
        SharedFile file = (SharedFile)this.mCache.remove(path);
        if (file != null) {
            ZimbraLog.store.debug("closing file descriptor for " + path);
            try {
                file.close();
            }
            catch (IOException e) {
                ZimbraLog.store.warn((Object)("unable to close file descriptor for " + path), e);
            }
        }
    }

    public int getSize() {
        return this.mCache.size();
    }

    public double getHitRate() {
        return this.mHitRate.getAverage();
    }

    private synchronized void pruneIfNecessary() {
        if (this.mCache.size() <= this.mMaxSize) {
            return;
        }
        Iterator<Map.Entry<String, SharedFile>> iEntries = this.mCache.entrySet().iterator();
        while (iEntries.hasNext() && this.mCache.size() > this.mMaxSize) {
            Map.Entry<String, SharedFile> mapEntry = iEntries.next();
            String path = mapEntry.getKey();
            SharedFile file = mapEntry.getValue();
            iEntries.remove();
            try {
                ZimbraLog.store.debug("closing file descriptor for " + path);
                file.close();
            }
            catch (IOException e) {
                ZimbraLog.store.warn((Object)("unable to close file descriptor for " + path), e);
            }
        }
    }
}

