/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store;

import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.store.FileDescriptorCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.internet.SharedInputStream;

public class BlobInputStream
extends InputStream
implements SharedInputStream {
    private static final Log sLog = LogFactory.getLog(BlobInputStream.class);
    private File mFile;
    private long mRawSize;
    private Long mMarkPos;
    private long mPos;
    private int mMarkReadLimit;
    private long mStart;
    private long mEnd;
    private BlobInputStream mRoot;
    private static FileDescriptorCache mFileDescriptorCache;

    public BlobInputStream(Blob blob) throws IOException {
        this(blob.getFile(), blob.getRawSize(), null, null, null);
    }

    public BlobInputStream(File file, long rawSize) throws IOException {
        this(file, rawSize, null, null, null);
    }

    public BlobInputStream(File file, long rawSize, Long start, Long end) throws IOException {
        this(file, rawSize, start, end, null);
    }

    private BlobInputStream(File file, long rawSize, Long start, Long end, BlobInputStream parent) throws IOException {
        if (parent == null) {
            this.mFile = file;
            this.mRoot = this;
        } else {
            this.mRoot = parent.mRoot;
            file = this.mRoot.mFile;
        }
        this.mRawSize = rawSize;
        if (!file.exists()) {
            throw new IOException(file.getPath() + " does not exist.");
        }
        if (start != null && end != null && start > end) {
            String msg = String.format("Start index %d for file %s is larger than end index %d", start, file.getPath(), end);
            throw new IOException(msg);
        }
        if (start == null) {
            this.mStart = 0L;
            this.mPos = 0L;
        } else {
            this.mStart = start;
            this.mPos = start;
        }
        if (end == null) {
            this.mEnd = this.mRawSize;
        } else {
            if (end > this.mRawSize) {
                String msg = String.format("End index %d for %s exceeded file size %d", end, file.getPath(), this.mRawSize);
                throw new IOException(msg);
            }
            this.mEnd = end;
        }
        sLog.debug("Created %s: file=%s, length=%d, uncompressed length=%d, start=%d, end=%d, parent=%s, mStart=%d, mEnd=%d.", this, file.getPath(), file.length(), this.mRawSize, start, end, parent, this.mStart, this.mEnd);
    }

    public static void setFileDescriptorCache(FileDescriptorCache fdcache) {
        mFileDescriptorCache = fdcache;
    }

    public static FileDescriptorCache getFileDescriptorCache() {
        return mFileDescriptorCache;
    }

    public void closeFile() {
        BlobInputStream.getFileDescriptorCache().close(this.mRoot.mFile.getPath());
    }

    public void fileMoved(File newFile) {
        this.closeFile();
        this.mRoot.mFile = newFile;
    }

    public int available() {
        return (int)(this.mEnd - this.mPos);
    }

    public void close() {
        this.mPos = this.mEnd;
    }

    public synchronized void mark(int readlimit) {
        this.mMarkPos = this.mPos;
        this.mMarkReadLimit = readlimit;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this.mPos >= this.mEnd) {
            return -1;
        }
        int retVal = BlobInputStream.getFileDescriptorCache().read(this.mRoot.mFile.getPath(), this.mRawSize, this.mPos);
        if (retVal >= 0) {
            ++this.mPos;
        } else {
            this.close();
        }
        return retVal;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.mPos >= this.mEnd) {
            return -1;
        }
        if (len <= 0) {
            return 0;
        }
        len = (int)Math.min((long)len, this.mEnd - this.mPos);
        int numRead = BlobInputStream.getFileDescriptorCache().read(this.mRoot.mFile.getPath(), this.mRawSize, this.mPos, b, off, len);
        if (numRead > 0) {
            this.mPos += (long)numRead;
        } else {
            this.close();
        }
        return numRead;
    }

    public synchronized void reset() throws IOException {
        if (this.mMarkPos == null) {
            throw new IOException("reset() called before mark()");
        }
        if (this.mPos - this.mMarkPos > (long)this.mMarkReadLimit) {
            throw new IOException("Mark position was invalidated because more than " + this.mMarkReadLimit + " bytes were read.");
        }
        this.mPos = this.mMarkPos;
    }

    public long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        long newPos = Math.min(this.mPos + n, this.mEnd);
        long numSkipped = newPos - this.mPos;
        this.mPos = newPos;
        return numSkipped;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public long getPosition() {
        return this.mPos - this.mStart;
    }

    public InputStream newStream(long start, long end) {
        if (start < 0L) {
            throw new IllegalArgumentException("start cannot be less than 0");
        }
        start += this.mStart;
        end = end < 0L ? this.mEnd : (end += this.mStart);
        BlobInputStream newStream = null;
        try {
            newStream = new BlobInputStream(null, this.mRawSize, start, end, this);
        }
        catch (IOException e) {
            sLog.warn("Unable to create substream for %s", (Object)this.mRoot.mFile.getPath(), e);
        }
        return newStream;
    }
}

