/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.store.StorageCallback;
import com.zimbra.cs.store.StoreManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.GZIPOutputStream;

public class BlobBuilder {
    protected Blob blob;
    private long sizeHint;
    protected boolean disableCompression;
    private boolean disableDigest;
    private StorageCallback storageCallback;
    private MessageDigest digest;
    private OutputStream out;
    private FileChannel fc;
    private long totalBytes;
    private boolean finished;
    private static final int BUFLEN = Math.max(LC.zimbra_store_copy_buffer_size_kb.intValue(), 1) * 1024;

    protected BlobBuilder(Blob targetBlob) {
        this.blob = targetBlob;
    }

    public BlobBuilder setSizeHint(long size) {
        this.sizeHint = size;
        return this;
    }

    public long getSizeHint() {
        return this.sizeHint;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public BlobBuilder setStorageCallback(StorageCallback callback) {
        this.storageCallback = callback;
        return this;
    }

    public BlobBuilder disableCompression(boolean disable) {
        this.disableCompression = disable;
        return this;
    }

    public BlobBuilder disableDigest(boolean disable) {
        this.disableDigest = disable;
        return this;
    }

    public BlobBuilder init() throws IOException, ServiceException {
        if (!this.disableDigest) {
            try {
                this.digest = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw ServiceException.FAILURE("SHA1 digest not found", e);
            }
        }
        FileOutputStream fos = new FileOutputStream(this.blob.getFile());
        this.fc = fos.getChannel();
        if (this.useCompression(this.sizeHint)) {
            try {
                this.out = new GZIPOutputStream(fos);
            }
            catch (IOException e) {
                this.dispose();
                throw e;
            }
            this.blob.setCompressed(true);
        } else {
            this.out = fos;
            this.blob.setCompressed(false);
        }
        return this;
    }

    protected boolean useCompression(long size) throws ServiceException {
        return false;
    }

    public BlobBuilder append(InputStream in) throws IOException {
        int numRead;
        byte[] buffer = new byte[BUFLEN];
        while ((numRead = in.read(buffer)) >= 0) {
            this.append(buffer, 0, numRead);
        }
        return this;
    }

    public BlobBuilder append(byte[] b) throws IOException {
        return this.append(b, 0, b.length);
    }

    public BlobBuilder append(byte[] b, int off, int len) throws IOException {
        if (this.finished) {
            throw new IllegalStateException("BlobBuilder is finished");
        }
        this.checkInitialized();
        try {
            this.out.write(b, off, len);
            if (this.storageCallback != null) {
                this.storageCallback.wrote(this.blob, b, off, len);
            }
            if (this.digest != null) {
                this.digest.update(b, off, len);
            }
            this.totalBytes += (long)len;
        }
        catch (IOException e) {
            this.dispose();
            throw e;
        }
        return this;
    }

    public BlobBuilder append(ByteBuffer bb) throws IOException {
        if (!bb.hasArray()) {
            throw new IllegalArgumentException("ByteBuffer must have backing array");
        }
        this.append(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        bb.position(bb.limit());
        return this;
    }

    private void checkInitialized() throws IOException {
        if (this.out == null) {
            try {
                this.init();
            }
            catch (Exception e) {
                throw (IOException)new IOException("Unable to initialize BlobBuilder").initCause(e);
            }
        }
    }

    public Blob finish() throws IOException, ServiceException {
        if (this.finished) {
            return this.blob;
        }
        try {
            block7: {
                try {
                    if (DebugConfig.disableMessageStoreFsync) break block7;
                    this.out.flush();
                    this.fc.force(true);
                }
                catch (IOException e) {
                    this.dispose();
                    throw e;
                }
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            ByteUtil.closeStream(this.out);
            throw throwable;
        }
        ByteUtil.closeStream(this.out);
        if (this.digest != null) {
            this.blob.setDigest(ByteUtil.encodeFSSafeBase64(this.digest.digest()));
            this.blob.setRawSize(this.totalBytes);
        }
        if (ZimbraLog.store.isDebugEnabled()) {
            ZimbraLog.store.debug("stored " + this);
        }
        this.finished = true;
        return this.blob;
    }

    public String toString() {
        File file = this.blob.getFile();
        String compressed = "???";
        try {
            compressed = Boolean.toString(this.blob.isCompressed());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.getAbsolutePath() + ": data size=" + this.totalBytes + ", file size=" + file.length() + ", isCompressed=" + compressed;
    }

    public Blob getBlob() {
        if (!this.finished) {
            throw new IllegalStateException("Blob builder not finished");
        }
        return this.blob;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void dispose() {
        if (this.blob != null) {
            this.finished = true;
            ByteUtil.closeStream(this.out);
            StoreManager.getInstance().quietDelete(this.blob);
            this.blob = null;
        }
    }
}

