/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.store;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.GZIPInputStream;

public class Blob {
    private File mFile;
    private String mPath;
    private Boolean mIsCompressed = null;
    private String mDigest;
    private Long mRawSize;

    protected Blob(File file) {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        this.mFile = file;
        this.mPath = file.getAbsolutePath();
    }

    public File getFile() {
        return this.mFile;
    }

    public String getPath() {
        return this.mPath;
    }

    public InputStream getInputStream() throws IOException {
        InputStream in = new FileInputStream(this.mFile);
        if (this.isCompressed()) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    public boolean isCompressed() throws IOException {
        if (this.mIsCompressed == null) {
            this.mIsCompressed = this.mRawSize != null && this.mRawSize.longValue() == this.mFile.length() ? Boolean.FALSE : Boolean.valueOf(FileUtil.isGzipped(this.mFile));
        }
        return this.mIsCompressed;
    }

    public String getDigest() throws IOException {
        if (this.mDigest == null) {
            this.initializeSizeAndDigest();
        }
        return this.mDigest;
    }

    public long getRawSize() throws IOException {
        if (this.mRawSize == null) {
            if (!this.isCompressed()) {
                this.mRawSize = this.mFile.length();
            } else {
                this.initializeSizeAndDigest();
            }
        }
        return this.mRawSize;
    }

    private void initializeSizeAndDigest() throws IOException {
        InputStream in = null;
        try {
            try {
                int numBytes;
                in = this.getInputStream();
                MessageDigest md = MessageDigest.getInstance("SHA1");
                byte[] buffer = new byte[1024];
                long totalBytes = 0L;
                while ((numBytes = in.read(buffer)) >= 0) {
                    md.update(buffer, 0, numBytes);
                    totalBytes += (long)numBytes;
                }
                byte[] digest = md.digest();
                this.mDigest = ByteUtil.encodeFSSafeBase64(digest);
                this.mRawSize = totalBytes;
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            ByteUtil.closeStream(in);
            throw throwable;
        }
        ByteUtil.closeStream(in);
    }

    public Blob setCompressed(boolean isCompressed) {
        this.mIsCompressed = isCompressed;
        return this;
    }

    public Blob setDigest(String digest) {
        this.mDigest = digest;
        return this;
    }

    public Blob setRawSize(long rawSize) {
        this.mRawSize = rawSize;
        return this;
    }

    public Blob copyCachedDataFrom(Blob other) {
        if (this.mIsCompressed == null && other.mIsCompressed != null) {
            this.mIsCompressed = other.mIsCompressed;
        }
        if (this.mDigest == null && other.mDigest != null) {
            this.mDigest = other.mDigest;
        }
        if (this.mRawSize == null && other.mRawSize != null) {
            this.mRawSize = other.mRawSize;
        }
        return this;
    }

    public boolean renameTo(String path) {
        if (this.mPath.equals(path)) {
            return false;
        }
        File newFile = new File(path);
        if (this.mFile.renameTo(newFile)) {
            this.mPath = path;
            this.mFile = newFile;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Blob: { path=" + this.mPath + ", size=" + this.mRawSize + ", compressed=" + this.mIsCompressed + " }";
    }
}

