/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.stats;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.stats.StatsDumperDataSource;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadStats
implements StatsDumperDataSource {
    private String mFilename;

    public ThreadStats(String filename) {
        this.mFilename = filename;
    }

    @Override
    public String getFilename() {
        return this.mFilename;
    }

    @Override
    public String getHeader() {
        return StringUtil.join(",", this.getThreadNamePrefixes()) + ",other,total";
    }

    @Override
    public Collection<String> getDataLines() {
        String[] threadNamePrefixes = this.getThreadNamePrefixes();
        LinkedHashMap<String, Integer> threadCount = new LinkedHashMap<String, Integer>();
        for (String prefix : threadNamePrefixes) {
            threadCount.put(prefix, 0);
        }
        threadCount.put("other", 0);
        ThreadGroup root = Thread.currentThread().getThreadGroup().getParent();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        Thread[] threads = new Thread[root.activeCount() * 2];
        int numThreads = root.enumerate(threads, true);
        for (int i = 0; i < numThreads; ++i) {
            Thread thread = threads[i];
            String threadName = thread.getName();
            boolean found = false;
            for (String prefix : threadNamePrefixes) {
                if (threadName == null || !threadName.startsWith(prefix)) continue;
                threadCount.put(prefix, (Integer)threadCount.get(prefix) + 1);
                found = true;
                break;
            }
            if (found) continue;
            threadCount.put("other", (Integer)threadCount.get("other") + 1);
        }
        StringBuilder buf = new StringBuilder();
        for (String prefix : threadCount.keySet()) {
            buf.append(threadCount.get(prefix));
            buf.append(',');
        }
        buf.append(numThreads);
        ArrayList<String> retVal = new ArrayList<String>(1);
        retVal.add(buf.toString());
        return retVal;
    }

    @Override
    public boolean hasTimestampColumn() {
        return true;
    }

    private String[] getThreadNamePrefixes() {
        try {
            return Provisioning.getInstance().getLocalServer().getStatThreadNamePrefix();
        }
        catch (ServiceException e) {
            ZimbraLog.perf.warn((Object)"Unable to determine thread name prefixes.", e);
            return new String[0];
        }
    }
}

