/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.stats;

import com.zimbra.common.stats.RealtimeStatsCallback;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.mailbox.MessageCache;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.cs.store.BlobInputStream;
import com.zimbra.cs.store.FileDescriptorCache;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerStatsCallback
implements RealtimeStatsCallback {
    @Override
    public Map<String, Object> getStatData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("mbox_cache_size", ZimbraPerf.getMailboxCacheSize());
        data.put("msg_cache_size", MessageCache.getSize());
        data.put("msg_cache_bytes", MessageCache.getDataSize());
        FileDescriptorCache fdc = BlobInputStream.getFileDescriptorCache();
        data.put("fd_cache_size", fdc.getSize());
        data.put("fd_cache_hit_rate", fdc.getHitRate());
        Provisioning prov = Provisioning.getInstance();
        if (prov instanceof LdapProvisioning) {
            LdapProvisioning ldap = (LdapProvisioning)prov;
            data.put("account_cache_size", ldap.getAccountCacheSize());
            data.put("account_cache_hit_rate", ldap.getAccountCacheHitRate());
            data.put("cos_cache_size", ldap.getCosCacheSize());
            data.put("cos_cache_hit_rate", ldap.getCosCacheHitRate());
            data.put("domain_cache_size", ldap.getDomainCacheSize());
            data.put("domain_cache_hit_rate", ldap.getDomainCacheHitRate());
            data.put("server_cache_size", ldap.getServerCacheSize());
            data.put("server_cache_hit_rate", ldap.getServerCacheHitRate());
            data.put("zimlet_cache_size", ldap.getZimletCacheSize());
            data.put("zimlet_cache_hit_rate", ldap.getZimletCacheHitRate());
            data.put("group_cache_size", ldap.getGroupCacheSize());
            data.put("group_cache_hit_rate", ldap.getGroupCacheHitRate());
            data.put("xmpp_cache_size", ldap.getXMPPCacheSize());
            data.put("xmpp_cache_hit_rate", ldap.getXMPPCacheHitRate());
        }
        return data;
    }
}

