/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.stats;

import com.zimbra.common.stats.Accumulator;
import com.zimbra.common.stats.DeltaCalculator;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.mailbox.MessageCache;
import com.zimbra.cs.stats.JmxServerStatsMBean;
import com.zimbra.cs.stats.ZimbraPerf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JmxServerStats
implements JmxServerStatsMBean {
    private DeltaCalculator mDbConn = new DeltaCalculator(ZimbraPerf.STOPWATCH_DB_CONN);
    private DeltaCalculator mLdapConn = new DeltaCalculator(ZimbraPerf.STOPWATCH_LDAP_DC);
    private DeltaCalculator mItemCache = new DeltaCalculator(ZimbraPerf.COUNTER_MBOX_ITEM_CACHE);
    private DeltaCalculator mMailboxCache = new DeltaCalculator(ZimbraPerf.COUNTER_MBOX_CACHE);
    private DeltaCalculator mMessageCache = new DeltaCalculator(ZimbraPerf.COUNTER_MBOX_MSG_CACHE);
    private DeltaCalculator mAddMessage = new DeltaCalculator(ZimbraPerf.STOPWATCH_MBOX_ADD_MSG);
    private DeltaCalculator mImap = new DeltaCalculator(ZimbraPerf.STOPWATCH_IMAP);
    private DeltaCalculator mPop = new DeltaCalculator(ZimbraPerf.STOPWATCH_POP);
    private DeltaCalculator mSoap = new DeltaCalculator(ZimbraPerf.STOPWATCH_SOAP);
    private DeltaCalculator mBisSeek = new DeltaCalculator(ZimbraPerf.COUNTER_BLOB_INPUT_STREAM_SEEK_RATE);
    private final List<Accumulator> mAccumulators;

    JmxServerStats() {
        ArrayList<DeltaCalculator> accumulators = new ArrayList<DeltaCalculator>();
        accumulators.add(this.mDbConn);
        accumulators.add(this.mLdapConn);
        accumulators.add(this.mItemCache);
        accumulators.add(this.mMailboxCache);
        accumulators.add(this.mMessageCache);
        accumulators.add(this.mAddMessage);
        accumulators.add(this.mImap);
        accumulators.add(this.mPop);
        accumulators.add(this.mSoap);
        accumulators.add(this.mBisSeek);
        this.mAccumulators = Collections.unmodifiableList(accumulators);
    }

    public long getDatabaseConnectionGets() {
        return ZimbraPerf.STOPWATCH_DB_CONN.getCount();
    }

    public long getDatabaseConnectionGetMs() {
        return (long)this.mDbConn.getRealtimeAverage();
    }

    public long getDatabaseConnectionsInUse() {
        return DbPool.getSize();
    }

    public long getLdapDirectoryContextGetMs() {
        return (long)this.mLdapConn.getRealtimeAverage();
    }

    public long getLdapDirectoryContextGets() {
        return ZimbraPerf.STOPWATCH_LDAP_DC.getCount();
    }

    public long getLmtpDeliveredBytes() {
        return ZimbraPerf.COUNTER_LMTP_DLVD_BYTES.getTotal();
    }

    public long getLmtpReceivedBytes() {
        return ZimbraPerf.COUNTER_LMTP_RCVD_BYTES.getTotal();
    }

    public long getLmtpDeliveredMessages() {
        return ZimbraPerf.COUNTER_LMTP_DLVD_MSGS.getTotal();
    }

    public long getLmtpReceivedMessages() {
        return ZimbraPerf.COUNTER_LMTP_RCVD_MSGS.getTotal();
    }

    public long getLmtpRecipients() {
        return ZimbraPerf.COUNTER_LMTP_RCVD_RCPT.getTotal();
    }

    public long getImapRequests() {
        return ZimbraPerf.STOPWATCH_IMAP.getCount();
    }

    public long getItemCacheHitRate() {
        return (long)this.mItemCache.getRealtimeAverage();
    }

    public long getMailboxCacheHitRate() {
        return (long)this.mMailboxCache.getRealtimeAverage();
    }

    public long getMailboxCacheSize() {
        return ZimbraPerf.getMailboxCacheSize();
    }

    public long getMailboxGets() {
        return ZimbraPerf.STOPWATCH_MBOX_GET.getCount();
    }

    public long getMailboxGetMs() {
        return (long)this.mMailboxCache.getRealtimeAverage();
    }

    public long getMessageAddMs() {
        return (long)this.mAddMessage.getRealtimeAverage();
    }

    public long getMessageCacheSize() {
        return MessageCache.getSize();
    }

    public long getMessageCacheHitRate() {
        return (long)this.mMessageCache.getRealtimeAverage();
    }

    public long getMessagesAdded() {
        return ZimbraPerf.STOPWATCH_MBOX_ADD_MSG.getCount();
    }

    public long getSoapRequests() {
        return ZimbraPerf.STOPWATCH_SOAP.getCount();
    }

    public long getSoapResponseMs() {
        return (long)this.mSoap.getRealtimeAverage();
    }

    public long getBlobInputStreamReads() {
        return ZimbraPerf.COUNTER_BLOB_INPUT_STREAM_READ.getCount();
    }

    public long getBlobInputStreamSeekRate() {
        return (long)this.mBisSeek.getRealtimeAverage();
    }

    public long getImapResponseMs() {
        return (long)this.mImap.getRealtimeAverage();
    }

    public long getPopRequests() {
        return ZimbraPerf.STOPWATCH_POP.getCount();
    }

    public long getPopResponseMs() {
        return (long)this.mPop.getRealtimeAverage();
    }

    public void reset() {
        for (Accumulator accum : this.mAccumulators) {
            accum.reset();
        }
    }
}

