/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.stats;

import com.zimbra.common.stats.Counter;
import com.zimbra.common.stats.StatsDumperDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityTracker
implements StatsDumperDataSource {
    private String mFilename;
    private ConcurrentHashMap<String, Counter> mCounterMap = new ConcurrentHashMap();

    public ActivityTracker(String filename) {
        this.mFilename = filename;
    }

    public void addStat(String commandName, long startTime) {
        Counter counter = this.getCounter(commandName);
        counter.increment(System.currentTimeMillis() - startTime);
    }

    private Counter getCounter(String commandName) {
        Counter previousCounter;
        Counter counter = this.mCounterMap.get(commandName);
        if (counter == null && (previousCounter = this.mCounterMap.putIfAbsent(commandName, counter = new Counter())) != null) {
            counter = previousCounter;
        }
        return counter;
    }

    @Override
    public Collection<String> getDataLines() {
        if (this.mCounterMap == null || this.mCounterMap.size() == 0) {
            return null;
        }
        ArrayList<String> dataLines = new ArrayList<String>(this.mCounterMap.size());
        for (String command : this.mCounterMap.keySet()) {
            Counter counter = this.mCounterMap.get(command);
            if (counter.getCount() <= 0L) continue;
            long count = counter.getCount();
            long avg = (long)counter.getAverage();
            counter.reset();
            dataLines.add(String.format("%s,%d,%d", command, count, avg));
        }
        return dataLines;
    }

    @Override
    public String getFilename() {
        return this.mFilename;
    }

    @Override
    public String getHeader() {
        return "command,exec_count,exec_ms_avg";
    }

    @Override
    public boolean hasTimestampColumn() {
        return true;
    }
}

