/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.session;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.service.formatter.WikiFormatter;
import com.zimbra.cs.session.PendingModifications;
import com.zimbra.cs.session.Session;

public class WikiSession
extends Session {
    private static WikiSession sSession;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WikiSession getInstance() throws ServiceException {
        Class<WikiSession> clazz = WikiSession.class;
        synchronized (WikiSession.class) {
            if (sSession == null) {
                Provisioning prov = Provisioning.getInstance();
                Config globalConfig = prov.getConfig();
                String defaultAcct = globalConfig.getAttr("zimbraNotebookAccount");
                if (defaultAcct == null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return null;
                }
                Account acct = prov.get(Provisioning.AccountBy.name, defaultAcct);
                sSession = new WikiSession(acct.getId());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sSession;
        }
    }

    private WikiSession(String accountId) {
        super(accountId, Session.Type.WIKI);
    }

    protected boolean isMailboxListener() {
        return false;
    }

    protected boolean isRegisteredInCache() {
        return false;
    }

    public Session register() {
        return this;
    }

    protected void cleanup() {
    }

    protected long getSessionIdleLifetime() {
        return 0L;
    }

    public void notifyPendingChanges(PendingModifications pns, int changeId, Session source) {
        if (pns.modified != null && pns.modified.size() > 0) {
            for (PendingModifications.Change change : pns.modified.values()) {
                this.expireItem(change.what);
            }
        }
        if (pns.deleted != null && pns.deleted.size() > 0) {
            for (Object object : pns.deleted.values()) {
                this.expireItem(object);
            }
        }
    }

    private void expireItem(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Document) {
            WikiFormatter.expireCache();
        }
        if (obj instanceof Folder) {
            WikiFormatter.expireCache();
        }
        if (obj instanceof Mailbox) {
            WikiFormatter.expireCache();
        }
    }

    public void addMailboxForNotification(Mailbox mbox) throws ServiceException {
        if (mbox != null) {
            mbox.addListener(this);
        }
    }
}

