/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.session;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.zclient.ZClientException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaitSetValidator
implements SoapTransport.DebugListener {
    private long mSendStart;
    private int mTimeout = -1;
    private int mRetryCount = -1;
    private SoapHttpTransport mTransport;
    private ZAuthToken mAuthToken;
    private long mAuthTokenLifetime;
    private long mAuthTokenExpiration;
    private SoapTransport.DebugListener mDebugListener = null;

    void setVerbose(boolean value) {
        this.mDebugListener = value ? this : null;
    }

    void soapSetURI(String uri) {
        if (this.mTransport != null) {
            this.mTransport.shutdown();
        }
        this.mTransport = new SoapHttpTransport(uri);
        if (this.mTimeout >= 0) {
            this.mTransport.setTimeout(this.mTimeout);
        }
        if (this.mRetryCount > 0) {
            this.mTransport.setRetryCount(this.mRetryCount);
        }
        if (this.mAuthToken != null) {
            this.mTransport.setAuthToken(this.mAuthToken);
        }
        if (this.mDebugListener != null) {
            this.mTransport.setDebugListener(this.mDebugListener);
        }
    }

    private String serverName() {
        try {
            return new URI(this.mTransport.getURI()).getHost();
        }
        catch (URISyntaxException e) {
            return this.mTransport.getURI();
        }
    }

    private void checkTransport() throws ServiceException {
        if (this.mTransport == null) {
            throw ServiceException.FAILURE("transport has not been initialized", null);
        }
    }

    protected Element invoke(Element request) throws ServiceException {
        this.checkTransport();
        try {
            return this.mTransport.invoke(request);
        }
        catch (SoapFaultException e) {
            throw e;
        }
        catch (IOException e) {
            throw ZClientException.IO_ERROR("invoke " + e.getMessage() + ", server: " + this.serverName(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Element invokeOnTargetAccount(Element request, String targetId) throws ServiceException {
        Element element;
        this.checkTransport();
        String oldTarget = this.mTransport.getTargetAcctId();
        try {
            try {
                this.mTransport.setTargetAcctId(targetId);
                element = this.mTransport.invoke(request);
                Object var6_7 = null;
            }
            catch (SoapFaultException e) {
                throw e;
            }
            catch (IOException e) {
                throw ZClientException.IO_ERROR("invoke " + e.getMessage() + ", server: " + this.serverName(), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.mTransport.setTargetAcctId(oldTarget);
            throw throwable;
        }
        this.mTransport.setTargetAcctId(oldTarget);
        return element;
    }

    protected Element invokeQueryWaitSet(String id) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.QUERY_WAIT_SET_REQUEST);
        req.addAttribute("waitSet", id);
        Element response = this.invoke(req);
        return response;
    }

    protected List<WaitSetSession> queryWaitSet(String id) throws ServiceException {
        Element qws = this.invokeQueryWaitSet(id);
        ArrayList<WaitSetSession> toRet = new ArrayList<WaitSetSession>();
        Iterator<Element> iter = qws.elementIterator("session");
        while (iter.hasNext()) {
            Element selt = iter.next();
            WaitSetSession wss = new WaitSetSession();
            wss.accountId = selt.getAttribute("account");
            wss.token = selt.getAttribute("token", null);
            toRet.add(wss);
        }
        return toRet;
    }

    protected boolean validateSessionStatus(WaitSetSession wss) throws ServiceException {
        Element.XMLElement req = new Element.XMLElement(MailConstants.SYNC_REQUEST);
        req.addAttribute("token", wss.token);
        Element syncResponse = this.invokeOnTargetAccount(req, wss.accountId);
        String newToken = syncResponse.getAttribute("token");
        String md = syncResponse.getAttribute("md");
        long diff = Long.parseLong(newToken) - Long.parseLong(wss.token);
        if (!newToken.equals(wss.token) && diff > 10L) {
            System.out.println("ERROR: Account " + wss.accountId + " -- old token " + wss.token + " doesn't match new token: " + newToken + " md=" + md + " Difference=" + diff);
            return false;
        }
        System.out.println("Account " + wss.accountId + " diff=" + diff + " -- OK");
        return true;
    }

    public void soapAdminAuthenticate(String name, String password) throws ServiceException {
        if (this.mTransport == null) {
            throw ZClientException.CLIENT_ERROR("must call setURI before calling adminAuthenticate", null);
        }
        Element.XMLElement req = new Element.XMLElement(AdminConstants.AUTH_REQUEST);
        req.addElement("name").setText(name);
        req.addElement("password").setText(password);
        Element response = this.invoke(req);
        this.mAuthToken = new ZAuthToken(response.getElement("authToken"), true);
        this.mAuthTokenLifetime = response.getAttributeLong("lifetime");
        this.mAuthTokenExpiration = System.currentTimeMillis() + this.mAuthTokenLifetime;
        this.mTransport.setAuthToken(this.mAuthToken);
    }

    @Override
    public void receiveSoapMessage(Element envelope) {
        long end = System.currentTimeMillis();
        System.out.printf("======== SOAP RECEIVE =========\n", new Object[0]);
        System.out.println(envelope.prettyPrint());
        System.out.printf("=============================== (%d msecs)\n", end - this.mSendStart);
    }

    @Override
    public void sendSoapMessage(Element envelope) {
        this.mSendStart = System.currentTimeMillis();
        System.out.println("========== SOAP SEND ==========");
        System.out.println(envelope.prettyPrint());
        System.out.println("===============================");
    }

    void usage() {
        System.out.println("");
        System.out.println("testwaitset -i waitsetid [-u admin_user] [-p password] [-h host]");
        System.exit(1);
    }

    private static void printError(String text) {
        PrintStream ps = System.err;
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)ps, "UTF-8"));
            writer.write(text + "\n");
            writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            ps.println(text);
        }
        catch (IOException e) {
            ps.println(text);
        }
    }

    void run(String id, String host, String user, String pw) {
        try {
            this.soapSetURI(host);
            this.soapAdminAuthenticate(user, pw);
            List<WaitSetSession> wss = this.queryWaitSet(id);
            boolean hasFailures = false;
            for (WaitSetSession w : wss) {
                if (this.validateSessionStatus(w)) continue;
                hasFailures = true;
            }
            if (hasFailures) {
                Element qws = this.invokeQueryWaitSet(id);
                System.out.println(qws.prettyPrint());
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
            System.out.println("Caught exception: " + e);
        }
    }

    public static void main(String[] args) {
        String[] ids;
        String[] hosts;
        CliUtil.toolSetup();
        WaitSetValidator t = new WaitSetValidator();
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("i", "id", true, "Wait Set ID");
        options.addOption("h", "host", true, "Hostname");
        options.addOption("u", "user", true, "Username");
        options.addOption("p", "pw", true, "Password");
        options.addOption("?", "help", false, "Help");
        options.addOption("v", "verbose", false, "Verbose");
        CommandLine cl = null;
        boolean err = false;
        try {
            cl = parser.parse(options, args, true);
        }
        catch (ParseException pe) {
            WaitSetValidator.printError("error: " + pe.getMessage());
            err = true;
        }
        if (err || cl.hasOption('?')) {
            t.usage();
        }
        String id = null;
        String host = null;
        String user = null;
        String pw = null;
        if (!cl.hasOption('i')) {
            t.usage();
        }
        id = cl.getOptionValue('i');
        host = cl.hasOption('h') ? cl.getOptionValue('h') : "http://localhost:7071/service/admin";
        user = cl.hasOption('u') ? cl.getOptionValue('u') : "admin";
        pw = cl.hasOption('p') ? cl.getOptionValue('p') : "test123";
        if (cl.hasOption('v')) {
            t.setVerbose(true);
        }
        if ((hosts = host.split(",")).length != (ids = id.split(",")).length) {
            System.err.println("If multiple hosts or ids are specified, the same number is required of each");
            System.exit(3);
        }
        for (int i = 0; i < hosts.length; ++i) {
            if (i > 0) {
                System.out.println("\n\n");
            }
            System.out.println("Checking server " + hosts[i] + " waitsetId=" + ids[i]);
            t.run(ids[i], hosts[i], user, pw);
        }
    }

    static class WaitSetSession {
        public String accountId;
        public String token;

        WaitSetSession() {
        }
    }
}

