/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.session;

import com.zimbra.cs.service.util.SyncToken;
import com.zimbra.cs.session.PendingModifications;
import com.zimbra.cs.session.Session;
import com.zimbra.cs.session.SomeAccountsWaitSet;

public class WaitSetSession
extends Session {
    SomeAccountsWaitSet mWs = null;
    int mInterestMask;
    int mHighestChangeId;
    SyncToken mSyncToken;

    WaitSetSession(SomeAccountsWaitSet ws, String accountId, int interestMask, SyncToken lastKnownSyncToken) {
        super(accountId, Session.Type.WAITSET);
        this.mWs = ws;
        this.mInterestMask = interestMask;
        this.mSyncToken = lastKnownSyncToken;
    }

    protected boolean isMailboxListener() {
        return true;
    }

    protected boolean isRegisteredInCache() {
        return false;
    }

    void update(int interestMask, SyncToken lastKnownSyncToken) {
        this.mInterestMask = interestMask;
        this.mSyncToken = lastKnownSyncToken;
        if (this.mSyncToken != null) {
            int mboxHighestChange = this.getMailbox().getLastChangeID();
            if (mboxHighestChange > this.mHighestChangeId) {
                this.mHighestChangeId = mboxHighestChange;
            }
            if (this.mSyncToken.after(this.mHighestChangeId)) {
                this.mWs.unsignalDataReady(this);
            } else {
                this.mWs.signalDataReady(this);
            }
        }
    }

    protected void cleanup() {
        this.mWs.cleanupSession(this);
    }

    protected long getSessionIdleLifetime() {
        return 0L;
    }

    public void notifyPendingChanges(PendingModifications pns, int changeId, Session source) {
        if (changeId > this.mHighestChangeId) {
            this.mHighestChangeId = changeId;
        }
        if (this.mSyncToken != null && this.mSyncToken.after(this.mHighestChangeId)) {
            return;
        }
        if ((this.mInterestMask & pns.changedTypes) != 0) {
            this.mWs.signalDataReady(this);
        }
    }
}

