/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.session;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.session.AllAccountsWaitSet;
import com.zimbra.cs.session.IWaitSet;
import com.zimbra.cs.session.SomeAccountsWaitSet;
import com.zimbra.cs.session.WaitSetAccount;
import com.zimbra.cs.session.WaitSetBase;
import com.zimbra.cs.session.WaitSetError;
import com.zimbra.cs.util.Zimbra;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaitSetMgr {
    public static final String ALL_ACCOUNTS_ID_PREFIX = "AllWaitSet-";
    private static final int MAX_WAITSETS_PER_NONADMIN_ACCOUNT = LC.zimbra_waitset_max_per_account.intValueWithinRange(1, Integer.MAX_VALUE);
    private static final TimerTask sSweeper = new TimerTask(){

        public void run() {
            try {
                WaitSetMgr.sweep();
            }
            catch (OutOfMemoryError e) {
                Zimbra.halt("out of memory", e);
            }
            catch (Throwable e) {
                if (e instanceof OutOfMemoryError) {
                    Zimbra.halt("Caught out of memory error", e);
                }
                ZimbraLog.session.warn((Object)"Caught exception in WaitSetMgr timer", e);
            }
        }
    };
    private static final HashMap<String, WaitSetBase> sWaitSets = new HashMap();
    private static final HashMap<String, List<String>> sWaitSetsByAccountId = new HashMap();
    private static final int WAITSET_SWEEP_DELAY = 60000;
    private static final int WAITSET_TIMEOUT = 1200000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<String, List<WaitSetError>> create(String ownerAccountId, boolean allowMultiple, int defaultInterest, boolean allAccts, List<WaitSetAccount> add) throws ServiceException {
        HashMap<String, WaitSetBase> hashMap = sWaitSets;
        synchronized (hashMap) {
            WaitSetBase ws;
            List<String> list;
            if (!allowMultiple && (list = sWaitSetsByAccountId.get(ownerAccountId)) != null && list.size() >= MAX_WAITSETS_PER_NONADMIN_ACCOUNT) {
                long oldestTime = Long.MAX_VALUE;
                String oldestId = null;
                for (String wsid : list) {
                    WaitSetBase ws2 = WaitSetMgr.lookupInternal(wsid);
                    long time = ws2.getLastAccessedTime();
                    if (time >= oldestTime) continue;
                    oldestTime = time;
                    oldestId = wsid;
                }
                WaitSetMgr.destroy(ownerAccountId, oldestId);
            }
            String id = allAccts ? ALL_ACCOUNTS_ID_PREFIX + LdapUtil.generateUUID() : "WaitSet-" + LdapUtil.generateUUID();
            List<Object> errors = null;
            if (allAccts) {
                AllAccountsWaitSet aws;
                ws = aws = AllAccountsWaitSet.create(ownerAccountId, id, defaultInterest);
                errors = new ArrayList();
            } else {
                SomeAccountsWaitSet sws = new SomeAccountsWaitSet(ownerAccountId, id, defaultInterest);
                errors = sws.addAccounts(add);
                MailboxManager.getInstance().addListener(sws);
                ws = sws;
            }
            ws.setLastAccessedTime(System.currentTimeMillis());
            sWaitSets.put(id, ws);
            List<String> list2 = sWaitSetsByAccountId.get(ownerAccountId);
            if (list2 == null) {
                list2 = new ArrayList<String>();
                sWaitSetsByAccountId.put(ownerAccountId, list2);
            }
            list2.add(id);
            return new Pair<String, List<WaitSetError>>(id, errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(String requestingAcctId, String id) throws ServiceException {
        HashMap<String, WaitSetBase> hashMap = sWaitSets;
        synchronized (hashMap) {
            WaitSetBase ws = WaitSetMgr.lookupInternal(id);
            if (ws == null) {
                throw MailServiceException.NO_SUCH_WAITSET(id);
            }
            assert (!Thread.holdsLock(ws));
            if (!ws.getOwnerAccountId().equals(requestingAcctId)) {
                throw ServiceException.PERM_DENIED("Not the owner: Only the creator/owner may delete a waitset");
            }
            List<String> list = sWaitSetsByAccountId.get(ws.getOwnerAccountId());
            assert (list != null);
            if (list != null) {
                list.remove(id);
                if (list.size() == 0) {
                    sWaitSetsByAccountId.remove(ws.getOwnerAccountId());
                }
            }
            sWaitSets.remove(id);
            HashMap<String, WaitSetAccount> toCleanup = ws.destroy();
            if (toCleanup != null) {
                assert (!Thread.holdsLock(ws));
                for (WaitSetAccount wsa : toCleanup.values()) {
                    wsa.cleanupSession();
                }
            }
        }
    }

    public static IWaitSet lookup(String id) {
        return WaitSetMgr.lookupInternal(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IWaitSet lookupOrCreateForAllAccts(String ownerAccountId, String id, int defaultInterests, String lastKnownSeqNo) throws ServiceException {
        HashMap<String, WaitSetBase> hashMap = sWaitSets;
        synchronized (hashMap) {
            if (!id.startsWith(ALL_ACCOUNTS_ID_PREFIX)) {
                throw ServiceException.INVALID_REQUEST("Called WaitSetMgr.lookupOrCreate but wasn't an 'All-' waitset ID", null);
            }
            IWaitSet toRet = WaitSetMgr.lookup(id);
            if (toRet == null) {
                AllAccountsWaitSet ws = AllAccountsWaitSet.createWithSeqNo(ownerAccountId, id, defaultInterests, lastKnownSeqNo);
                toRet = ws;
                ws.setLastAccessedTime(System.currentTimeMillis());
                sWaitSets.put(id, ws);
                List<String> list = sWaitSetsByAccountId.get(ownerAccountId);
                if (list == null) {
                    list = new ArrayList<String>();
                    sWaitSetsByAccountId.put(ownerAccountId, list);
                }
                list.add(id);
            }
            assert (toRet instanceof AllAccountsWaitSet);
            return toRet;
        }
    }

    public static void shutdown() {
        sSweeper.cancel();
    }

    public static void startup() {
        Zimbra.sTimer.schedule(sSweeper, 60000L, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IWaitSet> getAll() {
        HashMap<String, WaitSetBase> hashMap = sWaitSets;
        synchronized (hashMap) {
            ArrayList<IWaitSet> toRet = new ArrayList<IWaitSet>(sWaitSets.size());
            toRet.addAll(sWaitSets.values());
            return toRet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WaitSetBase lookupInternal(String id) {
        HashMap<String, WaitSetBase> hashMap = sWaitSets;
        synchronized (hashMap) {
            WaitSetBase toRet = sWaitSets.get(id);
            if (toRet != null) {
                assert (!Thread.holdsLock(toRet));
                WaitSetBase waitSetBase = toRet;
                synchronized (waitSetBase) {
                    toRet.setLastAccessedTime(System.currentTimeMillis());
                }
            }
            return toRet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sweep() {
        int activeSets = 0;
        int activeSessions = 0;
        int removed = 0;
        int withCallback = 0;
        HashMap<String, WaitSetBase> hashMap = sWaitSets;
        synchronized (hashMap) {
            long cutoffTime = System.currentTimeMillis() - 1200000L;
            Iterator<WaitSetBase> iter = sWaitSets.values().iterator();
            while (iter.hasNext()) {
                WaitSetBase ws = iter.next();
                assert (!Thread.holdsLock(ws));
                HashMap<String, WaitSetAccount> toCleanup = null;
                WaitSetBase waitSetBase = ws;
                synchronized (waitSetBase) {
                    if (ws.getCb() == null && ws.getLastAccessedTime() < cutoffTime) {
                        List<String> list = sWaitSetsByAccountId.get(ws.getOwnerAccountId());
                        assert (list != null);
                        if (list != null) {
                            list.remove(ws.getWaitSetId());
                            if (list.size() == 0) {
                                sWaitSetsByAccountId.remove(ws.getOwnerAccountId());
                            }
                        }
                        iter.remove();
                        toCleanup = ws.destroy();
                        ++removed;
                    } else {
                        if (ws.getCb() != null) {
                            ++withCallback;
                        }
                        ++activeSets;
                        activeSessions += ws.countSessions();
                    }
                }
                if (toCleanup == null) continue;
                assert (!Thread.holdsLock(ws));
                for (WaitSetAccount wsa : toCleanup.values()) {
                    wsa.cleanupSession();
                }
            }
        }
        if (removed > 0) {
            ZimbraLog.session.info("WaitSet sweeper timing out %d WaitSets due to inactivity", removed);
        }
        if (activeSets > 0) {
            ZimbraLog.session.info("WaitSet sweeper: %d active WaitSets (%d accounts) - %d sets with blocked callbacks", activeSets, activeSessions, withCallback);
        }
    }
}

