/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.session;

import com.zimbra.common.soap.Element;
import com.zimbra.cs.service.mail.WaitSetRequest;
import com.zimbra.cs.session.IWaitSet;
import com.zimbra.cs.session.WaitSetAccount;
import com.zimbra.cs.session.WaitSetCallback;
import com.zimbra.cs.session.WaitSetError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WaitSetBase
implements IWaitSet {
    protected final String mWaitSetId;
    protected final String mOwnerAccountId;
    protected final int mDefaultInterest;
    protected long mLastAccessedTime = -1L;
    protected WaitSetCallback mCb = null;
    protected List<WaitSetError> mCurrentErrors = new ArrayList<WaitSetError>();
    protected List<WaitSetError> mSentErrors = new ArrayList<WaitSetError>();
    protected HashSet<String> mCurrentSignalledSessions = new HashSet();
    protected HashSet<String> mSentSignalledSessions = new HashSet();

    abstract HashMap<String, WaitSetAccount> destroy();

    abstract int countSessions();

    protected abstract boolean cbSeqIsCurrent();

    protected abstract String toNextSeqNo();

    public long getLastAccessedTime() {
        return this.mLastAccessedTime;
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this.mLastAccessedTime = lastAccessedTime;
    }

    @Override
    public int getDefaultInterest() {
        return this.mDefaultInterest;
    }

    @Override
    public String getOwnerAccountId() {
        return this.mOwnerAccountId;
    }

    @Override
    public String getWaitSetId() {
        return this.mWaitSetId;
    }

    synchronized WaitSetCallback getCb() {
        return this.mCb;
    }

    protected synchronized void cancelExistingCB() {
        if (this.mCb != null) {
            this.mCb.dataReady(this, "", true, null, null);
            this.mCb = null;
            this.mLastAccessedTime = System.currentTimeMillis();
        }
    }

    @Override
    public synchronized void doneWaiting() {
        this.mCb = null;
        this.mLastAccessedTime = System.currentTimeMillis();
    }

    protected WaitSetBase(String ownerAccountId, String waitSetId, int defaultInterest) {
        this.mOwnerAccountId = ownerAccountId;
        this.mWaitSetId = waitSetId;
        this.mDefaultInterest = defaultInterest;
    }

    protected synchronized void trySendData() {
        if (this.mCb == null) {
            return;
        }
        boolean cbIsCurrent = this.cbSeqIsCurrent();
        if (cbIsCurrent) {
            this.mSentSignalledSessions.clear();
            this.mSentErrors.clear();
        }
        if (this.mCurrentSignalledSessions.size() > 0 || this.mCurrentErrors.size() > 0 || !cbIsCurrent && (this.mSentSignalledSessions.size() > 0 || this.mSentErrors.size() > 0)) {
            if (this.mSentSignalledSessions.size() == 0) {
                HashSet<String> temp = this.mCurrentSignalledSessions;
                this.mCurrentSignalledSessions = this.mSentSignalledSessions;
                this.mSentSignalledSessions = temp;
            } else {
                assert (!cbIsCurrent);
                this.mSentSignalledSessions.addAll(this.mCurrentSignalledSessions);
                this.mCurrentSignalledSessions.clear();
            }
            this.mSentErrors.addAll(this.mCurrentErrors);
            this.mCurrentErrors.clear();
            assert (this.mSentSignalledSessions.size() > 0 || this.mSentErrors.size() > 0);
            String[] toRet = new String[this.mSentSignalledSessions.size()];
            int i = 0;
            for (String accountId : this.mSentSignalledSessions) {
                toRet[i++] = accountId;
            }
            this.mCb.dataReady(this, this.toNextSeqNo(), false, this.mSentErrors, toRet);
            this.mCb = null;
            this.mLastAccessedTime = System.currentTimeMillis();
        }
    }

    @Override
    public synchronized void handleQuery(Element response) {
        response.addAttribute("id", this.mWaitSetId);
        response.addAttribute("owner", this.mOwnerAccountId);
        response.addAttribute("defTypes", WaitSetRequest.expandInterestStr(this.mDefaultInterest));
        response.addAttribute("ld", this.mLastAccessedTime);
        if (this.mCurrentErrors.size() > 0) {
            Element errors = response.addElement("errors");
            for (WaitSetError error : this.mCurrentErrors) {
                Element errorElt = errors.addElement("error");
                errorElt.addAttribute("id", error.accountId);
                errorElt.addAttribute("type", error.error.name());
            }
        }
        if (this.mCurrentSignalledSessions.size() > 0) {
            Element signaled = response.addElement("ready");
            StringBuilder signaledStr = new StringBuilder();
            for (String accountId : this.mCurrentSignalledSessions) {
                if (signaledStr.length() > 0) {
                    signaledStr.append(",");
                }
                signaledStr.append(accountId);
            }
            signaled.addAttribute("accounts", signaledStr.toString());
        }
    }

    protected synchronized void signalError(WaitSetError err) {
        this.mCurrentErrors.add(err);
        this.trySendData();
    }
}

