/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.session;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.util.SyncToken;
import com.zimbra.cs.session.SomeAccountsWaitSet;
import com.zimbra.cs.session.WaitSetError;
import com.zimbra.cs.session.WaitSetSession;

public class WaitSetAccount {
    private String accountId;
    private int interests;
    private SyncToken lastKnownSyncToken;
    private String sessionId;

    public WaitSetAccount(String id, SyncToken sync, int interest) {
        this.setAccountId(id);
        this.lastKnownSyncToken = sync;
        this.interests = interest;
    }

    public WaitSetSession getSession() {
        if (this.sessionId != null) {
            try {
                Mailbox mbox = this.getMailboxIfLoaded();
                if (mbox != null) {
                    return (WaitSetSession)mbox.getListener(this.sessionId);
                }
            }
            catch (ServiceException e) {
                ZimbraLog.session.info((Object)"Caught exception fetching mailbox in WaitSetAccount.getSession()", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaitSetError createSession(Mailbox mbox, SomeAccountsWaitSet ws) {
        assert (this.sessionId == null);
        WaitSetSession session = new WaitSetSession(ws, this.accountId, this.interests, this.lastKnownSyncToken);
        try {
            Mailbox mailbox = mbox;
            synchronized (mailbox) {
                session.register();
                this.sessionId = session.getSessionId();
                session.update(this.interests, this.lastKnownSyncToken);
            }
        }
        catch (MailServiceException e) {
            this.sessionId = null;
            if (e.getCode().equals("mail.MAINTENANCE")) {
                ZimbraLog.session.debug("Maintenance mode trying to initialize WaitSetSession for accountId " + this.accountId);
            }
            ZimbraLog.session.warn((Object)("Error initializing WaitSetSession for accountId " + this.accountId + " -- MailServiceException"), e);
            return new WaitSetError(this.accountId, WaitSetError.Type.ERROR_LOADING_MAILBOX);
        }
        catch (ServiceException e) {
            this.sessionId = null;
            ZimbraLog.session.warn((Object)("Error initializing WaitSetSession for accountId " + this.accountId + " -- ServiceException"), e);
            return new WaitSetError(this.accountId, WaitSetError.Type.ERROR_LOADING_MAILBOX);
        }
        return null;
    }

    public void cleanupSession() {
        WaitSetSession session = this.getSession();
        if (session != null) {
            this.sessionId = null;
            session.doCleanup();
        }
    }

    public String toString() {
        return "WaitSetAccount(" + this.accountId + ")";
    }

    private Mailbox getMailboxIfLoaded() throws ServiceException {
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(this.accountId, MailboxManager.FetchMode.ONLY_IF_CACHED);
        return mbox;
    }

    void setLastKnownSyncToken(SyncToken lastKnownSyncToken) {
        this.lastKnownSyncToken = lastKnownSyncToken;
    }

    public SyncToken getLastKnownSyncToken() {
        return this.lastKnownSyncToken;
    }

    void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    void setInterests(int interests) {
        this.interests = interests;
    }

    public int getInterests() {
        return this.interests;
    }
}

