/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.session;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.mail.WaitSetRequest;
import com.zimbra.cs.session.WaitSetAccount;
import com.zimbra.cs.session.WaitSetBase;
import com.zimbra.cs.session.WaitSetCallback;
import com.zimbra.cs.session.WaitSetError;
import com.zimbra.cs.session.WaitSetSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SomeAccountsWaitSet
extends WaitSetBase
implements MailboxManager.Listener {
    private long mCbSeqNo = 0L;
    private long mCurrentSeqNo = 1L;
    private HashMap<String, WaitSetAccount> mSessions = new HashMap();

    SomeAccountsWaitSet(String ownerAccountId, String id, int defaultInterest) {
        super(ownerAccountId, id, defaultInterest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WaitSetError> removeAccounts(List<String> accts) {
        ArrayList<WaitSetError> errors = new ArrayList<WaitSetError>();
        for (String id : accts) {
            WaitSetSession session = null;
            SomeAccountsWaitSet someAccountsWaitSet = this;
            synchronized (someAccountsWaitSet) {
                WaitSetAccount wsa = this.mSessions.get(id);
                if (wsa != null) {
                    session = wsa.getSession();
                    this.mSessions.remove(id);
                } else {
                    errors.add(new WaitSetError(id, WaitSetError.Type.NOT_IN_SET_DURING_REMOVE));
                }
            }
            if (session == null) continue;
            assert (!Thread.holdsLock(this));
            session.doCleanup();
        }
        return errors;
    }

    @Override
    public synchronized List<WaitSetError> doWait(WaitSetCallback cb, String lastKnownSeqNo, List<WaitSetAccount> addAccounts, List<WaitSetAccount> updateAccounts) throws ServiceException {
        this.cancelExistingCB();
        LinkedList<WaitSetError> errors = new LinkedList<WaitSetError>();
        if (addAccounts != null) {
            errors.addAll(this.addAccounts(addAccounts));
        }
        if (updateAccounts != null) {
            errors.addAll(this.updateAccounts(updateAccounts));
        }
        this.mCb = cb;
        this.mCbSeqNo = Long.parseLong(lastKnownSeqNo);
        this.trySendData();
        return errors;
    }

    @Override
    public void mailboxAvailable(Mailbox mbox) {
        this.mailboxLoaded(mbox);
    }

    @Override
    public void mailboxCreated(Mailbox mbox) {
        this.mailboxLoaded(mbox);
    }

    @Override
    public synchronized void mailboxLoaded(Mailbox mbox) {
        WaitSetError error;
        WaitSetAccount wsa = this.mSessions.get(mbox.getAccountId());
        if (wsa != null && (error = this.initializeWaitSetSession(wsa, mbox)) != null) {
            this.mSessions.remove(wsa.getAccountId());
            this.signalError(error);
        }
    }

    @Override
    public synchronized void mailboxDeleted(String accountId) {
        WaitSetAccount wsa = this.mSessions.get(accountId);
        if (wsa != null) {
            this.mSessions.remove(accountId);
            this.signalError(new WaitSetError(accountId, WaitSetError.Type.MAILBOX_DELETED));
        }
    }

    private synchronized WaitSetError initializeWaitSetSession(WaitSetAccount wsa, Mailbox mbox) {
        WaitSetSession session = wsa.getSession();
        if (session != null && session.getMailbox() != mbox) {
            ZimbraLog.session.warn("SESSION BEING LEAKED? WaitSetSession points to old version of mailbox...possibly leaking this session:", session);
            wsa.cleanupSession();
            session = null;
        }
        if (session == null) {
            return wsa.createSession(mbox, this);
        }
        return null;
    }

    @Override
    protected boolean cbSeqIsCurrent() {
        return this.mCbSeqNo == this.mCurrentSeqNo;
    }

    @Override
    protected String toNextSeqNo() {
        ++this.mCurrentSeqNo;
        return Long.toString(this.mCurrentSeqNo);
    }

    private synchronized List<WaitSetError> updateAccounts(List<WaitSetAccount> updates) {
        ArrayList<WaitSetError> errors = new ArrayList<WaitSetError>();
        for (WaitSetAccount update : updates) {
            WaitSetAccount existing = this.mSessions.get(update.getAccountId());
            if (existing != null) {
                existing.setInterests(update.getInterests());
                existing.setLastKnownSyncToken(update.getLastKnownSyncToken());
                WaitSetSession session = existing.getSession();
                if (session == null) continue;
                session.update(existing.getInterests(), existing.getLastKnownSyncToken());
                continue;
            }
            errors.add(new WaitSetError(update.getAccountId(), WaitSetError.Type.NOT_IN_SET_DURING_UPDATE));
        }
        return errors;
    }

    synchronized List<WaitSetError> addAccounts(List<WaitSetAccount> wsas) throws ServiceException {
        ArrayList<WaitSetError> errors = new ArrayList<WaitSetError>();
        for (WaitSetAccount wsa : wsas) {
            if (!this.mSessions.containsKey(wsa.getAccountId())) {
                this.mSessions.put(wsa.getAccountId(), wsa);
                try {
                    WaitSetError error;
                    Mailbox mbox;
                    MailboxManager.FetchMode fetchMode = MailboxManager.FetchMode.AUTOCREATE;
                    if (wsa.getLastKnownSyncToken() == null) {
                        fetchMode = MailboxManager.FetchMode.ONLY_IF_CACHED;
                    }
                    if ((mbox = MailboxManager.getInstance().getMailboxByAccountId(wsa.getAccountId(), fetchMode)) == null || (error = this.initializeWaitSetSession(wsa, mbox)) == null) continue;
                    errors.add(error);
                }
                catch (ServiceException e) {
                    if (e.getCode() == "account.NO_SUCH_ACCOUNT") {
                        errors.add(new WaitSetError(wsa.getAccountId(), WaitSetError.Type.NO_SUCH_ACCOUNT));
                    } else if (e.getCode() == "service.WRONG_HOST") {
                        errors.add(new WaitSetError(wsa.getAccountId(), WaitSetError.Type.WRONG_HOST_FOR_ACCOUNT));
                    } else {
                        errors.add(new WaitSetError(wsa.getAccountId(), WaitSetError.Type.ERROR_LOADING_MAILBOX));
                    }
                    this.mSessions.remove(wsa);
                }
                continue;
            }
            errors.add(new WaitSetError(wsa.getAccountId(), WaitSetError.Type.ALREADY_IN_SET_DURING_ADD));
        }
        return errors;
    }

    synchronized void cleanupSession(WaitSetSession session) {
        WaitSetAccount acct = this.mSessions.get(session.getAuthenticatedAccountId());
        if (acct != null) {
            acct.cleanupSession();
        }
    }

    @Override
    int countSessions() {
        return this.mSessions.size();
    }

    @Override
    synchronized HashMap<String, WaitSetAccount> destroy() {
        try {
            MailboxManager.getInstance().removeListener(this);
        }
        catch (ServiceException e) {
            ZimbraLog.session.warn((Object)("Caught unexpected ServiceException while destroying WaitSet: " + e), e);
        }
        this.cancelExistingCB();
        HashMap<String, WaitSetAccount> toRet = this.mSessions;
        this.mSessions = new HashMap();
        this.mCurrentSignalledSessions.clear();
        this.mSentSignalledSessions.clear();
        this.mCurrentSeqNo = Long.MAX_VALUE;
        return toRet;
    }

    @Override
    WaitSetCallback getCb() {
        return this.mCb;
    }

    synchronized void unsignalDataReady(WaitSetSession session) {
        if (this.mSessions.containsKey(session.getAuthenticatedAccountId())) {
            this.mCurrentSignalledSessions.remove(session.getAuthenticatedAccountId());
        }
    }

    synchronized void signalDataReady(WaitSetSession session) {
        if (this.mSessions.containsKey(session.getAuthenticatedAccountId()) && this.mCurrentSignalledSessions.add(session.getAuthenticatedAccountId())) {
            this.trySendData();
        }
    }

    @Override
    public synchronized void handleQuery(Element response) {
        super.handleQuery(response);
        response.addAttribute("cbSeqNo", this.mCbSeqNo);
        response.addAttribute("currentSeqNo", this.mCurrentSeqNo);
        for (Map.Entry<String, WaitSetAccount> entry : this.mSessions.entrySet()) {
            WaitSetSession wss;
            Element sessionElt = response.addElement("session");
            WaitSetAccount wsa = entry.getValue();
            assert (wsa.getAccountId().equals(entry.getKey()));
            if (!wsa.getAccountId().equals(entry.getKey())) {
                sessionElt.addAttribute("acctIdError", wsa.getAccountId());
            }
            sessionElt.addAttribute("account", entry.getKey());
            sessionElt.addAttribute("types", WaitSetRequest.expandInterestStr(wsa.getInterests()));
            if (wsa.getLastKnownSyncToken() != null) {
                sessionElt.addAttribute("token", wsa.getLastKnownSyncToken().toString());
            }
            if (wsa.getLastKnownSyncToken() != null) {
                try {
                    Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(wsa.getAccountId(), MailboxManager.FetchMode.ONLY_IF_CACHED);
                    if (mbox != null) {
                        int mboxLastChange = mbox.getLastChangeID();
                        sessionElt.addAttribute("mboxSyncToken", mboxLastChange);
                        sessionElt.addAttribute("mboxSyncTokenDiff", mboxLastChange - wsa.getLastKnownSyncToken().getChangeId());
                    }
                }
                catch (Exception e) {
                    ZimbraLog.session.warn((Object)("Caught exception from MailboxManager in SomeAccountsWaitSet.handleQuery() for accountId" + wsa.getAccountId()), e);
                }
            }
            if ((wss = wsa.getSession()) == null) continue;
            Element wssElt = sessionElt.addElement("WaitSetSession");
            wssElt.addAttribute("interestMask", wss.mInterestMask);
            wssElt.addAttribute("highestChangeId", wss.mHighestChangeId);
            wssElt.addAttribute("lastAccessTime", wss.getLastAccessTime());
            wssElt.addAttribute("creationTime", wss.getCreationTime());
            wssElt.addAttribute("sessionId", wss.getSessionId());
            if (wss.mSyncToken == null) continue;
            wssElt.addAttribute("token", wss.mSyncToken.toString());
        }
    }
}

