/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.session;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.im.IMNotification;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.mailbox.Conversation;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.OperationContextData;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.service.mail.GetFolder;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.cs.session.PendingModifications;
import com.zimbra.cs.session.Session;
import com.zimbra.cs.util.BuildInfo;
import com.zimbra.cs.util.Zimbra;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ProxyTarget;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapSession
extends Session {
    private String mQueryStr = "";
    private String mGroupBy = "";
    private String mSortBy = "";
    private ZimbraQueryResults mQueryResults;
    private int mRecentMessages;
    private long mPreviousAccess = -1L;
    private long mLastWrite = -1L;
    private int mForceRefresh;
    protected LinkedList<QueuedNotifications> mSentChanges = new LinkedList();
    protected QueuedNotifications mChanges = new QueuedNotifications(1);
    private PushChannel mPushChannel = null;
    private boolean mUnregistered;
    private Map<String, DelegateSession> mDelegateSessions = new HashMap<String, DelegateSession>(3);
    private List<RemoteSessionInfo> mRemoteSessions;
    static final long SOAP_SESSION_TIMEOUT_MSEC = (long)Math.max(5, LC.zimbra_session_timeout_soap.intValue()) * 1000L;
    private static final long MINIMUM_PING_RETRY_TIME = 30000L;
    private static final int MAX_QUEUED_NOTIFICATIONS = LC.zimbra_session_max_pending_notifications.intValue();
    private static final int DELEGATED_CONVERSATION_SIZE_LIMIT = 30;
    private static final String A_ID = "id";

    static int getNotificationCount(PendingModifications pms) {
        int count = 0;
        if (pms.deleted != null) {
            count += (pms.deleted.size() + 3) / 4;
        }
        if (pms.created != null) {
            count += pms.created.size();
        }
        if (pms.modified != null) {
            count += pms.modified.size();
        }
        return count;
    }

    public SoapSession(String authenticatedId) {
        super(authenticatedId, Session.Type.SOAP);
    }

    @Override
    public SoapSession register() throws ServiceException {
        super.register();
        Mailbox mbox = this.mMailbox;
        if (mbox != null) {
            this.mRecentMessages = mbox.getRecentMessageCount();
            this.mPreviousAccess = mbox.getLastSoapAccessTime();
            this.mUnregistered = false;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SoapSession unregister() {
        ArrayList<DelegateSession> delegates;
        Mailbox mbox = this.mMailbox;
        if (this.mLastWrite != -1L && mbox != null) {
            try {
                mbox.recordLastSoapAccessTime(this.mLastWrite);
            }
            catch (OutOfMemoryError e) {
                Zimbra.halt("out of memory", e);
            }
            catch (Throwable t) {
                ZimbraLog.session.warn((Object)"exception recording unloaded session's last access time", t);
            }
        }
        Map<String, DelegateSession> map = this.mDelegateSessions;
        synchronized (map) {
            delegates = new ArrayList<DelegateSession>(this.mDelegateSessions.values());
            this.mDelegateSessions.clear();
            this.mUnregistered = true;
        }
        for (DelegateSession ds : delegates) {
            ds.unregister();
        }
        super.unregister();
        return this;
    }

    @Override
    protected boolean isMailboxListener() {
        return true;
    }

    @Override
    protected boolean isRegisteredInCache() {
        return true;
    }

    @Override
    protected boolean isIMListener() {
        return true;
    }

    @Override
    protected long getSessionIdleLifetime() {
        return SOAP_SESSION_TIMEOUT_MSEC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getDelegateSession(String targetAccountId) {
        if (this.mUnregistered || targetAccountId == null) {
            return null;
        }
        try {
            if (!Provisioning.onLocalServer(Provisioning.getInstance().get(Provisioning.AccountBy.id, targetAccountId))) {
                return null;
            }
        }
        catch (ServiceException e) {
            ZimbraLog.session.info((Object)"exception while fetching delegate session", e);
            return null;
        }
        targetAccountId = targetAccountId.toLowerCase();
        if (targetAccountId.equalsIgnoreCase(this.mAuthenticatedAccountId)) {
            return this;
        }
        Map<String, DelegateSession> map = this.mDelegateSessions;
        synchronized (map) {
            if (this.mUnregistered) {
                return null;
            }
            DelegateSession ds = this.mDelegateSessions.get(targetAccountId);
            if (ds == null && (ds = new DelegateSession(this.mAuthenticatedAccountId, targetAccountId).register()) != null) {
                this.mDelegateSessions.put(targetAccountId, ds);
            }
            return ds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDelegateSession(DelegateSession ds) {
        Object object = this.mDelegateSessions;
        synchronized (object) {
            boolean removed;
            if (this.mUnregistered || this.mDelegateSessions.isEmpty()) {
                return;
            }
            boolean bl = removed = this.mDelegateSessions.remove(ds.mTargetAccountId.toLowerCase()) != null;
            if (!removed) {
                return;
            }
        }
        object = this.mSentChanges;
        synchronized (object) {
            this.mForceRefresh = this.mChanges.getSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteSessionId(Server server) {
        SoapSession soapSession = this;
        synchronized (soapSession) {
            if (this.mMailbox == null || this.mRemoteSessions == null || server == null) {
                return null;
            }
            for (RemoteSessionInfo rsi : this.mRemoteSessions) {
                if (!rsi.mServerId.equals(server.getId())) continue;
                return rsi.mSessionId;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerRemoteSessionId(Server server, String sessionId) {
        if (this.mMailbox == null || server == null || sessionId == null) {
            return true;
        }
        String serverId = server.getId().toLowerCase();
        SoapSession soapSession = this;
        synchronized (soapSession) {
            boolean isNewEntry = true;
            if (this.mRemoteSessions == null) {
                this.mRemoteSessions = new LinkedList<RemoteSessionInfo>();
            } else {
                Iterator<RemoteSessionInfo> it = this.mRemoteSessions.iterator();
                while (it.hasNext()) {
                    if (!it.next().mServerId.equals(server.getId())) continue;
                    it.remove();
                    isNewEntry = false;
                }
            }
            this.mRemoteSessions.add(new RemoteSessionInfo(sessionId, serverId, System.currentTimeMillis()));
            return isNewEntry;
        }
    }

    public void handleRemoteNotifications(Server server, Element context) {
        this.handleRemoteNotifications(server, context, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRemoteNotifications(Server server, Element context, boolean ignoreRefresh, boolean isPing) {
        Element eNotify;
        String sessionId;
        if (context == null) {
            return;
        }
        boolean refreshExpected = true;
        Element eSession = context.getOptionalElement("session");
        boolean isSoap = eSession != null && eSession.getAttribute("type", null) == null;
        String string = sessionId = eSession == null ? null : eSession.getAttribute(A_ID, null);
        if (isSoap && sessionId != null && !sessionId.equals("")) {
            refreshExpected = this.registerRemoteSessionId(server, sessionId);
        }
        if (!ignoreRefresh && !refreshExpected && context.getOptionalElement("refresh") != null) {
            this.mForceRefresh = this.getCurrentNotificationSequence();
        }
        if ((eNotify = context.getOptionalElement("notify")) != null) {
            RemoteNotifications rns = new RemoteNotifications(eNotify);
            LinkedList<QueuedNotifications> linkedList = this.mSentChanges;
            synchronized (linkedList) {
                if (!this.skipNotifications(rns.getNotificationCount(), !isPing)) {
                    this.mChanges.addNotification(rns);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pingRemoteSessions(ZimbraSoapContext zsc) {
        long now = System.currentTimeMillis();
        LinkedList<RemoteSessionInfo> needsPing = null;
        SoapSession soapSession = this;
        synchronized (soapSession) {
            if (this.mRemoteSessions == null) {
                return;
            }
            long cutoff = now - this.getSessionIdleLifetime() / 2L;
            for (RemoteSessionInfo rsi : this.mRemoteSessions) {
                if (rsi.mLastRequest >= cutoff || now - rsi.mLastFailedPing <= 30000L) continue;
                if (needsPing == null) {
                    needsPing = new LinkedList<RemoteSessionInfo>();
                }
                needsPing.add(rsi);
            }
        }
        if (needsPing == null) {
            return;
        }
        Provisioning prov = Provisioning.getInstance();
        for (RemoteSessionInfo rsi : needsPing) {
            try {
                Element noop = Element.create(zsc.getRequestProtocol(), MailConstants.NO_OP_REQUEST);
                Server server = prov.getServerById(rsi.mServerId);
                ZimbraSoapContext zscProxy = new ZimbraSoapContext(zsc, this.mAuthenticatedAccountId);
                zscProxy.setProxySession(rsi.mSessionId);
                ProxyTarget proxy = new ProxyTarget(server, zscProxy.getAuthToken(), URLUtil.getSoapURL(server, false));
                proxy.disableRetries().setTimeouts(10000L);
                Pair<Element, Element> envelope = proxy.execute(noop.detach(), zscProxy);
                this.handleRemoteNotifications(server, envelope.getFirst(), true, true);
            }
            catch (ServiceException e) {
                rsi.mLastFailedPing = now;
            }
        }
    }

    public int getRecentMessageCount() {
        return this.mRecentMessages;
    }

    public long getPreviousSessionTime() {
        return this.mPreviousAccess;
    }

    public long getLastWriteAccessTime() {
        return this.mLastWrite == -1L ? this.mPreviousAccess : this.mLastWrite;
    }

    @Override
    public void doEncodeState(Element parent) {
        if (this.mPushChannel != null) {
            parent.addAttribute("push", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterNotificationResult registerNotificationConnection(PushChannel sc) throws ServiceException {
        SoapSession soapSession = this;
        synchronized (soapSession) {
            boolean dataReady;
            if (this.mPushChannel != null) {
                this.mPushChannel.closePushChannel();
                this.mPushChannel = null;
            }
            if (this.mMailbox == null) {
                sc.closePushChannel();
                return RegisterNotificationResult.NO_NOTIFY;
            }
            LinkedList<QueuedNotifications> linkedList = this.mSentChanges;
            synchronized (linkedList) {
                int lastSeqNo = sc.getLastKnownSequence();
                dataReady = this.mChanges.hasNotifications(sc.localChangesOnly());
                if (!dataReady && this.mChanges.getSequence() > lastSeqNo + 1 && !this.mSentChanges.isEmpty()) {
                    for (QueuedNotifications ntfn : this.mSentChanges) {
                        if (ntfn.getSequence() <= lastSeqNo || !ntfn.hasNotifications(sc.localChangesOnly())) continue;
                        dataReady = true;
                        break;
                    }
                }
            }
            if (dataReady) {
                sc.notificationsReady();
                return RegisterNotificationResult.DATA_READY;
            }
            this.mPushChannel = sc;
            return RegisterNotificationResult.BLOCKING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyIM(IMNotification imn) {
        if (imn == null) {
            return;
        }
        LinkedList<QueuedNotifications> linkedList = this.mSentChanges;
        synchronized (linkedList) {
            this.mChanges.addNotification(imn);
        }
        try {
            this.notifyPushChannel(null, true);
        }
        catch (ServiceException e) {
            ZimbraLog.session.warn((Object)"ServiceException in notifyIM", e);
        }
    }

    public void updateLastWrite(Mailbox mbox) {
        boolean firstWrite = this.mLastWrite == -1L;
        this.mLastWrite = System.currentTimeMillis();
        if (firstWrite) {
            try {
                mbox.recordLastSoapAccessTime(this.mLastWrite);
            }
            catch (ServiceException e) {
                ZimbraLog.session.warn((Object)"ServiceException in notifyPendingChanges ", e);
            }
        }
    }

    @Override
    public void notifyPendingChanges(PendingModifications pms, int changeIdxxx, Session source) {
        Mailbox mbox = this.mMailbox;
        if (pms == null || !pms.hasNotifications() || mbox == null) {
            return;
        }
        if (source == this) {
            this.updateLastWrite(mbox);
        } else if (pms.created != null) {
            for (MailItem item : pms.created.values()) {
                if (!(item instanceof Message)) continue;
                boolean isReceived = true;
                if (item.getFolderId() == 4 || item.getFolderId() == 3) {
                    isReceived = false;
                } else if ((item.getFlagBitmask() & Mailbox.NON_DELIVERY_FLAGS) != 0) {
                    isReceived = false;
                } else if (source != null) {
                    isReceived = false;
                }
                if (!isReceived) continue;
                ++this.mRecentMessages;
            }
        }
        this.handleNotifications(pms, source == this);
    }

    void handleNotifications(PendingModifications pms, boolean fromThisSession) {
        try {
            this.cacheNotifications(pms, fromThisSession);
            this.notifyPushChannel(pms, true);
            this.clearCachedQueryResults();
        }
        catch (ServiceException e) {
            ZimbraLog.session.warn((Object)"ServiceException in notifyPendingChanges ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheNotifications(PendingModifications pms, boolean fromThisSession) {
        LinkedList<QueuedNotifications> linkedList = this.mSentChanges;
        synchronized (linkedList) {
            if (!this.skipNotifications(SoapSession.getNotificationCount(pms), fromThisSession)) {
                this.mChanges.addNotification(pms);
            }
        }
    }

    private boolean skipNotifications(int notificationCount, boolean fromThisSession) {
        int currentSequence = this.getCurrentNotificationSequence();
        if (this.mForceRefresh == currentSequence && !fromThisSession) {
            return true;
        }
        if (this.mForceRefresh != currentSequence && MAX_QUEUED_NOTIFICATIONS > 0) {
            int count = notificationCount + this.mChanges.getNotificationCount();
            if (count > MAX_QUEUED_NOTIFICATIONS) {
                this.mChanges.clearMailboxChanges();
                this.mForceRefresh = currentSequence;
            }
            for (QueuedNotifications ntfn : this.mSentChanges) {
                if ((count += ntfn.getNotificationCount()) <= MAX_QUEUED_NOTIFICATIONS) continue;
                ntfn.clearMailboxChanges();
                this.mForceRefresh = Math.max(this.mForceRefresh, ntfn.getSequence());
            }
        }
        return this.mForceRefresh == currentSequence && !fromThisSession;
    }

    public void forcePush() {
        try {
            this.notifyPushChannel(null, false);
        }
        catch (ServiceException e) {
            ZimbraLog.session.warn((Object)"ServiceException in forcePush", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPushChannel(PendingModifications pms, boolean clearChannel) throws ServiceException {
        SoapSession soapSession = this;
        synchronized (soapSession) {
            if (this.mPushChannel == null) {
                return;
            }
            if (this.mPushChannel.localChangesOnly() && pms != null && !pms.overlapsWithAccount(this.mAuthenticatedAccountId)) {
                return;
            }
            this.mPushChannel.notificationsReady();
            if (clearChannel) {
                this.mPushChannel = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requiresRefresh(int lastSequence) {
        LinkedList<QueuedNotifications> linkedList = this.mSentChanges;
        synchronized (linkedList) {
            if (lastSequence <= 0) {
                return this.mForceRefresh == this.getCurrentNotificationSequence();
            }
            return this.mForceRefresh > Math.min(lastSequence, this.getCurrentNotificationSequence());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRefresh(Element ctxt, ZimbraSoapContext zsc) throws ServiceException {
        Mailbox mbox = this.mMailbox;
        if (mbox == null) {
            return;
        }
        LinkedList<QueuedNotifications> linkedList = this.mSentChanges;
        synchronized (linkedList) {
            for (QueuedNotifications ntfn : this.mSentChanges) {
                ntfn.clearMailboxChanges();
            }
        }
        Element eRefresh = ctxt.addUniqueElement("refresh");
        eRefresh.addAttribute("version", BuildInfo.FULL_VERSION, Element.Disposition.CONTENT);
        OperationContext octxt = DocumentHandler.getOperationContext(zsc, this);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        ToXML.encodeMailbox(eRefresh, octxt, mbox);
        List<Tag> tags = mbox.getTagList(octxt);
        if (tags != null && tags.size() > 0) {
            Element eTags = eRefresh.addUniqueElement("tags");
            for (Tag tag : tags) {
                if (tag == null || tag instanceof Flag) continue;
                ToXML.encodeTag(eTags, ifmt, tag);
            }
        }
        Mailbox.FolderNode root = mbox.getFolderTree(octxt, null, false);
        OperationContextData.setNeedGranteeName(octxt, false);
        GetFolder.encodeFolderNode(ifmt, octxt, eRefresh, root);
        HashMap<ItemId, Element> mountpoints = new HashMap<ItemId, Element>();
        this.expandLocalMountpoints(octxt, root, eRefresh.getFactory(), mountpoints);
        this.expandRemoteMountpoints(octxt, zsc, eRefresh.getFactory(), mountpoints);
        if (!mountpoints.isEmpty()) {
            SoapSession.transferMountpointContents(eRefresh.getOptionalElement("folder"), octxt, mountpoints);
        }
    }

    private void expandLocalMountpoints(OperationContext octxt, Mailbox.FolderNode node, Element.ElementFactory factory, Map<ItemId, Element> mountpoints) {
        if (node.mFolder == null || mountpoints == null) {
            return;
        }
        if (node.mFolder instanceof Mountpoint) {
            Mountpoint mpt = (Mountpoint)node.mFolder;
            this.expandLocalMountpoint(octxt, mpt, factory, mountpoints);
        } else {
            for (Mailbox.FolderNode child : node.mSubfolders) {
                this.expandLocalMountpoints(octxt, child, factory, mountpoints);
            }
        }
    }

    private void expandLocalMountpoint(OperationContext octxt, Mountpoint mpt, Element.ElementFactory factory, Map<ItemId, Element> mountpoints) {
        ItemId iidTarget = mpt.getTarget();
        if (mountpoints.containsKey(iidTarget)) {
            return;
        }
        try {
            Provisioning prov = Provisioning.getInstance();
            Account owner = prov.get(Provisioning.AccountBy.id, mpt.getOwnerId(), octxt.getAuthToken());
            if (owner == null || owner.getId().equals(this.mAuthenticatedAccountId)) {
                return;
            }
            if (!Provisioning.onLocalServer(owner)) {
                mountpoints.put(iidTarget, null);
                return;
            }
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(owner);
            Mailbox.FolderNode remote = mbox.getFolderTree(octxt, new ItemId(mbox, mpt.getRemoteId()), false);
            if (remote != null && remote.mFolder != null && !remote.mFolder.isHidden()) {
                ItemIdFormatter ifmt = new ItemIdFormatter(octxt.getAuthenticatedUser(), mbox, false);
                if (OperationContextData.getNeedGranteeName(octxt)) {
                    OperationContextData.addGranteeNames(octxt, remote);
                }
                Element subhierarchy = GetFolder.encodeFolderNode(ifmt, octxt, factory.createElement("ignored"), remote).detach();
                mountpoints.put(iidTarget, subhierarchy);
                this.getDelegateSession(mpt.getOwnerId());
            }
        }
        catch (ServiceException e) {
            return;
        }
    }

    private void expandRemoteMountpoints(OperationContext octxt, ZimbraSoapContext zsc, Element.ElementFactory factory, Map<ItemId, Element> mountpoints) {
        HashMap<String, Server> remoteServers = null;
        Provisioning prov = Provisioning.getInstance();
        for (Map.Entry<ItemId, Element> mptinfo : mountpoints.entrySet()) {
            try {
                Server server;
                Account owner;
                if (mptinfo.getValue() != null || (owner = prov.get(Provisioning.AccountBy.id, mptinfo.getKey().getAccountId(), zsc.getAuthToken())) == null || (server = prov.getServer(owner)) == null) continue;
                if (remoteServers == null) {
                    remoteServers = new HashMap<String, Server>(3);
                }
                remoteServers.put(owner.getId(), server);
            }
            catch (ServiceException e) {}
        }
        if (remoteServers != null && !remoteServers.isEmpty()) {
            Map<String, Element> remoteHierarchies = this.fetchRemoteHierarchies(octxt, zsc, (Map<String, Server>)remoteServers);
            for (Map.Entry<ItemId, Element> mptinfo : mountpoints.entrySet()) {
                if (mptinfo.getValue() != null) continue;
                ItemId iid = mptinfo.getKey();
                mptinfo.setValue(SoapSession.findRemoteFolder(iid.toString(this.mAuthenticatedAccountId), remoteHierarchies.get(iid.getAccountId())));
            }
        }
    }

    private Map<String, Element> fetchRemoteHierarchies(OperationContext octxt, ZimbraSoapContext zsc, Map<String, Server> remoteServers) {
        Element noop;
        HashMap<String, Element> hierarchies = new HashMap<String, Element>();
        try {
            noop = Element.create(zsc.getRequestProtocol(), MailConstants.GET_FOLDER_REQUEST).addAttribute("visible", true);
            if (!OperationContextData.getNeedGranteeName(octxt)) {
                noop.addAttribute("needGranteeName", false);
            }
        }
        catch (ServiceException e) {
            return hierarchies;
        }
        for (Map.Entry<String, Server> remote : remoteServers.entrySet()) {
            String accountId = remote.getKey();
            Server server = remote.getValue();
            try {
                ZimbraSoapContext zscProxy = new ZimbraSoapContext(zsc, accountId);
                zscProxy.setProxySession(this.getRemoteSessionId(server));
                ProxyTarget proxy = new ProxyTarget(server, zscProxy.getAuthToken(), URLUtil.getSoapURL(server, false));
                proxy.disableRetries().setTimeouts(10000L);
                Pair<Element, Element> envelope = proxy.execute(noop.detach(), zscProxy);
                this.handleRemoteNotifications(server, envelope.getFirst(), true, true);
                hierarchies.put(accountId, envelope.getSecond().getOptionalElement("folder"));
            }
            catch (ServiceException e) {}
        }
        return hierarchies;
    }

    private static Element findRemoteFolder(String id, Element eFolder) {
        if (id == null || eFolder == null) {
            return null;
        }
        if (id.equalsIgnoreCase(eFolder.getAttribute(A_ID, null))) {
            boolean isStub = eFolder.getAttribute("s", null) == null;
            return isStub ? null : eFolder.clone();
        }
        for (Element eSubfolder : eFolder.listElements()) {
            Element match = SoapSession.findRemoteFolder(id, eSubfolder);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private static void transferMountpointContents(Element elem, OperationContext octxt, Map<ItemId, Element> mountpoints) throws ServiceException {
        if (elem == null) {
            return;
        }
        Element target = null;
        if (elem.getName().equals("link")) {
            ItemId iidTarget = new ItemId(elem.getAttribute("zid", null), (int)elem.getAttributeLong("rid", -1L));
            target = mountpoints.get(iidTarget);
        }
        if (target == null) {
            for (Element child : elem.listElements()) {
                SoapSession.transferMountpointContents(child, octxt, mountpoints);
            }
        } else {
            SoapSession.transferMountpointContents(elem, target);
        }
    }

    public static void transferMountpointContents(Element elem, Element mptTarget) {
        SoapSession.transferLongAttribute(elem, mptTarget, "u");
        SoapSession.transferLongAttribute(elem, mptTarget, "n");
        SoapSession.transferLongAttribute(elem, mptTarget, "s");
        elem.addAttribute("url", mptTarget.getAttribute("url", null));
        elem.addAttribute("perm", mptTarget.getAttribute("perm", null));
        if (mptTarget.getAttribute("f", "").indexOf("u") != -1) {
            elem.addAttribute("f", "u" + elem.getAttribute("f", "").replace("u", ""));
        }
        for (Element child : mptTarget.listElements()) {
            if (child.getName().equals("acl")) {
                elem.addUniqueElement(child.clone());
                continue;
            }
            elem.addElement(child.clone());
        }
    }

    private static void transferLongAttribute(Element to, Element from, String attrName) {
        try {
            long remote = from.getAttributeLong(attrName, -1L);
            if (remote >= 0L) {
                to.addAttribute(attrName, remote);
            }
        }
        catch (ServiceException e) {
            ZimbraLog.session.warn((Object)("exception reading long attr from remote folder: " + attrName), e);
        }
        catch (Element.ContainerException e) {
            ZimbraLog.session.warn((Object)("exception adding remote folder attr to serialized mountpoint: " + attrName), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentNotificationSequence() {
        LinkedList<QueuedNotifications> linkedList = this.mSentChanges;
        synchronized (linkedList) {
            return this.mChanges.getSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeNotifications(int sequence) {
        LinkedList<QueuedNotifications> linkedList = this.mSentChanges;
        synchronized (linkedList) {
            if (this.mSentChanges == null || this.mSentChanges.isEmpty()) {
                return;
            }
            if (sequence <= 0) {
                this.mSentChanges.clear();
            } else {
                Iterator it = this.mSentChanges.iterator();
                while (it.hasNext() && ((QueuedNotifications)it.next()).getSequence() <= sequence) {
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element putNotifications(Element ctxt, ZimbraSoapContext zsc, int lastSequence) {
        LinkedList<QueuedNotifications> notifications;
        Mailbox mbox = this.mMailbox;
        if (ctxt == null || mbox == null) {
            return null;
        }
        if (Provisioning.getInstance().allowsPingRemote()) {
            this.pingRemoteSessions(zsc);
        }
        LinkedList<QueuedNotifications> linkedList = this.mSentChanges;
        synchronized (linkedList) {
            ctxt.addUniqueElement("change").addAttribute("token", mbox.getLastChangeID());
            this.acknowledgeNotifications(lastSequence);
            if (this.mSentChanges.size() > 20) {
                ZimbraLog.session.warn("clearing abnormally long notification change list due to misbehaving client");
                this.mSentChanges.clear();
            }
            if (this.mChanges.hasNotifications() || this.requiresRefresh(lastSequence)) {
                assert (this.mChanges.getSequence() >= 1);
                int newSequence = this.mChanges.getSequence() + 1;
                this.mSentChanges.add(this.mChanges);
                this.mChanges = new QueuedNotifications(newSequence);
            }
            assert (!this.mChanges.hasNotifications());
            if (this.mSentChanges.isEmpty()) {
                return ctxt;
            }
            notifications = new LinkedList<QueuedNotifications>(this.mSentChanges);
        }
        QueuedNotifications last = notifications.getLast();
        for (QueuedNotifications ntfn : notifications) {
            if (!ntfn.hasNotifications() && ntfn != last) continue;
            this.putQueuedNotifications(mbox, ntfn, ctxt, zsc);
        }
        return ctxt;
    }

    protected void putQueuedNotifications(Mailbox mbox, QueuedNotifications ntfn, Element parent, ZimbraSoapContext zsc) {
        boolean hasRemoteModifies;
        boolean hasRemoteCreates;
        Element eNotify = parent.addElement("notify");
        if (ntfn.getSequence() > 0) {
            eNotify.addAttribute("seq", ntfn.getSequence());
        }
        OperationContext octxt = null;
        try {
            octxt = DocumentHandler.getOperationContext(zsc, this);
        }
        catch (ServiceException e) {
            ZimbraLog.session.warn((Object)("error fetching operation context for: " + zsc.getAuthtokenAccountId()), e);
            return;
        }
        PendingModifications pms = ntfn.mMailboxChanges;
        RemoteNotifications rns = ntfn.mRemoteChanges;
        ntfn.mRemoteChanges = null;
        Element eDeleted = eNotify.addUniqueElement("deleted");
        StringBuilder deletedIds = new StringBuilder();
        if (pms != null && pms.deleted != null && pms.deleted.size() > 0) {
            for (PendingModifications.ModificationKey mkey : pms.deleted.keySet()) {
                this.addDeletedNotification(mkey, deletedIds);
            }
        }
        if (rns != null && rns.deleted != null) {
            deletedIds.append(deletedIds.length() == 0 ? "" : ",").append(rns.deleted);
        }
        boolean hasLocalCreates = pms != null && pms.created != null && !pms.created.isEmpty();
        boolean bl = hasRemoteCreates = rns != null && rns.created != null && !rns.created.isEmpty();
        if (hasLocalCreates || hasRemoteCreates) {
            Element eCreated = eNotify.addUniqueElement("created");
            if (hasLocalCreates) {
                for (MailItem item : pms.created.values()) {
                    ItemIdFormatter ifmt = new ItemIdFormatter(this.mAuthenticatedAccountId, item.getMailbox(), false);
                    try {
                        Element elem = ToXML.encodeItem(eCreated, ifmt, octxt, item, -4194305);
                        if (!(item instanceof Mountpoint) || mbox != item.getMailbox()) continue;
                        HashMap<ItemId, Element> mountpoints = new HashMap<ItemId, Element>(2);
                        this.expandLocalMountpoint(octxt, (Mountpoint)item, eCreated.getFactory(), mountpoints);
                        this.expandRemoteMountpoints(octxt, zsc, eCreated.getFactory(), mountpoints);
                        SoapSession.transferMountpointContents(elem, octxt, mountpoints);
                    }
                    catch (ServiceException e) {
                        ZimbraLog.session.warn((Object)("error encoding item " + item.getId()), e);
                        return;
                    }
                }
            }
            if (hasRemoteCreates) {
                for (Element elt : rns.created) {
                    eCreated.addElement(elt.detach());
                }
            }
        }
        boolean hasLocalModifies = pms != null && pms.modified != null && !pms.modified.isEmpty();
        boolean bl2 = hasRemoteModifies = rns != null && rns.modified != null && !rns.modified.isEmpty();
        if (hasLocalModifies || hasRemoteModifies) {
            Element eModified = eNotify.addUniqueElement("modified");
            if (hasLocalModifies) {
                for (PendingModifications.Change chg : pms.modified.values()) {
                    if (chg.why != 0 && chg.what instanceof MailItem) {
                        MailItem item = (MailItem)chg.what;
                        if (mbox != item.getMailbox() && item instanceof Conversation && ((Conversation)item).getMessageCount() > 30) continue;
                        ItemIdFormatter ifmt = new ItemIdFormatter(this.mAuthenticatedAccountId, item.getMailbox(), false);
                        try {
                            Element elt = ToXML.encodeItem(eModified, ifmt, octxt, item, chg.why);
                            if (elt != null) continue;
                            this.addDeletedNotification(new PendingModifications.ModificationKey(item), deletedIds);
                            continue;
                        }
                        catch (ServiceException e) {
                            ZimbraLog.session.warn((Object)("error encoding item " + item.getId()), e);
                            return;
                        }
                    }
                    if (chg.why == 0 || !(chg.what instanceof Mailbox)) continue;
                    ToXML.encodeMailbox(eModified, octxt, (Mailbox)chg.what, chg.why);
                }
            }
            if (hasRemoteModifies) {
                for (Element elt : rns.modified) {
                    eModified.addElement(elt.detach());
                }
            }
        }
        if (ntfn.mIMNotifications != null && ntfn.mIMNotifications.size() > 0) {
            Element eIM = eNotify.addUniqueElement("im");
            for (IMNotification imn : ntfn.mIMNotifications) {
                try {
                    imn.toXml(eIM);
                }
                catch (ServiceException e) {
                    ZimbraLog.session.warn((Object)"error serializing IM notification; skipping", e);
                }
            }
        }
        if (deletedIds == null || deletedIds.length() == 0) {
            eDeleted.detach();
        } else {
            eDeleted.addAttribute(A_ID, deletedIds.toString());
        }
    }

    private void addDeletedNotification(PendingModifications.ModificationKey mkey, StringBuilder deletedIds) {
        if (deletedIds.length() != 0) {
            deletedIds.append(',');
        }
        if (!mkey.getAccountId().equals(this.mAuthenticatedAccountId)) {
            deletedIds.append(mkey.getAccountId()).append(':');
        }
        deletedIds.append(mkey.getItemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCachedQueryResults() throws ServiceException {
        SoapSession soapSession = this;
        synchronized (soapSession) {
            try {
                if (this.mQueryResults != null) {
                    this.mQueryResults.doneWithSearchResults();
                }
                Object var3_2 = null;
                this.mQueryStr = "";
                this.mGroupBy = "";
                this.mSortBy = "";
                this.mQueryResults = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.mQueryStr = "";
                this.mGroupBy = "";
                this.mSortBy = "";
                this.mQueryResults = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putQueryResults(String queryStr, String groupBy, String sortBy, ZimbraQueryResults res) throws ServiceException {
        SoapSession soapSession = this;
        synchronized (soapSession) {
            this.clearCachedQueryResults();
            this.mQueryStr = queryStr;
            this.mGroupBy = groupBy;
            this.mSortBy = sortBy;
            this.mQueryResults = res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZimbraQueryResults getQueryResults(String queryStr, String groupBy, String sortBy) {
        SoapSession soapSession = this;
        synchronized (soapSession) {
            if (this.mQueryStr.equals(queryStr) && this.mGroupBy.equals(groupBy) && this.mSortBy.equals(sortBy)) {
                return this.mQueryResults;
            }
            return null;
        }
    }

    @Override
    public void cleanup() {
        try {
            this.clearCachedQueryResults();
        }
        catch (ServiceException e) {
            ZimbraLog.session.warn((Object)"ServiceException while cleaning up Session", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RegisterNotificationResult {
        NO_NOTIFY,
        DATA_READY,
        BLOCKING;

    }

    public static interface PushChannel {
        public void closePushChannel();

        public int getLastKnownSequence();

        public ZimbraSoapContext getSoapContext();

        public boolean localChangesOnly();

        public void notificationsReady() throws ServiceException;
    }

    class QueuedNotifications {
        List<IMNotification> mIMNotifications;
        PendingModifications mMailboxChanges;
        RemoteNotifications mRemoteChanges;
        boolean mHasLocalChanges;
        private int mSequence;

        int getSequence() {
            return this.mSequence;
        }

        QueuedNotifications(int seqno) {
            this.mSequence = seqno;
        }

        boolean hasNotifications() {
            return this.hasNotifications(false);
        }

        boolean hasNotifications(boolean localMailboxOnly) {
            if (localMailboxOnly ? this.mHasLocalChanges : this.mMailboxChanges != null && this.mMailboxChanges.hasNotifications()) {
                return true;
            }
            if (!localMailboxOnly && this.mRemoteChanges != null && this.mRemoteChanges.hasNotifications()) {
                return true;
            }
            return this.mIMNotifications != null && !this.mIMNotifications.isEmpty();
        }

        int getNotificationCount() {
            return (this.mMailboxChanges == null ? 0 : SoapSession.getNotificationCount(this.mMailboxChanges)) + (this.mRemoteChanges == null ? 0 : this.mRemoteChanges.getNotificationCount());
        }

        void addNotification(IMNotification imn) {
            if (this.mIMNotifications == null) {
                this.mIMNotifications = new LinkedList<IMNotification>();
            }
            this.mIMNotifications.add(imn);
        }

        void addNotification(PendingModifications pms) {
            if (pms == null || !pms.hasNotifications()) {
                return;
            }
            if (this.mMailboxChanges == null) {
                this.mMailboxChanges = new PendingModifications();
            }
            this.mMailboxChanges.add(pms);
            if (!this.mHasLocalChanges) {
                this.mHasLocalChanges |= pms.overlapsWithAccount(SoapSession.this.mAuthenticatedAccountId);
            }
        }

        void addNotification(RemoteNotifications rns) {
            if (this.mRemoteChanges == null) {
                this.mRemoteChanges = rns;
            } else {
                this.mRemoteChanges.add(rns);
            }
        }

        void clearMailboxChanges() {
            this.mMailboxChanges = null;
            this.mRemoteChanges = null;
        }
    }

    private static class RemoteNotifications {
        int count = -1;
        String deleted;
        List<Element> created;
        List<Element> modified;

        RemoteNotifications(Element eNotify) {
            if (eNotify == null) {
                return;
            }
            Element eSection = eNotify.getOptionalElement("deleted");
            if (eSection != null) {
                this.deleted = eSection.getAttribute(SoapSession.A_ID, null);
            }
            if ((eSection = eNotify.getOptionalElement("created")) != null) {
                this.created = new ArrayList<Element>(eSection.listElements());
            }
            if ((eSection = eNotify.getOptionalElement("modified")) != null) {
                this.modified = new ArrayList<Element>(eSection.listElements());
            }
        }

        RemoteNotifications add(RemoteNotifications rns) {
            if (rns == null) {
                return this;
            }
            if (this.deleted == null) {
                this.deleted = rns.deleted;
            } else if (rns.deleted != null) {
                this.deleted = this.deleted + "," + rns.deleted;
            }
            if (this.created == null) {
                this.created = rns.created;
            } else if (rns.created != null) {
                this.created.addAll(rns.created);
            }
            if (this.modified == null) {
                this.modified = rns.modified;
            } else if (rns.modified != null) {
                this.modified.addAll(rns.modified);
            }
            this.count = this.count >= 0 && rns.count >= 0 ? this.count + rns.count : -1;
            return this;
        }

        int getNotificationCount() {
            if (this.count == -1) {
                this.count = 0;
                if (this.deleted != null) {
                    this.count += StringUtil.countOccurrences(this.deleted, ',') / 4 + 1;
                }
                if (this.created != null) {
                    this.count += this.created.size();
                }
                if (this.modified != null) {
                    this.count += this.modified.size();
                }
            }
            return this.count;
        }

        boolean hasNotifications() {
            if (this.deleted != null && !this.deleted.equals("")) {
                return true;
            }
            if (this.created != null && !this.created.isEmpty()) {
                return true;
            }
            return this.modified != null && !this.modified.isEmpty();
        }
    }

    private class RemoteSessionInfo {
        final String mServerId;
        final String mSessionId;
        final long mLastRequest;
        long mLastFailedPing;

        RemoteSessionInfo(String sessionId, String serverId, long lastPoll) {
            this.mSessionId = sessionId;
            this.mServerId = serverId;
            this.mLastRequest = lastPoll;
        }
    }

    public class DelegateSession
    extends Session {
        private long mNextFolderCheck;
        private Set<Integer> mVisibleFolderIds;
        private static final int BASIC_CONVERSATION_FLAGS = 7;
        private static final int MODIFIED_CONVERSATION_FLAGS = 2071;

        DelegateSession(String authId, String targetId) {
            super(authId, targetId, Session.Type.SOAP);
        }

        public SoapSession getParentSession() {
            return SoapSession.this;
        }

        public DelegateSession register() {
            try {
                super.register();
                this.calculateVisibleFolders(true);
                return this;
            }
            catch (ServiceException e) {
                this.unregister();
                return null;
            }
        }

        public DelegateSession unregister() {
            super.unregister();
            SoapSession.this.removeDelegateSession(this);
            return this;
        }

        protected boolean isMailboxListener() {
            return true;
        }

        protected boolean isRegisteredInCache() {
            return false;
        }

        protected long getSessionIdleLifetime() {
            return Integer.MAX_VALUE;
        }

        public void cleanup() {
        }

        public void notifyPendingChanges(PendingModifications pms, int changeId, Session source) {
            try {
                if (this.calculateVisibleFolders(false)) {
                    pms = this.filterNotifications(pms);
                }
                if (pms != null && pms.hasNotifications()) {
                    SoapSession.this.handleNotifications(pms, source == this || source == SoapSession.this);
                }
            }
            catch (ServiceException e) {
                ZimbraLog.session.warn((Object)"exception during delegated notifyPendingChanges", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean calculateVisibleFolders(boolean force) throws ServiceException {
            long now = System.currentTimeMillis();
            Mailbox mbox = this.mMailbox;
            if (mbox == null) {
                this.mVisibleFolderIds = Collections.emptySet();
                return true;
            }
            Mailbox mailbox = mbox;
            synchronized (mailbox) {
                if (!force && this.mNextFolderCheck > now) {
                    return this.mVisibleFolderIds != null;
                }
                Set<Folder> visible = mbox.getVisibleFolders(new OperationContext(this.getAuthenticatedAccountId()));
                HashSet<Integer> ids = null;
                if (visible != null) {
                    ids = new HashSet<Integer>(visible.size());
                    for (Folder folder : visible) {
                        ids.add(folder.getId());
                    }
                }
                this.mVisibleFolderIds = ids;
                this.mNextFolderCheck = now + SOAP_SESSION_TIMEOUT_MSEC / 2L;
                return ids != null;
            }
        }

        private boolean folderRecalcRequired(PendingModifications pms) {
            boolean recalc = false;
            if (pms.created != null && !pms.created.isEmpty()) {
                for (MailItem item : pms.created.values()) {
                    if (!(item instanceof Folder)) continue;
                    return true;
                }
            }
            if (!recalc && pms.modified != null && !pms.modified.isEmpty()) {
                for (PendingModifications.Change chg : pms.modified.values()) {
                    if ((chg.why & 0x200100) == 0 || !(chg.what instanceof Folder)) continue;
                    return true;
                }
            }
            return false;
        }

        private PendingModifications filterNotifications(PendingModifications pms) throws ServiceException {
            if (this.folderRecalcRequired(pms) && !this.calculateVisibleFolders(true)) {
                return pms;
            }
            Set<Integer> visible = this.mVisibleFolderIds;
            if (visible == null) {
                return pms;
            }
            PendingModifications filtered = new PendingModifications();
            filtered.changedTypes = pms.changedTypes;
            if (pms.deleted != null && !pms.deleted.isEmpty()) {
                filtered.recordDeleted(pms.deleted.keySet(), pms.changedTypes);
            }
            if (pms.created != null && !pms.created.isEmpty()) {
                for (MailItem item : pms.created.values()) {
                    if (!(item instanceof Conversation) && !visible.contains(item instanceof Folder ? item.getId() : item.getFolderId())) continue;
                    filtered.recordCreated(item);
                }
            }
            if (pms.modified != null && !pms.modified.isEmpty()) {
                for (PendingModifications.Change chg : pms.modified.values()) {
                    boolean moved;
                    if (!(chg.what instanceof MailItem)) continue;
                    MailItem item = (MailItem)chg.what;
                    boolean isVisible = visible.contains(item instanceof Folder ? item.getId() : item.getFolderId());
                    boolean bl = moved = (chg.why & 0x100) != 0;
                    if (item instanceof Conversation) {
                        filtered.recordModified(item, chg.why | 0x817);
                        continue;
                    }
                    if (isVisible) {
                        filtered.recordModified(item, chg.why);
                        if (!(item instanceof Message) || !moved && (chg.why & 7) == 0) continue;
                        this.forceConversationModification((Message)item, pms, filtered, moved ? 2071 : 7);
                        continue;
                    }
                    if (!moved) continue;
                    filtered.recordDeleted(item);
                    if (!(item instanceof Message)) continue;
                    this.forceConversationModification((Message)item, pms, filtered, 2071);
                }
            }
            return filtered;
        }

        private void forceConversationModification(Message msg, PendingModifications pms, PendingModifications filtered, int changeMask) {
            int convId = msg.getConversationId();
            Mailbox mbox = msg.getMailbox();
            PendingModifications.ModificationKey mkey = new PendingModifications.ModificationKey(mbox.getAccountId(), convId);
            PendingModifications.Change existing = null;
            if (pms.created == null || !pms.created.containsKey(mkey)) {
                if (pms.modified != null && (existing = pms.modified.get(mkey)) != null) {
                    filtered.recordModified((MailItem)existing.what, existing.why | changeMask);
                } else {
                    try {
                        filtered.recordModified(mbox.getConversationById(null, convId), changeMask);
                    }
                    catch (OutOfMemoryError e) {
                        Zimbra.halt("out of memory", e);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

