/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.session;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.session.AdminSession;
import com.zimbra.cs.session.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SessionMap {
    private final Session.Type mType;
    private HashMap<String, AccountSessionMap> mAcctSessionMap;
    private HashMap<Long, HashSet<Session>> mSessionAccessSet;
    private int mTotalActiveSessions = 0;

    SessionMap(Session.Type type) {
        this.mType = type;
        this.mAcctSessionMap = new LinkedHashMap<String, AccountSessionMap>(100);
        this.mSessionAccessSet = new HashMap();
    }

    public Session.Type getType() {
        return this.mType;
    }

    public synchronized int totalActiveAccounts() {
        return this.mAcctSessionMap.size();
    }

    public synchronized int totalActiveSessions() {
        return this.mTotalActiveSessions;
    }

    public synchronized int countActiveSessions(String accountId) {
        AccountSessionMap acctMap = this.mAcctSessionMap.get(accountId);
        if (acctMap != null) {
            return this.mAcctSessionMap.size();
        }
        return 0;
    }

    public synchronized Collection<AccountSessionMap> activeAccounts() {
        return Collections.unmodifiableCollection(this.mAcctSessionMap.values());
    }

    public synchronized Session get(String accountId, String sessionId) {
        AccountSessionMap acctMap = this.mAcctSessionMap.get(accountId);
        if (acctMap != null) {
            Session session = (Session)acctMap.get(sessionId);
            if (session != null) {
                this.updateAccessTime(session);
            }
            return session;
        }
        return null;
    }

    public synchronized Session remove(String accountId, String sessionId) {
        AccountSessionMap acctMap = this.mAcctSessionMap.get(accountId);
        if (acctMap != null) {
            Session removed = (Session)acctMap.remove(sessionId);
            if (removed != null) {
                long removedTimeout = removed.getSessionIdleLifetime();
                HashSet<Session> set = this.getSessionAccessSet(removedTimeout);
                assert (set.contains(removed));
                set.remove(removed);
                --this.mTotalActiveSessions;
                if (set.isEmpty()) {
                    this.mSessionAccessSet.remove(removedTimeout);
                }
                if (acctMap.isEmpty()) {
                    this.mAcctSessionMap.remove(accountId);
                }
            }
            return removed;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAndPrune(String accountId, String sessionId, Session session, int maxSessionsPerAcct) {
        ArrayList<Session> dequeued = null;
        SessionMap sessionMap = this;
        synchronized (sessionMap) {
            assert (session != null);
            this.put(accountId, sessionId, session);
            AccountSessionMap acctMap = this.mAcctSessionMap.get(accountId);
            int iterations = 0;
            while (acctMap != null && acctMap.size() > maxSessionsPerAcct) {
                ++iterations;
                long leastRecent = Long.MAX_VALUE;
                String leastRecentId = null;
                for (Map.Entry entry : acctMap.entrySet()) {
                    Session s = (Session)entry.getValue();
                    if (s.getLastAccessTime() >= leastRecent) continue;
                    leastRecent = s.getLastAccessTime();
                    leastRecentId = (String)entry.getKey();
                }
                assert (leastRecentId != null);
                int prevSize = acctMap.size();
                Session removed = this.remove(accountId, leastRecentId);
                if (removed != null) {
                    if (dequeued == null) {
                        dequeued = new ArrayList<Session>(3);
                    }
                    dequeued.add(removed);
                }
                acctMap = this.mAcctSessionMap.get(accountId);
                assert (acctMap == null || acctMap.size() < prevSize);
                if (acctMap.size() <= maxSessionsPerAcct && acctMap.size() < prevSize) continue;
                ZimbraLog.session.warn("Problem in SessionMap.putAndPrune(%d): accountId: %s session: %s  maxPerAcct: %d prevSize: %d finishSize: %d leastRecentTime: %d leastRecentId: %s removed: %s", iterations, accountId, sessionId, maxSessionsPerAcct, prevSize, acctMap.size(), leastRecent, leastRecentId, removed);
                StringBuilder sb = new StringBuilder("SessionMap for account ");
                sb.append(accountId).append(" contains: ");
                for (Map.Entry entry : acctMap.entrySet()) {
                    sb.append("(").append((String)entry.getKey()).append(",").append(((Session)entry.getValue()).toString()).append(" time=").append(((Session)entry.getValue()).getLastAccessTime()).append(") ");
                }
                ZimbraLog.session.warn(sb.toString());
            }
        }
        if (dequeued != null) {
            for (Session removed : dequeued) {
                ZimbraLog.session.debug("Account: %s has too many sessions open of type %s, forcing session %s to close", new Object[]{accountId, session.getType(), removed});
                removed.doCleanup();
            }
        }
    }

    private synchronized Session put(String accountId, String sessionId, Session session) {
        assert (session != null);
        AccountSessionMap acctMap = this.mAcctSessionMap.get(accountId);
        if (acctMap == null) {
            acctMap = new AccountSessionMap();
            this.mAcctSessionMap.put(accountId, acctMap);
        }
        assert (!acctMap.containsKey(sessionId));
        ++this.mTotalActiveSessions;
        Session oldValue = acctMap.put(sessionId, session);
        this.updateAccessTime(session);
        return oldValue;
    }

    private synchronized void updateAccessTime(Session session) {
        HashSet<Session> set = this.getSessionAccessSet(session.getSessionIdleLifetime());
        set.remove(session);
        session.sessionCacheSetLastAccessTime();
        set.add(session);
    }

    synchronized List<Session> copySessionList() {
        ArrayList<Session> toRet = new ArrayList<Session>(this.mTotalActiveSessions);
        for (HashSet<Session> set : this.mSessionAccessSet.values()) {
            toRet.addAll(set);
        }
        return toRet;
    }

    synchronized List<Session> pruneSessionsByTime(long cutoffTime) {
        return this.pruneSessionsInternal(false, cutoffTime);
    }

    synchronized List<Session> pruneAllSessions() {
        return this.pruneSessionsInternal(true, -1L);
    }

    synchronized List<Session> pruneIdleSessions() {
        return this.pruneSessionsInternal(false, -1L);
    }

    private synchronized List<Session> pruneSessionsInternal(boolean all, long cutoffIn) {
        ArrayList<Session> toRet = new ArrayList<Session>();
        long now = System.currentTimeMillis();
        for (Map.Entry<Long, HashSet<Session>> entry : this.mSessionAccessSet.entrySet()) {
            Session s;
            long cutoff = cutoffIn;
            if (all) {
                cutoff = Long.MAX_VALUE;
            } else if (cutoff == -1L) {
                cutoff = now - entry.getKey();
            }
            Iterator<Session> iter = entry.getValue().iterator();
            while (iter.hasNext() && !(s = iter.next()).accessedAfter(cutoff)) {
                toRet.add(s);
                iter.remove();
                --this.mTotalActiveSessions;
                AccountSessionMap acctMap = this.mAcctSessionMap.get(s.getAuthenticatedAccountId());
                Session removed = (Session)acctMap.remove(s.getSessionId());
                assert (removed == s);
                if (removed == null || !acctMap.isEmpty()) continue;
                this.mAcctSessionMap.remove(s.getAuthenticatedAccountId());
            }
        }
        return toRet;
    }

    private synchronized HashSet<Session> getSessionAccessSet(Long timeout) {
        HashSet<Session> toRet = this.mSessionAccessSet.get(timeout);
        if (toRet == null) {
            toRet = new LinkedHashSet<Session>();
            this.mSessionAccessSet.put(timeout, toRet);
        }
        return toRet;
    }

    static boolean unitTest() {
        try {
            SessionMap map = new SessionMap(Session.Type.NULL);
            Session s1 = new AdminSession("a1").testSetSessionId("s1");
            Session s1_2 = new AdminSession("a1").testSetSessionId("s2");
            Session s2 = new AdminSession("a2").testSetSessionId("s1");
            Session s3 = new AdminSession("a3").testSetSessionId("s1");
            Session s4 = new AdminSession("a4").testSetSessionId("s1");
            Session s5 = new AdminSession("a5").testSetSessionId("s1");
            Session s5_2 = new AdminSession("a5").testSetSessionId("s2");
            map.put("a1", "s1", s1);
            map.put("a1", "s2", s1_2);
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                // empty catch block
            }
            map.put("a2", "s1", s2);
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                // empty catch block
            }
            long afterA2 = System.currentTimeMillis();
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                // empty catch block
            }
            map.put("a3", "s1", s3);
            map.put("a4", "s1", s4);
            map.put("a5", "s1", s5);
            map.put("a5", "s2", s5_2);
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (map.totalActiveAccounts() != 5) {
                throw ServiceException.FAILURE("Wrong # accounts active", null);
            }
            if (map.totalActiveSessions() != 7) {
                throw ServiceException.FAILURE("Wrong # active sessions", null);
            }
            Session check = map.get("a2", "s1");
            if (check == null) {
                throw ServiceException.FAILURE("Couldn't find a2_s1 in map", null);
            }
            if (map.totalActiveAccounts() != 5) {
                throw ServiceException.FAILURE("Wrong # accounts active", null);
            }
            if (map.totalActiveSessions() != 7) {
                throw ServiceException.FAILURE("Wrong # active sessions", null);
            }
            List<Session> removed = map.pruneSessionsByTime(afterA2);
            if (removed.isEmpty()) {
                throw ServiceException.FAILURE("Didn't get anything removing afterA2", null);
            }
            boolean hasA1S1 = false;
            boolean hasA1S2 = false;
            boolean hasA2 = false;
            for (Session s : removed) {
                if (s.getAuthenticatedAccountId().equals("a1")) {
                    if (s.getSessionId().equals("s1")) {
                        hasA1S1 = true;
                    }
                    if (s.getSessionId().equals("s2")) {
                        hasA1S2 = true;
                    }
                }
                if (!s.getAuthenticatedAccountId().equals("a2")) continue;
                hasA2 = true;
            }
            if (!hasA1S1) {
                throw ServiceException.FAILURE("Missing a1_s1!", null);
            }
            if (!hasA1S2) {
                throw ServiceException.FAILURE("Missing a1_s2!", null);
            }
            if (hasA2) {
                throw ServiceException.FAILURE("Found a2 removing afterA2", null);
            }
            if (map.totalActiveAccounts() != 4) {
                throw ServiceException.FAILURE("Wrong # accounts active", null);
            }
            if (map.totalActiveSessions() != 5) {
                throw ServiceException.FAILURE("Wrong # active sessions", null);
            }
            map.remove("a5", "s1");
            if (map.totalActiveAccounts() != 4) {
                throw ServiceException.FAILURE("Wrong # accounts active", null);
            }
            if (map.totalActiveSessions() != 4) {
                throw ServiceException.FAILURE("Wrong # active sessions", null);
            }
            map.remove("a5", "s2");
            if (map.totalActiveAccounts() != 3) {
                throw ServiceException.FAILURE("Wrong # accounts active", null);
            }
            if (map.totalActiveSessions() != 3) {
                throw ServiceException.FAILURE("Wrong # active sessions", null);
            }
            System.out.println("Final session list:");
            for (Session s : map.copySessionList()) {
                System.out.println("\t" + s.getAuthenticatedAccountId() + "_" + s.getSessionId());
            }
            return true;
        }
        catch (ServiceException e) {
            System.err.println("Unit Test Failed: Caught exception: " + e);
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        if (SessionMap.unitTest()) {
            System.out.println("Unit tests succeeded!");
        } else {
            System.out.println("Unit tests FAILED!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AccountSessionMap
    extends HashMap<String, Session> {
        private static final long serialVersionUID = -8141746787729464753L;

        AccountSessionMap() {
            super(4);
        }
    }
}

