/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.session;

import com.zimbra.common.stats.RealtimeStatsCallback;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.session.Session;
import com.zimbra.cs.session.SessionMap;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.cs.util.Zimbra;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionCache {
    private static final long SESSION_SWEEP_INTERVAL_MSEC = 60000L;
    static Log sLog = LogFactory.getLog(SessionCache.class);
    static final SessionMap[] sSessionMaps = new SessionMap[Session.Type.values().length];
    private static boolean sShutdown;
    private static long sContextSeqNo;

    static String registerSession(Session session) {
        if (sShutdown || session == null) {
            return null;
        }
        Session.Type sessionType = session.getSessionType();
        String sessionId = session.getSessionId();
        assert (sessionId != null);
        SessionCache.getSessionMap(sessionType).putAndPrune(session.getAuthenticatedAccountId(), sessionId, session, sessionType.getMaxPerAccount());
        return sessionId;
    }

    public static Session lookup(String sessionId, String accountId) {
        if (sShutdown) {
            return null;
        }
        Session.Type type = SessionCache.getSessionTypeFromId(sessionId);
        Session s = SessionCache.getSessionMap(type).get(accountId, sessionId);
        if (s == null && ZimbraLog.session.isDebugEnabled()) {
            ZimbraLog.session.debug("no session with id " + sessionId + " found (accountId: " + accountId + ")");
        }
        return s;
    }

    public static void clearSession(Session session) {
        Session target = SessionCache.unregisterSession(session);
        if (target == null) {
            return;
        }
        Session.Type type = target.getSessionType();
        if (target != null) {
            assert (!Thread.holdsLock(SessionCache.getSessionMap(type)));
            target.doCleanup();
        }
    }

    public static Session unregisterSession(Session session) {
        if (sShutdown || session == null || !session.isAddedToSessionCache()) {
            return null;
        }
        if (ZimbraLog.session.isDebugEnabled()) {
            ZimbraLog.session.debug("Unregistering session " + session.getSessionId());
        }
        Session.Type type = session.getSessionType();
        return SessionCache.getSessionMap(type).remove(session.getAuthenticatedAccountId(), session.getSessionId());
    }

    public static void startup() {
        Zimbra.sTimer.schedule((TimerTask)new SweepMapTimerTask(), 30000L, 60000L);
        ZimbraPerf.addStatsCallback(new StatsCallback());
    }

    public static void shutdown() {
        sShutdown = true;
        for (SessionMap sessionMap : sSessionMaps) {
            List<Session> list = sessionMap.pruneSessionsByTime(Long.MAX_VALUE);
            for (Session s : list) {
                assert (!Thread.holdsLock(sessionMap));
                s.doCleanup();
            }
        }
    }

    private static final Session.Type getSessionTypeFromId(String sessionId) {
        if (sessionId == null || sessionId.length() < 2) {
            return Session.Type.NULL;
        }
        return Session.Type.values()[Character.digit(sessionId.charAt(0), 10)];
    }

    private static final SessionMap getSessionMap(Session.Type type) {
        return sSessionMaps[type.getIndex()];
    }

    static synchronized String getNextSessionId(Session.Type type) {
        return Integer.toString(type.getIndex()) + Long.toString(sContextSeqNo++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void logActiveSessions() {
        StringBuilder accountList = new StringBuilder();
        StringBuilder manySessionsList = new StringBuilder();
        int totalSessions = 0;
        int totalAccounts = 0;
        int[] sessionTypeCounter = new int[Session.Type.values().length];
        SessionMap[] arr$ = sSessionMaps;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            SessionMap sessionMap;
            SessionMap sessionMap2 = sessionMap = arr$[i$];
            synchronized (sessionMap2) {
                for (SessionMap.AccountSessionMap activeAcct : sessionMap.activeAccounts()) {
                    String accountId = null;
                    ++totalAccounts;
                    int count = 0;
                    for (Session session : activeAcct.values()) {
                        accountId = session.getAuthenticatedAccountId();
                        ++totalSessions;
                        ++count;
                        int n = sessionMap.getType().getIndex();
                        sessionTypeCounter[n] = sessionTypeCounter[n] + 1;
                    }
                    assert (count > 0);
                    if (count <= 0) continue;
                    if (accountList.length() > 0) {
                        accountList.append(',');
                    }
                    accountList.append(accountId).append('(').append(count).append(')');
                    if (count <= 9) continue;
                    if (manySessionsList.length() > 0) {
                        manySessionsList.append(',');
                    }
                    manySessionsList.append(accountId).append('(').append(count).append(')');
                }
                continue;
            }
        }
        if (sLog.isDebugEnabled() && totalSessions > 0) {
            sLog.debug("Detected " + totalSessions + " active sessions.  " + sessionTypeCounter + ".  Accounts: " + accountList);
        }
        if (manySessionsList.length() > 0) {
            ZimbraLog.session.info("Found accounts that have a large number of sessions: " + manySessionsList);
        }
    }

    public static List<Session> getActiveSessions(Session.Type type) {
        return SessionCache.getSessionMap(type).copySessionList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] countActive(Session.Type type) {
        SessionMap sessionMap;
        int[] toRet = new int[2];
        SessionMap sessionMap2 = sessionMap = SessionCache.getSessionMap(type);
        synchronized (sessionMap2) {
            toRet[0] = sessionMap.totalActiveAccounts();
            toRet[1] = sessionMap.totalActiveSessions();
        }
        return toRet;
    }

    static {
        for (Session.Type type : Session.Type.values()) {
            SessionCache.sSessionMaps[type.getIndex()] = new SessionMap(type);
        }
        sShutdown = false;
        sContextSeqNo = 1L;
    }

    private static final class SweepMapTimerTask
    extends TimerTask {
        private SweepMapTimerTask() {
        }

        public void run() {
            try {
                if (sLog.isDebugEnabled()) {
                    SessionCache.logActiveSessions();
                }
                int[] removedByType = new int[Session.Type.values().length];
                int totalActive = 0;
                for (SessionMap sessionMap : sSessionMaps) {
                    List<Session> toReap = sessionMap.pruneIdleSessions();
                    totalActive += sessionMap.totalActiveSessions();
                    int n = sessionMap.getType().getIndex();
                    removedByType[n] = removedByType[n] + toReap.size();
                    for (Session s : toReap) {
                        if (ZimbraLog.session.isDebugEnabled()) {
                            ZimbraLog.session.debug("Removing cached session: " + s);
                        }
                        assert (!Thread.holdsLock(sessionMap));
                        s.doCleanup();
                    }
                }
                int totalRemoved = 0;
                for (int r : removedByType) {
                    totalRemoved += r;
                }
                if (sLog.isInfoEnabled() && totalRemoved > 0) {
                    StringBuilder sb = new StringBuilder("Removed ").append(totalRemoved).append(" idle sessions (");
                    StringBuilder typeStr = new StringBuilder();
                    for (int i = 1; i < removedByType.length; ++i) {
                        if (removedByType[i] <= 0) continue;
                        if (typeStr.length() > 0) {
                            typeStr.append(", ");
                        }
                        typeStr.append(Session.Type.values()[i].name());
                    }
                    sb.append((CharSequence)typeStr).append("). ").append(totalActive).append(" active sessions remain.");
                    sLog.info(sb.toString());
                }
            }
            catch (Throwable e) {
                if (e instanceof OutOfMemoryError) {
                    Zimbra.halt("Caught out of memory error", e);
                }
                ZimbraLog.session.warn((Object)"Caught exception in SessionCache timer", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StatsCallback
    implements RealtimeStatsCallback {
        private StatsCallback() {
        }

        @Override
        public Map<String, Object> getStatData() {
            HashMap<String, Object> data = new HashMap<String, Object>();
            SessionMap soapMap = SessionCache.getSessionMap(Session.Type.SOAP);
            data.put("soap_sessions", soapMap.totalActiveSessions());
            return data;
        }
    }
}

