/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.session;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.im.IMNotification;
import com.zimbra.cs.im.IMPersona;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.operation.Operation;
import com.zimbra.cs.session.PendingModifications;
import com.zimbra.cs.session.SessionCache;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Session {
    protected final String mAuthenticatedAccountId;
    protected final String mTargetAccountId;
    private final Type mSessionType;
    private String mSessionId;
    protected Mailbox mMailbox;
    private IMPersona mPersona;
    private long mLastAccessed;
    private long mCreationTime;
    private boolean mCleanedUp = false;
    private boolean mIsRegistered = false;
    private boolean mAddedToCache = false;
    public static final int OPERATION_HISTORY_LENGTH = 6;
    public static final int OPERATION_HISTORY_TIME = 10000;
    private List<RecentOperation> mRecentOperations = new LinkedList<RecentOperation>();

    public Session(String accountId, Type type) {
        this(accountId, accountId, type);
    }

    public Session(String authId, String targetId, Type type) {
        this.mAuthenticatedAccountId = authId;
        this.mTargetAccountId = targetId == null ? authId : targetId;
        this.mSessionType = type;
        this.mLastAccessed = this.mCreationTime = System.currentTimeMillis();
        this.mSessionId = SessionCache.getNextSessionId(this.mSessionType);
    }

    public Type getType() {
        return this.mSessionType;
    }

    public synchronized void registerWithIM(IMPersona persona) throws ServiceException {
        assert (Thread.holdsLock(persona.getLock()));
        assert (this.mPersona == null || this.mPersona == persona);
        if (this.mPersona == null && this.isIMListener() && !this.isDelegatedSession()) {
            this.mPersona = persona;
            this.mPersona.addListener(this);
        }
    }

    public Session register() throws ServiceException {
        Mailbox mbox;
        if (this.mIsRegistered) {
            return this;
        }
        if (this.isMailboxListener() && (mbox = (this.mMailbox = MailboxManager.getInstance().getMailboxByAccountId(this.mTargetAccountId))) != null) {
            mbox.addListener(this);
        }
        if (this.isRegisteredInCache()) {
            SessionCache.registerSession(this);
            this.mAddedToCache = true;
        }
        this.mIsRegistered = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session unregister() {
        Mailbox mbox = this.mMailbox;
        assert (mbox == null || Thread.holdsLock(mbox) || !Thread.holdsLock(this));
        IMPersona persona = null;
        Session session = this;
        synchronized (session) {
            persona = this.mPersona;
            this.mPersona = null;
        }
        if (persona != null) {
            persona.removeListener(this);
        }
        if (mbox != null && this.isMailboxListener()) {
            mbox.removeListener(this);
            this.mMailbox = null;
        }
        if (this.mIsRegistered && this.isRegisteredInCache()) {
            SessionCache.unregisterSession(this);
            this.mAddedToCache = false;
        }
        this.mIsRegistered = false;
        return this;
    }

    protected boolean isIMListener() {
        return false;
    }

    protected abstract boolean isMailboxListener();

    protected abstract boolean isRegisteredInCache();

    public synchronized void logOperation(Operation op) {
        long now = System.currentTimeMillis();
        long cutoff = now - 10000L;
        if (this.mRecentOperations.size() >= 6) {
            this.mRecentOperations.remove(0);
        }
        while (this.mRecentOperations.size() > 0 && this.mRecentOperations.get((int)0).mTimestamp < cutoff) {
            this.mRecentOperations.remove(0);
        }
        this.mRecentOperations.add(new RecentOperation(now, op.getClass()));
    }

    public synchronized List<RecentOperation> getRecentOperations() {
        return this.mRecentOperations;
    }

    public final void encodeState(Element parent) {
        this.doEncodeState(parent);
    }

    protected void doEncodeState(Element parent) {
    }

    public boolean isAddedToSessionCache() {
        return this.mAddedToCache;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    final Session testSetSessionId(String sessionId) {
        this.mSessionId = sessionId;
        return this;
    }

    public Type getSessionType() {
        return this.mSessionType;
    }

    protected abstract long getSessionIdleLifetime();

    public Mailbox getMailbox() {
        return this.mMailbox;
    }

    public abstract void notifyPendingChanges(PendingModifications var1, int var2, Session var3);

    public void notifyIM(IMNotification imn) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doCleanup() {
        if (this.mCleanedUp) {
            return;
        }
        try {
            this.cleanup();
            this.unregister();
            Object var2_1 = null;
            this.mCleanedUp = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mCleanedUp = true;
            throw throwable;
        }
        this.mMailbox = null;
    }

    protected abstract void cleanup();

    public long getLastAccessTime() {
        return this.mLastAccessed;
    }

    public long getCreationTime() {
        return this.mCreationTime;
    }

    public void updateAccessTime() {
        SessionCache.lookup(this.mSessionId, this.mAuthenticatedAccountId);
    }

    void sessionCacheSetLastAccessTime() {
        this.mLastAccessed = System.currentTimeMillis();
    }

    public boolean accessedAfter(long otherTime) {
        return this.mLastAccessed > otherTime;
    }

    public String getAuthenticatedAccountId() {
        return this.mAuthenticatedAccountId;
    }

    public String getTargetAccountId() {
        return this.mTargetAccountId;
    }

    public boolean isDelegatedSession() {
        return !this.mAuthenticatedAccountId.equalsIgnoreCase(this.mTargetAccountId);
    }

    public String toString() {
        String dateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS").format(new Date(this.mLastAccessed));
        return StringUtil.getSimpleClassName(this) + ": {sessionId: " + this.mSessionId + ", accountId: " + this.mAuthenticatedAccountId + ", lastAccessed: " + dateString + "}";
    }

    public static class RecentOperation {
        public long mTimestamp;
        public Class mOperationClass;

        public RecentOperation(long ts, Class oc) {
            this.mTimestamp = ts;
            this.mOperationClass = oc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NULL(0, 0),
        SOAP(1, 5),
        IMAP(2, Math.max(0, LC.zimbra_session_limit_imap.intValue())),
        ADMIN(3, 5),
        WIKI(4, 0),
        SYNCLISTENER(5, 2),
        WAITSET(6, 0);

        private final int mIndex;
        private final int mMaxPerAccount;

        private Type(int index, int maxPerAccount) {
            this.mIndex = index;
            this.mMaxPerAccount = maxPerAccount;
        }

        public final int getIndex() {
            return this.mIndex;
        }

        public final int getMaxPerAccount() {
            return this.mMaxPerAccount;
        }
    }
}

