/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.session;

import com.zimbra.common.util.Pair;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PendingModifications {
    public int changedTypes = 0;
    public LinkedHashMap<ModificationKey, MailItem> created;
    public HashMap<ModificationKey, Change> modified;
    public HashMap<ModificationKey, Object> deleted;

    public boolean hasNotifications() {
        return this.deleted != null && !this.deleted.isEmpty() || this.created != null && !this.created.isEmpty() || this.modified != null && !this.modified.isEmpty();
    }

    public boolean overlapsWithAccount(String accountId) {
        String string = accountId = accountId == null ? null : accountId.toLowerCase();
        if (this.deleted != null) {
            for (ModificationKey mkey : this.deleted.keySet()) {
                if (!mkey.getAccountId().equals(accountId)) continue;
                return true;
            }
        }
        if (this.created != null) {
            for (ModificationKey mkey : this.created.keySet()) {
                if (!mkey.getAccountId().equals(accountId)) continue;
                return true;
            }
        }
        if (this.modified != null) {
            for (ModificationKey mkey : this.modified.keySet()) {
                if (!mkey.getAccountId().equals(accountId)) continue;
                return true;
            }
        }
        return false;
    }

    public void recordCreated(MailItem item) {
        if (this.created == null) {
            this.created = new LinkedHashMap();
        }
        this.changedTypes |= MailItem.typeToBitmask(item.getType());
        this.created.put(new ModificationKey(item), item);
    }

    public void recordDeleted(String accountId, int id, byte type) {
        if (type != 0) {
            this.changedTypes |= MailItem.typeToBitmask(type);
        }
        ModificationKey key = new ModificationKey(accountId, id);
        this.delete(key, key.getItemId());
    }

    public void recordDeleted(String accountId, Collection<Integer> ids, int typesMask) {
        this.changedTypes |= typesMask;
        for (Integer id : ids) {
            ModificationKey key = new ModificationKey(accountId, id);
            this.delete(key, id);
        }
    }

    public void recordDeleted(MailItem item) {
        this.changedTypes |= MailItem.typeToBitmask(item.getType());
        this.delete(new ModificationKey(item), item);
    }

    public void recordDeleted(Collection<ModificationKey> keys, int typesMask) {
        this.changedTypes |= typesMask;
        for (ModificationKey key : keys) {
            this.delete(key, key.getItemId());
        }
    }

    private void delete(ModificationKey key, Object value) {
        if (this.created != null && this.created.remove(key) != null) {
            return;
        }
        if (this.modified != null) {
            this.modified.remove(key);
        }
        if (this.deleted == null) {
            this.deleted = new HashMap();
        }
        this.deleted.put(key, value);
    }

    public void recordModified(Mailbox mbox, int reason) {
        this.recordModified(new ModificationKey(mbox.getAccountId(), 0), mbox, reason);
    }

    public void recordModified(MailItem item, int reason) {
        this.changedTypes |= MailItem.typeToBitmask(item.getType());
        this.recordModified(new ModificationKey(item), item, reason);
    }

    private void recordModified(ModificationKey key, Object item, int reason) {
        Change chg = null;
        if (this.created != null && this.created.containsKey(key)) {
            if (item instanceof MailItem) {
                this.recordCreated((MailItem)item);
            }
            return;
        }
        if (this.deleted != null && this.deleted.containsKey(key)) {
            return;
        }
        if (this.modified == null) {
            this.modified = new HashMap();
        } else {
            chg = this.modified.get(key);
            if (chg != null) {
                chg.what = item;
                chg.why |= reason;
            }
        }
        if (chg == null) {
            chg = new Change(item, reason);
        }
        this.modified.put(key, chg);
    }

    PendingModifications add(PendingModifications other) {
        this.changedTypes |= other.changedTypes;
        if (other.deleted != null) {
            for (ModificationKey key : other.deleted.keySet()) {
                this.delete(key, key.getItemId());
            }
        }
        if (other.created != null) {
            for (MailItem item : other.created.values()) {
                this.recordCreated(item);
            }
        }
        if (other.modified != null) {
            for (Change chg : other.modified.values()) {
                if (chg.what instanceof MailItem) {
                    this.recordModified((MailItem)chg.what, chg.why);
                    continue;
                }
                if (!(chg.what instanceof Mailbox)) continue;
                this.recordModified((Mailbox)chg.what, chg.why);
            }
        }
        return this;
    }

    public void clear() {
        this.created = null;
        this.deleted = null;
        this.modified = null;
        this.changedTypes = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ModificationKey
    extends Pair<String, Integer> {
        public ModificationKey(String first, Integer second) {
            super(first, second);
        }

        public ModificationKey(MailItem item) {
            super(item.getMailbox().getAccountId(), item.getId());
        }

        public String getAccountId() {
            return (String)this.getFirst();
        }

        public Integer getItemId() {
            return (Integer)this.getSecond();
        }
    }

    public static final class Change {
        public static final int UNMODIFIED = 0;
        public static final int MODIFIED_UNREAD = 1;
        public static final int MODIFIED_TAGS = 2;
        public static final int MODIFIED_FLAGS = 4;
        public static final int MODIFIED_CONFIG = 8;
        public static final int MODIFIED_SIZE = 16;
        public static final int MODIFIED_DATE = 32;
        public static final int MODIFIED_SUBJECT = 64;
        public static final int MODIFIED_IMAP_UID = 128;
        public static final int MODIFIED_FOLDER = 256;
        public static final int MODIFIED_PARENT = 512;
        public static final int MODIFIED_CHILDREN = 1024;
        public static final int MODIFIED_SENDERS = 2048;
        public static final int MODIFIED_NAME = 4096;
        public static final int MODIFIED_COLOR = 8192;
        public static final int MODIFIED_POSITION = 16384;
        public static final int MODIFIED_QUERY = 32768;
        public static final int MODIFIED_CONTENT = 65536;
        public static final int MODIFIED_INVITE = 131072;
        public static final int MODIFIED_URL = 262144;
        public static final int MODIFIED_METADATA = 524288;
        public static final int MODIFIED_VIEW = 0x100000;
        public static final int MODIFIED_ACL = 0x200000;
        public static final int MODIFIED_CONFLICT = 0x400000;
        public static final int INTERNAL_ONLY = 0x10000000;
        public static final int ALL_FIELDS = -1;
        public Object what;
        public int why;

        Change(Object thing, int reason) {
            this.what = thing;
            this.why = reason;
        }
    }
}

