/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.session;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.CommitId;
import com.zimbra.cs.redolog.RedoLogManager;
import com.zimbra.cs.redolog.RedoLogProvider;
import com.zimbra.cs.session.WaitSetAccount;
import com.zimbra.cs.session.WaitSetBase;
import com.zimbra.cs.session.WaitSetCallback;
import com.zimbra.cs.session.WaitSetError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AllAccountsWaitSet
extends WaitSetBase {
    private static Map<AllAccountsWaitSet, String> sAllAccountsWaitSets = new ConcurrentHashMap<AllAccountsWaitSet, String>();
    private static volatile int sInterestMask = 0;
    private List<Pair<String, String>> mBufferedCommits;
    private String mCbSeqNo = "0";
    private String mCurrentSeqNo = "0";
    private String mNextSeqNo;

    public static final void mailboxChangeCommitted(String commitIdStr, String accountId, int changedTypesMask) {
        if ((changedTypesMask & sInterestMask) != 0) {
            for (AllAccountsWaitSet ws : sAllAccountsWaitSets.keySet()) {
                ws.onMailboxChangeCommitted(commitIdStr, accountId, changedTypesMask);
            }
        }
    }

    public static final boolean isCallbackNecessary(int changeMask) {
        return (changeMask & sInterestMask) != 0;
    }

    static AllAccountsWaitSet create(String ownerAccountId, String id, int defaultInterest) {
        return new AllAccountsWaitSet(ownerAccountId, id, defaultInterest, false);
    }

    static AllAccountsWaitSet createWithSeqNo(String ownerAccountId, String id, int defaultInterest, String lastKnownSeqNo) throws ServiceException {
        AllAccountsWaitSet ws = new AllAccountsWaitSet(ownerAccountId, id, defaultInterest, true);
        try {
            ws.syncToCommitId(lastKnownSeqNo);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Caught IOException when syncing waitset to specified commit ID", e);
        }
        return ws;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllAccountsWaitSet(String ownerAccountId, String id, int defaultInterest, boolean bufferCommitsAtCreate) {
        super(ownerAccountId, id, defaultInterest);
        this.mBufferedCommits = bufferCommitsAtCreate ? new LinkedList<Pair<String, String>>() : null;
        Map<AllAccountsWaitSet, String> map = sAllAccountsWaitSets;
        synchronized (map) {
            sAllAccountsWaitSets.put(this, "");
            int newMask = 0;
            for (AllAccountsWaitSet ws : sAllAccountsWaitSets.keySet()) {
                newMask |= ws.getDefaultInterest();
            }
            sInterestMask = newMask;
        }
    }

    @Override
    public List<WaitSetError> removeAccounts(List<String> removeAccounts) {
        return new ArrayList<WaitSetError>();
    }

    @Override
    public synchronized List<WaitSetError> doWait(WaitSetCallback cb, String lastKnownSeqNo, List<WaitSetAccount> addAccounts, List<WaitSetAccount> updateAccounts) throws ServiceException {
        this.cancelExistingCB();
        this.mCb = cb;
        this.mCbSeqNo = lastKnownSeqNo;
        this.trySendData();
        return new ArrayList<WaitSetError>();
    }

    private synchronized void onMailboxChangeCommitted(String commitIdStr, String accountId, int changedTypesMask) {
        if ((changedTypesMask & this.mDefaultInterest) != 0) {
            if (this.mBufferedCommits != null) {
                this.mBufferedCommits.add(new Pair<String, String>(accountId, commitIdStr));
            } else {
                this.mNextSeqNo = commitIdStr;
                this.mCurrentSignalledSessions.add(accountId);
                this.trySendData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncToCommitId(String commitIdStr) throws ServiceException, IOException {
        CommitId cid;
        assert (this.mBufferedCommits != null);
        assert (!Thread.holdsLock(this));
        RedoLogManager rmgr = RedoLogProvider.getInstance().getRedoLogManager();
        Pair<Set<Long>, CommitId> changes = rmgr.getChangedMailboxesSince(cid = CommitId.decodeFromString(commitIdStr));
        if (changes == null) {
            throw ServiceException.FAILURE("Unable to sync to commit id " + commitIdStr, null);
        }
        Set<Long> mailboxes = changes.getFirst();
        for (Long id : mailboxes) {
            try {
                Mailbox mbox = MailboxManager.getInstance().getMailboxById(id);
                if (mbox == null) continue;
                String accountId = mbox.getAccountId();
                AllAccountsWaitSet allAccountsWaitSet = this;
                synchronized (allAccountsWaitSet) {
                    this.mCurrentSignalledSessions.add(accountId);
                }
            }
            catch (ServiceException e) {
                ZimbraLog.session.warn("AllAccountsWaitSet skipping notification of mailbox id %d because we could not fetch it", (Object)id, e);
            }
        }
        this.mNextSeqNo = changes.getSecond().encodeToString();
        AllAccountsWaitSet allAccountsWaitSet = this;
        synchronized (allAccountsWaitSet) {
            for (Pair<String, String> p : this.mBufferedCommits) {
                this.mCurrentSignalledSessions.add(p.getFirst());
                this.mNextSeqNo = p.getSecond();
            }
            this.mBufferedCommits = null;
            if (this.mCurrentSignalledSessions.size() > 0) {
                this.trySendData();
            }
        }
    }

    @Override
    protected boolean cbSeqIsCurrent() {
        return this.mCurrentSeqNo.equals(this.mCbSeqNo);
    }

    @Override
    protected String toNextSeqNo() {
        this.mCurrentSeqNo = this.mNextSeqNo;
        assert (this.mCurrentSeqNo != null);
        return this.mCurrentSeqNo;
    }

    @Override
    int countSessions() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    HashMap<String, WaitSetAccount> destroy() {
        Map<AllAccountsWaitSet, String> map = sAllAccountsWaitSets;
        synchronized (map) {
            sAllAccountsWaitSets.remove(this);
            int newMask = 0;
            for (AllAccountsWaitSet ws : sAllAccountsWaitSets.keySet()) {
                newMask |= ws.getDefaultInterest();
            }
            sInterestMask = newMask;
        }
        return null;
    }

    @Override
    public synchronized void handleQuery(Element response) {
        super.handleQuery(response);
        response.addAttribute("cbSeqNo", this.mCbSeqNo);
        response.addAttribute("currentSeqNo", this.mCurrentSeqNo);
        response.addAttribute("nextSeqNo", this.mNextSeqNo);
        if (this.mBufferedCommits != null) {
            Element buffElt = response.addElement("buffered");
            for (Pair<String, String> p : this.mBufferedCommits) {
                Element e = buffElt.addElement("commit");
                e.addAttribute("aid", p.getFirst());
                e.addAttribute("cid", p.getSecond());
            }
        }
    }
}

